/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.MethodSignatureKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ProtectedMemberInFinalClass;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitor", "Lio/gitlab/arturbosch/detekt/rules/style/ProtectedMemberInFinalClass$DeclarationVisitor;", "visitClass", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "hasModifiers", "", "DeclarationVisitor", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nProtectedMemberInFinalClass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtectedMemberInFinalClass.kt\nio/gitlab/arturbosch/detekt/rules/style/ProtectedMemberInFinalClass\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n1863#2,2:82\n1863#2,2:84\n*S KotlinDebug\n*F\n+ 1 ProtectedMemberInFinalClass.kt\nio/gitlab/arturbosch/detekt/rules/style/ProtectedMemberInFinalClass\n*L\n56#1:82,2\n57#1:84,2\n*E\n"})
public final class ProtectedMemberInFinalClass
extends Rule {
    @NotNull
    private final Issue issue;
    @NotNull
    private final DeclarationVisitor visitor;

    public ProtectedMemberInFinalClass(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Warning, "Member with protected visibility in final class is private. Consider using private or internal as modifier.", Debt.Companion.getFIVE_MINS());
        this.visitor = new DeclarationVisitor();
    }

    public /* synthetic */ ProtectedMemberInFinalClass(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitClass(@NotNull KtClass klass) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        if (this.hasModifiers(klass)) {
            Object object;
            KtPrimaryConstructor ktPrimaryConstructor = klass.getPrimaryConstructor();
            if (ktPrimaryConstructor != null) {
                ktPrimaryConstructor.accept(this.visitor);
            }
            if ((object = klass.getBody()) != null && (object = ((KtClassBody)object).getDeclarations()) != null) {
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KtDeclaration it = (KtDeclaration)element$iv;
                    boolean bl = false;
                    it.accept(this.visitor);
                }
            }
            Iterable $this$forEach$iv = klass.getCompanionObjects();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtObjectDeclaration it = (KtObjectDeclaration)element$iv;
                boolean bl = false;
                it.accept(this.visitor);
            }
        }
        super.visitClass(klass);
    }

    private final boolean hasModifiers(KtClass klass) {
        boolean isNotAbstract = !KtPsiUtilKt.isAbstract(klass);
        boolean isFinal = !KtModifierListKt.isOpen(klass);
        boolean isNotSealed = !klass.isSealed();
        boolean isNotEnum = !klass.isEnum();
        return isNotAbstract && isFinal && isNotSealed && isNotEnum;
    }

    public ProtectedMemberInFinalClass() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ProtectedMemberInFinalClass$DeclarationVisitor;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "<init>", "(Lio/gitlab/arturbosch/detekt/rules/style/ProtectedMemberInFinalClass;)V", "visitDeclaration", "", "dcl", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "detekt-rules-style"})
    public final class DeclarationVisitor
    extends DetektVisitor {
        @Override
        public void visitDeclaration(@NotNull KtDeclaration dcl) {
            boolean isJvmFinalizeFunction;
            Intrinsics.checkNotNullParameter(dcl, "dcl");
            boolean bl = isJvmFinalizeFunction = dcl instanceof KtNamedFunction && MethodSignatureKt.isJvmFinalizeFunction((KtNamedFunction)dcl);
            if (KtPsiUtilKt.isProtected(dcl) && !KtModifierListKt.isOverride(dcl) && !isJvmFinalizeFunction) {
                ProtectedMemberInFinalClass.this.report(new CodeSmell(ProtectedMemberInFinalClass.this.getIssue(), Entity.Companion.from$default(Entity.Companion, dcl, 0, 2, null), ProtectedMemberInFinalClass.this.getIssue().getDescription(), null, null, 24, null));
            }
        }
    }
}

