/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.AbbreviatedType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/RedundantExplicitType;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitProperty", "", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "typeIsSameAs", "", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "detekt-rules-style"})
public final class RedundantExplicitType
extends Rule {
    @NotNull
    private final Issue issue;

    public RedundantExplicitType(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("RedundantExplicitType", Severity.Style, "Type does not need to be stated explicitly and can be removed.", Debt.Companion.getFIVE_MINS());
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter(property, "property");
        if (!property.isLocal()) {
            return;
        }
        KtTypeReference ktTypeReference = property.getTypeReference();
        if (ktTypeReference == null) {
            return;
        }
        KtTypeReference typeReference = ktTypeReference;
        Annotated annotated = (VariableDescriptor)this.getBindingContext().get(BindingContext.VARIABLE, property);
        if (annotated == null || (annotated = annotated.getType()) == null) {
            return;
        }
        Annotated type2 = annotated;
        if (type2 instanceof AbbreviatedType) {
            return;
        }
        KtExpression initializer = property.getInitializer();
        if (initializer instanceof KtConstantExpression) {
            if (!this.typeIsSameAs((KtConstantExpression)initializer, (KotlinType)type2)) {
                return;
            }
        } else if (initializer instanceof KtStringTemplateExpression) {
            if (!KotlinBuiltIns.isString((KotlinType)type2)) {
                return;
            }
        } else if (initializer instanceof KtNameReferenceExpression) {
            if (!Intrinsics.areEqual(typeReference.getText(), ((KtNameReferenceExpression)initializer).getReferencedName())) {
                return;
            }
        } else if (initializer instanceof KtCallExpression) {
            KtExpression ktExpression = ((KtCallExpression)initializer).getCalleeExpression();
            if (!Intrinsics.areEqual(typeReference.getText(), ktExpression != null ? ktExpression.getText() : null)) {
                return;
            }
        } else {
            return;
        }
        this.report(new CodeSmell(this.getIssue(), Entity.Companion.atName(property), this.getIssue().getDescription(), null, null, 24, null));
        super.visitProperty(property);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final boolean typeIsSameAs(KtConstantExpression $this$typeIsSameAs, KotlinType type2) {
        boolean bl;
        IElementType iElementType = $this$typeIsSameAs.getNode().getElementType();
        if (Intrinsics.areEqual(iElementType, KtNodeTypes.BOOLEAN_CONSTANT)) {
            bl = TypeUtilsKt.isBoolean(type2);
            return bl;
        }
        if (Intrinsics.areEqual(iElementType, KtNodeTypes.CHARACTER_CONSTANT)) {
            bl = TypeUtilsKt.isChar(type2);
            return bl;
        }
        if (Intrinsics.areEqual(iElementType, KtNodeTypes.INTEGER_CONSTANT)) {
            String string2 = $this$typeIsSameAs.getText();
            Intrinsics.checkNotNullExpressionValue(string2, "getText(...)");
            if (StringsKt.endsWith$default(string2, "L", false, 2, null)) {
                bl = TypeUtilsKt.isLong(type2);
                return bl;
            }
            bl = TypeUtilsKt.isInt(type2);
            return bl;
        }
        if (!Intrinsics.areEqual(iElementType, KtNodeTypes.FLOAT_CONSTANT)) {
            return false;
        }
        String string3 = $this$typeIsSameAs.getText();
        Intrinsics.checkNotNullExpressionValue(string3, "getText(...)");
        if (!StringsKt.endsWith$default(string3, "f", false, 2, null)) {
            String string4 = $this$typeIsSameAs.getText();
            Intrinsics.checkNotNullExpressionValue(string4, "getText(...)");
            if (!StringsKt.endsWith$default(string4, "F", false, 2, null)) {
                bl = TypeUtilsKt.isDouble(type2);
                return bl;
            }
        }
        bl = TypeUtilsKt.isFloat(type2);
        return bl;
    }
}

