/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.TypeUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementUtilsKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\rH\u0002J\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001a\u0010\u0015\u001a\u00020\u0011*\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u0014\u0010\u001a\u001a\u00020\u0011*\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001e"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/RedundantHigherOrderMapUsage;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "lambda", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "isInheritorOf", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "isRedundant", "Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "lambdaStatements", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isReferenceTo", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "Companion", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nRedundantHigherOrderMapUsage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedundantHigherOrderMapUsage.kt\nio/gitlab/arturbosch/detekt/rules/style/RedundantHigherOrderMapUsage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,150:1\n1755#2,3:151\n1734#2,3:172\n310#3,14:154\n229#3,2:168\n241#3:170\n328#3:171\n*S KotlinDebug\n*F\n+ 1 RedundantHigherOrderMapUsage.kt\nio/gitlab/arturbosch/detekt/rules/style/RedundantHigherOrderMapUsage\n*L\n121#1:151,3\n131#1:172,3\n128#1:154,14\n128#1:168,2\n128#1:170\n128#1:171\n*E\n"})
public final class RedundantHigherOrderMapUsage
extends Rule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Issue issue;
    @NotNull
    private static final List<FqName> mapFqNames;
    @NotNull
    private static final FqName listFqName;
    @NotNull
    private static final FqName setFqName;
    @NotNull
    private static final FqName sequenceFqName;

    public RedundantHigherOrderMapUsage(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Style, "Checks for redundant 'map' calls, which can be removed.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ RedundantHigherOrderMapUsage(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression2) {
        KtExpression calleeExpression;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        super.visitCallExpression(expression2);
        KtExpression ktExpression = calleeExpression = expression2.getCalleeExpression();
        if (!Intrinsics.areEqual(ktExpression != null ? ktExpression.getText() : null, "map")) {
            return;
        }
        KtLambdaExpression ktLambdaExpression = this.lambda(expression2);
        KtFunctionLiteral functionLiteral = ktLambdaExpression != null ? ktLambdaExpression.getFunctionLiteral() : null;
        Object object = functionLiteral;
        if (object == null || (object = ((KtFunctionLiteral)object).getBodyExpression()) == null || (object = ((KtBlockExpression)object).getStatements()) == null) {
            return;
        }
        Object lambdaStatements = object;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, this.getBindingContext());
        if (resolvedCall2 == null) {
            return;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        Iterable iterable = mapFqNames;
        CallableDescriptor callableDescriptor = resolvedCall3.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(callableDescriptor, "getResultingDescriptor(...)");
        if (!CollectionsKt.contains(iterable, DescriptorUtilsKt.fqNameOrNull(callableDescriptor))) {
            return;
        }
        Object object2 = resolvedCall3.getExtensionReceiver();
        if (object2 == null || (object2 = object2.getType()) == null) {
            return;
        }
        Object receiverType = object2;
        boolean receiverIsList = this.isInheritorOf((KotlinType)receiverType, listFqName);
        boolean receiverIsSet = this.isInheritorOf((KotlinType)receiverType, setFqName);
        boolean receiverIsSequence = this.isInheritorOf((KotlinType)receiverType, sequenceFqName);
        if (!(receiverIsList || receiverIsSet || receiverIsSequence)) {
            return;
        }
        if (!this.isRedundant(functionLiteral, (List<? extends KtExpression>)lambdaStatements)) {
            return;
        }
        String message = lambdaStatements.size() != 1 ? "This 'map' call can be replaced with 'onEach' or 'forEach'." : (receiverIsSet ? "This 'map' call can be replaced with 'toList'." : "This 'map' call can be removed.");
        this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, calleeExpression, 0, 2, null), message, null, null, 24, null));
    }

    private final KtLambdaExpression lambda(KtCallExpression $this$lambda) {
        KtValueArgument ktValueArgument;
        List<KtLambdaArgument> list = $this$lambda.getLambdaArguments();
        Intrinsics.checkNotNullExpressionValue(list, "getLambdaArguments(...)");
        KtLambdaArgument ktLambdaArgument = CollectionsKt.singleOrNull(list);
        if (ktLambdaArgument != null) {
            ktValueArgument = ktLambdaArgument;
        } else {
            List<KtValueArgument> list2 = $this$lambda.getValueArguments();
            Intrinsics.checkNotNullExpressionValue(list2, "getValueArguments(...)");
            ktValueArgument = CollectionsKt.singleOrNull(list2);
            if (ktValueArgument == null) {
                return null;
            }
        }
        KtValueArgument argument = ktValueArgument;
        KtExpression ktExpression = argument.getArgumentExpression();
        if (ktExpression == null || (ktExpression = KtElementUtilsKt.unpackFunctionLiteral$default(ktExpression, false, 1, null)) == null) {
            return null;
        }
        KtExpression lambda2 = ktExpression;
        List<KtParameter> list3 = ((KtLambdaExpression)lambda2).getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list3, "getValueParameters(...)");
        KtParameter ktParameter = CollectionsKt.firstOrNull(list3);
        if ((ktParameter != null ? ktParameter.getDestructuringDeclaration() : null) != null) {
            return null;
        }
        return lambda2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInheritorOf(KotlinType $this$isInheritorOf, FqName fqName) {
        KotlinType it;
        if (Intrinsics.areEqual(TypeUtilsKt.fqNameOrNull($this$isInheritorOf), fqName)) return true;
        Iterable $this$any$iv = org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt.immediateSupertypes($this$isInheritorOf);
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (KotlinType)element$iv;
            boolean bl = false;
        } while (!Intrinsics.areEqual(TypeUtilsKt.fqNameOrNull(it), fqName));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isRedundant(KtFunctionLiteral $this$isRedundant, List<? extends KtExpression> lambdaStatements) {
        boolean bl;
        block7: {
            void $this$forEachDescendantOfType$iv$iv$iv$iv;
            void $this$collectDescendantsOfTypeTo$iv$iv$iv;
            void $this$collectDescendantsOfType$iv;
            SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)this.getBindingContext().get(BindingContext.FUNCTION, $this$isRedundant);
            if (simpleFunctionDescriptor == null) {
                return false;
            }
            SimpleFunctionDescriptor lambdaDescriptor = simpleFunctionDescriptor;
            List<ValueParameterDescriptor> list = lambdaDescriptor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
            ValueParameterDescriptor valueParameterDescriptor = CollectionsKt.singleOrNull(list);
            if (valueParameterDescriptor == null) {
                return false;
            }
            ValueParameterDescriptor lambdaParameter = valueParameterDescriptor;
            KtExpression ktExpression = CollectionsKt.lastOrNull(lambdaStatements);
            if (ktExpression == null) {
                return false;
            }
            KtExpression lastStatement = ktExpression;
            if (!this.isReferenceTo(lastStatement, lambdaParameter)) {
                return false;
            }
            PsiElement psiElement = $this$isRedundant;
            Function1<KtReturnExpression, Boolean> predicate$iv = arg_0 -> RedundantHigherOrderMapUsage.isRedundant$lambda$1(lastStatement, this, lambdaDescriptor, arg_0);
            boolean $i$f$collectDescendantsOfType = false;
            void $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType$iv;
            boolean $i$f$collectDescendantsOfType2 = false;
            void var12_14 = $this$collectDescendantsOfType$iv$iv;
            Collection to$iv$iv$iv = new ArrayList();
            boolean $i$f$collectDescendantsOfTypeTo = false;
            void var15_18 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
            Function1 action$iv$iv$iv$iv = new Function1<KtReturnExpression, Unit>(predicate$iv, to$iv$iv$iv){
                final /* synthetic */ Function1 $predicate;
                final /* synthetic */ Collection $to;
                {
                    this.$predicate = $predicate;
                    this.$to = $to;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final void invoke(PsiElement it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    if (((Boolean)this.$predicate.invoke(it)).booleanValue()) {
                        this.$to.add(it);
                    }
                }
            };
            boolean $i$f$forEachDescendantOfType = false;
            PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv$iv$iv);
            $this$forEachDescendantOfType$iv$iv$iv$iv.accept(new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
                final /* synthetic */ Function1 $action;
                {
                    this.$action = $action;
                }

                public void visitElement(PsiElement element) {
                    Intrinsics.checkNotNullParameter(element, "element");
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                    if (element instanceof KtReturnExpression) {
                        this.$action.invoke(element);
                    }
                }
            });
            List returnExpressions = (List)to$iv$iv$iv;
            Iterable $this$all$iv = returnExpressions;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    KtReturnExpression it = (KtReturnExpression)element$iv;
                    boolean bl2 = false;
                    if (this.isReferenceTo(it, lambdaParameter)) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean isReferenceTo(KtExpression $this$isReferenceTo, ValueParameterDescriptor descriptor2) {
        KtExpression ktExpression = $this$isReferenceTo instanceof KtReturnExpression ? ((KtReturnExpression)$this$isReferenceTo).getReturnedExpression() : $this$isReferenceTo;
        KtNameReferenceExpression nameReference = ktExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression : null;
        Object object = nameReference;
        return Intrinsics.areEqual(object != null && (object = CallUtilKt.getResolvedCall((KtElement)object, this.getBindingContext())) != null ? object.getResultingDescriptor() : null, descriptor2);
    }

    private static final boolean isRedundant$lambda$1(KtExpression $lastStatement, RedundantHigherOrderMapUsage this$0, SimpleFunctionDescriptor $lambdaDescriptor, KtReturnExpression it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !Intrinsics.areEqual(it, $lastStatement) && Intrinsics.areEqual(BindingContextUtilsKt.getTargetFunctionDescriptor(it, this$0.getBindingContext()), $lambdaDescriptor);
    }

    public RedundantHigherOrderMapUsage() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        FqName[] fqNameArray = new FqName[]{new FqName("kotlin.collections.map"), new FqName("kotlin.sequences.map")};
        mapFqNames = CollectionsKt.listOf(fqNameArray);
        listFqName = new FqName("kotlin.collections.List");
        setFqName = new FqName("kotlin.collections.Set");
        sequenceFqName = new FqName("kotlin.sequences.Sequence");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/RedundantHigherOrderMapUsage$Companion;", "", "<init>", "()V", "mapFqNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "listFqName", "setFqName", "sequenceFqName", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

