/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.JunkKt;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001#B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0002J\u0014\u0010\u001b\u001a\u00020\u001c*\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010\"\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006$"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/SerialVersionUIDInSerializableClass;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitClass", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "visitObjectDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "reportFinding", "finding", "Lio/gitlab/arturbosch/detekt/rules/style/SerialVersionUIDInSerializableClass$SerialVersionUIDFindings;", "isImplementingSerializable", "", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "searchSerialVersionUIDFinding", "parentDeclaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "getIssueMessage", "", "typeOfDeclaration", "isLongProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "hasLongType", "hasLongAssignment", "SerialVersionUIDFindings", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nSerialVersionUIDInSerializableClass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SerialVersionUIDInSerializableClass.kt\nio/gitlab/arturbosch/detekt/rules/style/SerialVersionUIDInSerializableClass\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,141:1\n1755#2,3:142\n295#2,2:145\n3170#3,11:147\n*S KotlinDebug\n*F\n+ 1 SerialVersionUIDInSerializableClass.kt\nio/gitlab/arturbosch/detekt/rules/style/SerialVersionUIDInSerializableClass\n*L\n95#1:142,3\n101#1:145,2\n130#1:147,11\n*E\n"})
public final class SerialVersionUIDInSerializableClass
extends Rule {
    @NotNull
    private final Issue issue;

    public SerialVersionUIDInSerializableClass(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Warning, "A class which implements the Serializable interface does not define a correct serialVersionUID field. The serialVersionUID field should be a private constant long value inside a companion object.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ SerialVersionUIDInSerializableClass(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitClass(@NotNull KtClass klass) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        super.visitClass(klass);
        if (!klass.isInterface() && this.isImplementingSerializable(klass)) {
            KtObjectDeclaration companionObject = JunkKt.companionObject(klass);
            if (companionObject == null) {
                this.report(new CodeSmell(this.getIssue(), Entity.Companion.atName(klass), this.getIssueMessage(klass, "class"), null, null, 24, null));
            } else {
                SerialVersionUIDFindings serialVersionUIDFindings = this.searchSerialVersionUIDFinding(companionObject, klass);
                if (serialVersionUIDFindings == null) {
                    return;
                }
                SerialVersionUIDFindings finding = serialVersionUIDFindings;
                this.reportFinding(finding);
            }
        }
    }

    @Override
    public void visitObjectDeclaration(@NotNull KtObjectDeclaration declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        super.visitObjectDeclaration(declaration);
        if (!declaration.isCompanion() && this.isImplementingSerializable(declaration)) {
            SerialVersionUIDFindings serialVersionUIDFindings = SerialVersionUIDInSerializableClass.searchSerialVersionUIDFinding$default(this, declaration, null, 2, null);
            if (serialVersionUIDFindings == null) {
                return;
            }
            SerialVersionUIDFindings finding = serialVersionUIDFindings;
            this.reportFinding(finding);
        }
    }

    private final void reportFinding(SerialVersionUIDFindings finding) {
        this.report(new CodeSmell(this.getIssue(), Entity.Companion.atName(finding.getViolatingElement()), finding.getIssueMsg(), null, null, 24, null));
    }

    private final boolean isImplementingSerializable(KtClassOrObject classOrObject) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = classOrObject.getSuperTypeListEntries();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KtSuperTypeListEntry it = (KtSuperTypeListEntry)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getText(), "Serializable")) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final SerialVersionUIDFindings searchSerialVersionUIDFinding(KtObjectDeclaration declaration, KtNamedDeclaration parentDeclaration) {
        Object object;
        block5: {
            block4: {
                Object v1;
                block3: {
                    object = declaration.getBody();
                    if (object == null || (object = ((KtClassBody)object).getProperties()) == null) break block4;
                    Iterable $this$firstOrNull$iv = (Iterable)object;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        KtProperty it = (KtProperty)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.getName(), "serialVersionUID")) continue;
                        v1 = element$iv;
                        break block3;
                    }
                    v1 = null;
                }
                if ((object = (KtProperty)v1) != null) break block5;
            }
            return new SerialVersionUIDFindings(parentDeclaration, this.getIssueMessage(parentDeclaration, parentDeclaration instanceof KtClass ? "class" : "object"));
        }
        Object property = object;
        boolean isPropertyPrivate = KtPsiUtilKt.isPrivate(declaration) || KtPsiUtilKt.isPrivate((KtModifierListOwner)property);
        return KtModifierListKt.isConstant((KtModifierListOwner)property) && this.isLongProperty((KtProperty)property) && isPropertyPrivate ? null : new SerialVersionUIDFindings((KtNamedDeclaration)property, "The property `serialVersionUID` signature is not correct. `serialVersionUID` should be `private` and `constant` and its type should be `Long`");
    }

    static /* synthetic */ SerialVersionUIDFindings searchSerialVersionUIDFinding$default(SerialVersionUIDInSerializableClass serialVersionUIDInSerializableClass, KtObjectDeclaration ktObjectDeclaration, KtNamedDeclaration ktNamedDeclaration, int n, Object object) {
        if ((n & 2) != 0) {
            ktNamedDeclaration = ktObjectDeclaration;
        }
        return serialVersionUIDInSerializableClass.searchSerialVersionUIDFinding(ktObjectDeclaration, ktNamedDeclaration);
    }

    private final String getIssueMessage(KtNamedDeclaration $this$getIssueMessage, String typeOfDeclaration) {
        return "The " + typeOfDeclaration + ' ' + $this$getIssueMessage.getNameAsSafeName() + " implements the `Serializable` interface and should thus define a `serialVersionUID`.";
    }

    private final boolean isLongProperty(KtProperty property) {
        return this.hasLongType(property) || this.hasLongAssignment(property);
    }

    private final boolean hasLongType(KtProperty property) {
        KtTypeReference ktTypeReference = property.getTypeReference();
        return Intrinsics.areEqual(ktTypeReference != null ? ktTypeReference.getText() : null, "Long");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasLongAssignment(KtProperty property) {
        Object v1;
        block2: {
            void $this$singleOrNull$iv;
            PsiElement[] psiElementArray = property.getChildren();
            Intrinsics.checkNotNullExpressionValue(psiElementArray, "getChildren(...)");
            Object[] objectArray = psiElementArray;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (void element$iv : $this$singleOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it instanceof KtConstantExpression || it instanceof KtPrefixExpression)) continue;
                if (found$iv) {
                    v1 = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v1 = !found$iv ? null : single$iv;
        }
        PsiElement psiElement = v1;
        if (psiElement == null) return false;
        String string2 = psiElement.getText();
        String assignmentText = string2;
        if (assignmentText == null) return false;
        if (StringsKt.last(assignmentText) != 'L') return false;
        String string3 = assignmentText.substring(0, assignmentText.length() - 1);
        Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
        if (StringsKt.toLongOrNull(string3) == null) return false;
        return true;
    }

    public SerialVersionUIDInSerializableClass() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/SerialVersionUIDInSerializableClass$SerialVersionUIDFindings;", "", "violatingElement", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "issueMsg", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Ljava/lang/String;)V", "getViolatingElement", "()Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "getIssueMsg", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "detekt-rules-style"})
    private static final class SerialVersionUIDFindings {
        @NotNull
        private final KtNamedDeclaration violatingElement;
        @NotNull
        private final String issueMsg;

        public SerialVersionUIDFindings(@NotNull KtNamedDeclaration violatingElement, @NotNull String issueMsg) {
            Intrinsics.checkNotNullParameter(violatingElement, "violatingElement");
            Intrinsics.checkNotNullParameter(issueMsg, "issueMsg");
            this.violatingElement = violatingElement;
            this.issueMsg = issueMsg;
        }

        @NotNull
        public final KtNamedDeclaration getViolatingElement() {
            return this.violatingElement;
        }

        @NotNull
        public final String getIssueMsg() {
            return this.issueMsg;
        }

        @NotNull
        public final KtNamedDeclaration component1() {
            return this.violatingElement;
        }

        @NotNull
        public final String component2() {
            return this.issueMsg;
        }

        @NotNull
        public final SerialVersionUIDFindings copy(@NotNull KtNamedDeclaration violatingElement, @NotNull String issueMsg) {
            Intrinsics.checkNotNullParameter(violatingElement, "violatingElement");
            Intrinsics.checkNotNullParameter(issueMsg, "issueMsg");
            return new SerialVersionUIDFindings(violatingElement, issueMsg);
        }

        public static /* synthetic */ SerialVersionUIDFindings copy$default(SerialVersionUIDFindings serialVersionUIDFindings, KtNamedDeclaration ktNamedDeclaration, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                ktNamedDeclaration = serialVersionUIDFindings.violatingElement;
            }
            if ((n & 2) != 0) {
                string2 = serialVersionUIDFindings.issueMsg;
            }
            return serialVersionUIDFindings.copy(ktNamedDeclaration, string2);
        }

        @NotNull
        public String toString() {
            return "SerialVersionUIDFindings(violatingElement=" + this.violatingElement + ", issueMsg=" + this.issueMsg + ')';
        }

        public int hashCode() {
            int result2 = this.violatingElement.hashCode();
            result2 = result2 * 31 + this.issueMsg.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SerialVersionUIDFindings)) {
                return false;
            }
            SerialVersionUIDFindings serialVersionUIDFindings = (SerialVersionUIDFindings)other;
            if (!Intrinsics.areEqual(this.violatingElement, serialVersionUIDFindings.violatingElement)) {
                return false;
            }
            return Intrinsics.areEqual(this.issueMsg, serialVersionUIDFindings.issueMsg);
        }
    }
}

