/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.GuardClausesKt;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.style.ThrowsCount$visitNamedFunction$;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0012\u001a\u00020\u00138BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u0011\u0012\u0004\b\u0014\u0010\r\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001c"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ThrowsCount;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "max", "", "getMax$annotations", "()V", "getMax", "()I", "max$delegate", "Lkotlin/properties/ReadOnlyProperty;", "excludeGuardClauses", "", "getExcludeGuardClauses$annotations", "getExcludeGuardClauses", "()Z", "excludeGuardClauses$delegate", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nThrowsCount.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThrowsCount.kt\nio/gitlab/arturbosch/detekt/rules/style/ThrowsCount\n+ 2 GuardClauses.kt\nio/gitlab/arturbosch/detekt/rules/GuardClausesKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,88:1\n15#2,11:89\n142#3:100\n310#3,14:101\n229#3,2:115\n241#3:117\n328#3:118\n*S KotlinDebug\n*F\n+ 1 ThrowsCount.kt\nio/gitlab/arturbosch/detekt/rules/style/ThrowsCount\n*L\n62#1:89,11\n70#1:100\n69#1:101,14\n69#1:115,2\n69#1:117\n69#1:118\n*E\n"})
public final class ThrowsCount
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty max$delegate;
    @NotNull
    private final ReadOnlyProperty excludeGuardClauses$delegate;

    public ThrowsCount(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Style, "Restrict the number of throw statements in methods.", Debt.Companion.getTEN_MINS());
        this.max$delegate = ConfigPropertyKt.config(2);
        this.excludeGuardClauses$delegate = ConfigPropertyKt.config(false);
    }

    public /* synthetic */ ThrowsCount(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final int getMax() {
        return ((Number)this.max$delegate.getValue(this, $$delegatedProperties[0])).intValue();
    }

    @Configuration(description="maximum amount of throw statements in a method")
    private static /* synthetic */ void getMax$annotations() {
    }

    private final boolean getExcludeGuardClauses() {
        return (Boolean)this.excludeGuardClauses$delegate.getValue(this, $$delegatedProperties[1]);
    }

    @Configuration(description="if set to true, guard clauses do not count towards the allowed throws count")
    private static /* synthetic */ void getExcludeGuardClauses$annotations() {
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        super.visitNamedFunction(function2);
        if (!KtModifierListKt.isOverride(function2)) {
            Sequence sequence2;
            if (this.getExcludeGuardClauses()) {
                KtNamedFunction $this$yieldStatementsSkippingGuardClauses$iv = function2;
                boolean $i$f$yieldStatementsSkippingGuardClauses = false;
                sequence2 = SequencesKt.sequence((Function2)new Function2<SequenceScope<? super KtExpression>, Continuation<? super Unit>, Object>($this$yieldStatementsSkippingGuardClauses$iv, null){
                    Object L$1;
                    Object L$2;
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ KtNamedFunction $this_yieldStatementsSkippingGuardClauses;
                    {
                        this.$this_yieldStatementsSkippingGuardClauses = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled aggressive block sorting
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2;
                        Object object3;
                        boolean bl;
                        Iterator<T> iterator2;
                        Ref.BooleanRef firstNonGuardFound;
                        SequenceScope $this$sequence;
                        Object object4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure(object);
                                $this$sequence = (SequenceScope)this.L$0;
                                firstNonGuardFound = new Ref.BooleanRef();
                                KtBlockExpression ktBlockExpression = this.$this_yieldStatementsSkippingGuardClauses.getBodyBlockExpression();
                                Object object5 = ktBlockExpression;
                                if (ktBlockExpression == null) return Unit.INSTANCE;
                                List<KtExpression> list = ((KtBlockExpression)object5).getStatements();
                                object5 = list;
                                if (list == null) return Unit.INSTANCE;
                                Iterable $this$forEach$iv = (Iterable)object5;
                                boolean $i$f$forEach = false;
                                iterator2 = $this$forEach$iv.iterator();
                                break;
                            }
                            case 1: {
                                void $result;
                                boolean $i$f$forEach = false;
                                bl = false;
                                iterator2 = (Iterator<T>)this.L$2;
                                firstNonGuardFound = (Ref.BooleanRef)this.L$1;
                                $this$sequence = (SequenceScope)this.L$0;
                                ResultKt.throwOnFailure($result);
                                object3 = $result;
                                break;
                            }
                            case 2: {
                                void $result;
                                boolean $i$f$forEach = false;
                                bl = false;
                                iterator2 = (Iterator)this.L$2;
                                firstNonGuardFound = (Ref.BooleanRef)this.L$1;
                                $this$sequence = (SequenceScope)this.L$0;
                                ResultKt.throwOnFailure($result);
                                object2 = $result;
                                break;
                            }
                            default: {
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }
                        }
                        while (iterator2.hasNext()) {
                            KtExpression descendantExpr$iv;
                            T element$iv = iterator2.next();
                            KtExpression it = (KtExpression)element$iv;
                            bl = false;
                            if (firstNonGuardFound.element) {
                                Intrinsics.checkNotNull(it);
                                this.L$0 = $this$sequence;
                                this.L$1 = firstNonGuardFound;
                                this.L$2 = iterator2;
                                this.label = 1;
                                object3 = $this$sequence.yield(it, this);
                                if (object3 != object4) continue;
                                return object4;
                            }
                            Intrinsics.checkNotNull(it);
                            KtExpression $this$isGuardClause$iv = it;
                            boolean $i$f$isGuardClause = false;
                            PsiElement $this$findDescendantOfType_u24default$iv$iv = $this$isGuardClause$iv;
                            Function1 predicate$iv$iv = visitNamedFunction$$inlined$yieldStatementsSkippingGuardClauses$1$1.INSTANCE;
                            boolean $i$f$findDescendantOfType = false;
                            PsiElement $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType_u24default$iv$iv;
                            boolean $i$f$findDescendantOfType2 = false;
                            PsiUtilsKt.checkDecompiledText($this$findDescendantOfType$iv$iv$iv);
                            Ref.ObjectRef<T> result$iv$iv$iv = new Ref.ObjectRef<T>();
                            $this$findDescendantOfType$iv$iv$iv.accept(new PsiRecursiveElementWalkingVisitor(predicate$iv$iv, result$iv$iv$iv){
                                final /* synthetic */ Function1 $predicate;
                                final /* synthetic */ Ref.ObjectRef $result;
                                {
                                    this.$predicate = $predicate;
                                    this.$result = $result;
                                }

                                public void visitElement(PsiElement element) {
                                    Intrinsics.checkNotNullParameter(element, "element");
                                    if (element instanceof KtThrowExpression && ((Boolean)this.$predicate.invoke(element)).booleanValue()) {
                                        this.$result.element = element;
                                        this.stopWalking();
                                        return;
                                    }
                                    PsiElement it = element;
                                    boolean bl = false;
                                    super.visitElement(element);
                                }
                            });
                            if (((KtExpression)((PsiElement)result$iv$iv$iv.element) == null ? false : GuardClausesKt.isIfConditionGuardClause($this$isGuardClause$iv, descendantExpr$iv) || GuardClausesKt.isElvisOperatorGuardClause($this$isGuardClause$iv, descendantExpr$iv)) || GuardClausesKt.isSuperCall(it)) continue;
                            firstNonGuardFound.element = true;
                            this.L$0 = $this$sequence;
                            this.L$1 = firstNonGuardFound;
                            this.L$2 = iterator2;
                            this.label = 2;
                            object2 = $this$sequence.yield(it, this);
                            if (object2 == object4) return object4;
                        }
                        return Unit.INSTANCE;
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        Function2<SequenceScope<? super KtExpression>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        function2.L$0 = value2;
                        return (Continuation)((Object)function2);
                    }

                    public final Object invoke(SequenceScope<? super KtExpression> p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                });
            } else {
                Object object = function2.getBodyBlockExpression();
                if ((object != null && (object = ((KtBlockExpression)object).getStatements()) != null ? CollectionsKt.asSequence((Iterable)object) : (sequence2 = null)) == null) {
                    sequence2 = SequencesKt.emptySequence();
                }
            }
            Sequence statements = sequence2;
            int countOfThrows = SequencesKt.count(SequencesKt.flatMap(statements, arg_0 -> ThrowsCount.visitNamedFunction$lambda$1(function2, arg_0)));
            if (countOfThrows > this.getMax()) {
                this.report(new CodeSmell(this.getIssue(), Entity.Companion.atName(function2), "Too many throw statements in the function " + function2.getNameAsSafeName() + ". The maximum number of allowed throw statements is " + this.getMax() + '.', null, null, 24, null));
            }
        }
    }

    private static final boolean visitNamedFunction$lambda$1$lambda$0(KtNamedFunction $function, KtThrowExpression it) {
        Intrinsics.checkNotNullParameter(it, "it");
        PsiElement $this$getStrictParentOfType$iv = it;
        boolean $i$f$getStrictParentOfType = false;
        return Intrinsics.areEqual(PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KtNamedFunction.class, true), $function);
    }

    /*
     * WARNING - void declaration
     */
    private static final Sequence visitNamedFunction$lambda$1(KtNamedFunction $function, KtExpression statement) {
        void $this$forEachDescendantOfType$iv$iv$iv$iv;
        void $this$collectDescendantsOfTypeTo$iv$iv$iv;
        void $this$collectDescendantsOfType$iv;
        Intrinsics.checkNotNullParameter(statement, "statement");
        PsiElement psiElement = statement;
        Function1<KtThrowExpression, Boolean> predicate$iv = arg_0 -> ThrowsCount.visitNamedFunction$lambda$1$lambda$0($function, arg_0);
        boolean $i$f$collectDescendantsOfType = false;
        void $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType$iv;
        boolean $i$f$collectDescendantsOfType2 = false;
        void var7_7 = $this$collectDescendantsOfType$iv$iv;
        Collection to$iv$iv$iv = new ArrayList();
        boolean $i$f$collectDescendantsOfTypeTo = false;
        void var10_10 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Function1 action$iv$iv$iv$iv = new Function1<KtThrowExpression, Unit>(predicate$iv, to$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Collection $to;
            {
                this.$predicate = $predicate;
                this.$to = $to;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(PsiElement it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (((Boolean)this.$predicate.invoke(it)).booleanValue()) {
                    this.$to.add(it);
                }
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv$iv$iv);
        $this$forEachDescendantOfType$iv$iv$iv$iv.accept(new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KtThrowExpression) {
                    this.$action.invoke(element);
                }
            }
        });
        return CollectionsKt.asSequence((List)to$iv$iv$iv);
    }

    public ThrowsCount() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(ThrowsCount.class, "max", "getMax()I", 0)), Reflection.property1(new PropertyReference1Impl(ThrowsCount.class, "excludeGuardClauses", "getExcludeGuardClauses()Z", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

