/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.style.TrimMultilineRawStringKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR'\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u0014\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/TrimMultilineRawString;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "getConfig", "()Lio/gitlab/arturbosch/detekt/api/Config;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "trimmingMethods", "", "", "getTrimmingMethods$annotations", "()V", "getTrimmingMethods", "()Ljava/util/List;", "trimmingMethods$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitStringTemplateExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "detekt-rules-style"})
public final class TrimMultilineRawString
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Config config;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty trimmingMethods$delegate;

    public TrimMultilineRawString(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.config = config;
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Style, "Multiline raw strings should be followed by `trimMargin()` or `trimIndent()`.", Debt.Companion.getFIVE_MINS());
        String[] stringArray = new String[]{"trimIndent", "trimMargin"};
        this.trimmingMethods$delegate = ConfigPropertyKt.config(CollectionsKt.listOf(stringArray));
    }

    @NotNull
    public final Config getConfig() {
        return this.config;
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final List<String> getTrimmingMethods() {
        return (List)this.trimmingMethods$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Configuration(description="allows to provide a list of multiline string trimming methods")
    private static /* synthetic */ void getTrimmingMethods$annotations() {
    }

    @Override
    public void visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        super.visitStringTemplateExpression(expression2);
        if (TrimMultilineRawStringKt.isRawStringWithLineBreak(expression2) && !TrimMultilineRawStringKt.isTrimmed(expression2, this.getTrimmingMethods()) && !TrimMultilineRawStringKt.access$isExpectedAsConstant(expression2)) {
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, expression2, 0, 2, null), "Multiline raw strings should be followed by `trimMargin()` or `trimIndent()`", null, null, 24, null));
        }
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(TrimMultilineRawString.class, "trimmingMethods", "getTrimmingMethods()Ljava/util/List;", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

