/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.style.UnusedPrivatePropertyKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\bH\u0002J\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 H\u0016J\f\u0010!\u001a\u00020\u0018*\u00020 H\u0002J\u0010\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnusedPrivatePropertyVisitor;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "allowedNames", "Lkotlin/text/Regex;", "<init>", "(Lkotlin/text/Regex;)V", "properties", "", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "nameAccesses", "", "getUnusedReports", "", "Lio/gitlab/arturbosch/detekt/api/CodeSmell;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "visitParameter", "", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "visitPrimaryConstructor", "constructor", "Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "isConstructorForDataOrValueClass", "", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "visitSecondaryConstructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "maybeAddUnusedProperty", "it", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "isMemberOrTopLevel", "visitReferenceExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "skipNode", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nUnusedPrivateProperty.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnusedPrivateProperty.kt\nio/gitlab/arturbosch/detekt/rules/style/UnusedPrivatePropertyVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n774#2:167\n865#2,2:168\n1557#2:170\n1628#2,3:171\n774#2:174\n865#2,2:175\n1863#2,2:177\n1863#2,2:179\n*S KotlinDebug\n*F\n+ 1 UnusedPrivateProperty.kt\nio/gitlab/arturbosch/detekt/rules/style/UnusedPrivatePropertyVisitor\n*L\n83#1:167\n83#1:168,2\n84#1:170\n84#1:171,3\n110#1:174\n110#1:175,2\n115#1:177,2\n125#1:179,2\n*E\n"})
final class UnusedPrivatePropertyVisitor
extends DetektVisitor {
    @NotNull
    private final Regex allowedNames;
    @NotNull
    private final Set<KtNamedDeclaration> properties;
    @NotNull
    private final Set<String> nameAccesses;

    public UnusedPrivatePropertyVisitor(@NotNull Regex allowedNames2) {
        Intrinsics.checkNotNullParameter(allowedNames2, "allowedNames");
        this.allowedNames = allowedNames2;
        this.properties = new LinkedHashSet();
        this.nameAccesses = new LinkedHashSet();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CodeSmell> getUnusedReports(@NotNull Issue issue) {
        void $this$mapTo$iv$iv;
        KtNamedDeclaration it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(issue, "issue");
        Iterable $this$filter$iv = this.properties;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (KtNamedDeclaration)element$iv$iv;
            boolean bl = false;
            if (!(!this.nameAccesses.contains(it.getNameAsSafeName().getIdentifier()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (KtNamedDeclaration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new CodeSmell(issue, Entity.Companion.atName(it), "Private property `" + it.getNameAsSafeName().getIdentifier() + "` is unused.", null, null, 24, null));
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void visitParameter(@NotNull KtParameter parameter) {
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        super.visitParameter(parameter);
        if (parameter.isLoopParameter()) {
            KtDestructuringDeclaration destructuringDeclaration = parameter.getDestructuringDeclaration();
            if (destructuringDeclaration != null) {
                for (KtDestructuringDeclarationEntry variable : destructuringDeclaration.getEntries()) {
                    Intrinsics.checkNotNull(variable);
                    this.maybeAddUnusedProperty(variable);
                }
            } else {
                this.maybeAddUnusedProperty(parameter);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void visitPrimaryConstructor(@NotNull KtPrimaryConstructor constructor) {
        Intrinsics.checkNotNullParameter(constructor, "constructor");
        super.visitPrimaryConstructor(constructor);
        $this$filter$iv = constructor.getValueParameters();
        $i$f$filter = false;
        var4_4 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (KtParameter)element$iv$iv;
            $i$a$-filter-UnusedPrivatePropertyVisitor$visitPrimaryConstructor$1 = false;
            Intrinsics.checkNotNull(it);
            if (!KtPsiUtilKt.isPrivate(it) && (it.hasValOrVar() || KtModifierListKt.isActual(constructor))) ** GOTO lbl-1000
            v0 = KtPsiUtilKt.getContainingClassOrObject(it);
            v1 = v0 != null ? !KtModifierListKt.isExpect(v0) : false;
            if (v1 && !this.isConstructorForDataOrValueClass(constructor)) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (E element$iv : $this$forEach$iv) {
            it = (KtParameter)element$iv;
            $i$a$-forEach-UnusedPrivatePropertyVisitor$visitPrimaryConstructor$2 = false;
            Intrinsics.checkNotNull(it);
            this.maybeAddUnusedProperty(it);
        }
    }

    private final boolean isConstructorForDataOrValueClass(PsiElement constructor) {
        PsiElement psiElement = constructor.getParent();
        KtClass ktClass = psiElement instanceof KtClass ? (KtClass)psiElement : null;
        if (ktClass == null) {
            return false;
        }
        KtClass parent2 = ktClass;
        return parent2.isData() || parent2.isValue() || parent2.isInline();
    }

    @Override
    public void visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor) {
        Intrinsics.checkNotNullParameter(constructor, "constructor");
        super.visitSecondaryConstructor(constructor);
        Iterable $this$forEach$iv = constructor.getValueParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtParameter it = (KtParameter)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            this.maybeAddUnusedProperty(it);
        }
    }

    private final void maybeAddUnusedProperty(KtNamedDeclaration it) {
        String string2 = it.getNameAsSafeName().getIdentifier();
        Intrinsics.checkNotNullExpressionValue(string2, "getIdentifier(...)");
        if (!this.allowedNames.matches(string2)) {
            this.properties.add(it);
        }
    }

    @Override
    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter(property, "property");
        if (KtPsiUtilKt.isPrivate(property) && this.isMemberOrTopLevel(property) || property.isLocal()) {
            this.maybeAddUnusedProperty(property);
        }
        super.visitProperty(property);
    }

    private final boolean isMemberOrTopLevel(KtProperty $this$isMemberOrTopLevel) {
        return $this$isMemberOrTopLevel.isMember() || $this$isMemberOrTopLevel.isTopLevel();
    }

    @Override
    public void visitReferenceExpression(@NotNull KtReferenceExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (!this.skipNode(expression2)) {
            String string2 = expression2.getText();
            Intrinsics.checkNotNullExpressionValue(string2, "getText(...)");
            this.nameAccesses.add(StringsKt.removeSurrounding(string2, (CharSequence)"`"));
        }
        super.visitReferenceExpression(expression2);
    }

    private final boolean skipNode(KtReferenceExpression expression2) {
        return UnusedPrivatePropertyKt.access$isPackageDirective(expression2) ? true : UnusedPrivatePropertyKt.access$isImportDirective(expression2);
    }
}

