/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.KtBinaryExpressionKt;
import io.gitlab.arturbosch.detekt.rules.KtCallExpressionKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UseAnyOrNoneInsteadOfFind;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "Companion", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nUseAnyOrNoneInsteadOfFind.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UseAnyOrNoneInsteadOfFind.kt\nio/gitlab/arturbosch/detekt/rules/style/UseAnyOrNoneInsteadOfFind\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n142#2:72\n142#2:73\n1368#3:74\n1454#3,2:75\n1557#3:77\n1628#3,3:78\n1456#3,3:81\n*S KotlinDebug\n*F\n+ 1 UseAnyOrNoneInsteadOfFind.kt\nio/gitlab/arturbosch/detekt/rules/style/UseAnyOrNoneInsteadOfFind\n*L\n49#1:72\n50#1:73\n66#1:74\n66#1:75,2\n67#1:77\n67#1:78,3\n66#1:81,3\n*E\n"})
public final class UseAnyOrNoneInsteadOfFind
extends Rule {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Issue issue;
    @NotNull
    private static final List<String> functionNames;
    @NotNull
    private static final List<FqName> functionFqNames;

    public UseAnyOrNoneInsteadOfFind(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("UseAnyOrNoneInsteadOfFind", Severity.Style, "Use `any` or `none` instead of `find` and `null` checks.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UseAnyOrNoneInsteadOfFind(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression2) {
        String string2;
        KtBinaryExpression ktBinaryExpression;
        Object functionName;
        block10: {
            block9: {
                KtBinaryExpression ktBinaryExpression2;
                Intrinsics.checkNotNullParameter(expression2, "expression");
                super.visitCallExpression(expression2);
                Object object = expression2.getCalleeExpression();
                if (object == null || (object = object.getText()) == null) {
                    return;
                }
                functionName = object;
                PsiElement $this$getStrictParentOfType$iv = expression2;
                boolean $i$f$getStrictParentOfType = false;
                KtQualifiedExpression ktQualifiedExpression = PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KtQualifiedExpression.class, true);
                KtExpression qualifiedOrThis = ktQualifiedExpression != null ? (KtExpression)ktQualifiedExpression : (KtExpression)expression2;
                PsiElement $this$getStrictParentOfType$iv2 = qualifiedOrThis;
                boolean $i$f$getStrictParentOfType2 = false;
                ktBinaryExpression = PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv2, KtBinaryExpression.class, true);
                if (ktBinaryExpression == null) break block9;
                KtBinaryExpression it = ktBinaryExpression2 = ktBinaryExpression;
                boolean bl = false;
                ktBinaryExpression = Intrinsics.areEqual(it.getLeft(), qualifiedOrThis) || Intrinsics.areEqual(it.getRight(), qualifiedOrThis) ? ktBinaryExpression2 : null;
                if (ktBinaryExpression != null) break block10;
            }
            return;
        }
        KtBinaryExpression binary = ktBinaryExpression;
        if (!KtCallExpressionKt.isCalling(expression2, functionFqNames, this.getBindingContext())) {
            return;
        }
        if (KtBinaryExpressionKt.isNonNullCheck(binary)) {
            string2 = "any";
        } else if (KtBinaryExpressionKt.isNullCheck(binary)) {
            string2 = "none";
        } else {
            return;
        }
        String replacement = string2;
        String message = "Use '" + replacement + "' instead of '" + (String)functionName + '\'';
        this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, expression2, 0, 2, null), message, null, null, 24, null));
    }

    public UseAnyOrNoneInsteadOfFind() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$flatMapTo$iv$iv;
        Companion = new Companion(null);
        String[] stringArray = new String[]{"find", "firstOrNull", "lastOrNull"};
        functionNames = CollectionsKt.listOf(stringArray);
        stringArray = new String[]{"kotlin.collections", "kotlin.sequences", "kotlin.text"};
        Iterable $this$flatMap$iv = CollectionsKt.listOf(stringArray);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            String packageName2 = (String)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = functionNames;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void functionName;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(new FqName(packageName2 + '.' + (String)functionName));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        functionFqNames = (List)var3_3;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UseAnyOrNoneInsteadOfFind$Companion;", "", "<init>", "()V", "functionNames", "", "", "functionFqNames", "Lorg/jetbrains/kotlin/name/FqName;", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

