/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0011\u001a\u00020\u0012*\u0004\u0018\u00010\u0013H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UseArrayLiteralsInAnnotations;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitAnnotationEntry", "", "annotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "visitPrimaryConstructor", "constructor", "Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "isArrayOfFunctionCall", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Companion", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nUseArrayLiteralsInAnnotations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UseArrayLiteralsInAnnotations.kt\nio/gitlab/arturbosch/detekt/rules/style/UseArrayLiteralsInAnnotations\n+ 2 Junk.kt\nio/gitlab/arturbosch/detekt/rules/JunkKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n40#2:79\n1557#3:80\n1628#3,3:81\n*S KotlinDebug\n*F\n+ 1 UseArrayLiteralsInAnnotations.kt\nio/gitlab/arturbosch/detekt/rules/style/UseArrayLiteralsInAnnotations\n*L\n59#1:79\n75#1:80\n75#1:81,3\n*E\n"})
public final class UseArrayLiteralsInAnnotations
extends Rule {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Issue issue;
    @NotNull
    private static final Set<String> arrayOfFunctions;

    public UseArrayLiteralsInAnnotations(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Style, "Array literals [...] should be preferred as they are more readable than `arrayOf(...)` expressions.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UseArrayLiteralsInAnnotations(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitAnnotationEntry(@NotNull KtAnnotationEntry annotationEntry) {
        Intrinsics.checkNotNullParameter(annotationEntry, "annotationEntry");
        for (ValueArgument valueArgument : annotationEntry.getValueArguments()) {
            if (!this.isArrayOfFunctionCall(valueArgument.getArgumentExpression())) continue;
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, valueArgument.asElement(), 0, 2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
    }

    @Override
    public void visitPrimaryConstructor(@NotNull KtPrimaryConstructor constructor) {
        Intrinsics.checkNotNullParameter(constructor, "constructor");
        KtClass ktClass = KtPsiUtilKt.containingClass(constructor);
        if (!(ktClass != null ? ktClass.isAnnotation() : false)) {
            return;
        }
        for (KtParameter parameter : constructor.getValueParameters()) {
            KtExpression defaultValue;
            if (parameter.getDefaultValue() == null || !this.isArrayOfFunctionCall(defaultValue)) continue;
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, defaultValue, 0, 2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final boolean isArrayOfFunctionCall(KtExpression $this$isArrayOfFunctionCall) {
        String string2;
        Iterable iterable = arrayOfFunctions;
        KtExpression ktExpression = $this$isArrayOfFunctionCall;
        if (ktExpression != null) {
            KtExpression $this$safeAs$iv = ktExpression;
            boolean $i$f$safeAs = false;
            KtExpression ktExpression2 = $this$safeAs$iv;
            if (!(ktExpression2 instanceof KtCallExpression)) {
                ktExpression2 = null;
            }
            if ((ktExpression = (KtCallExpression)ktExpression2) != null && (ktExpression = ((KtCallExpression)ktExpression).getCalleeExpression()) != null) {
                string2 = ktExpression.getText();
                return CollectionsKt.contains(iterable, string2);
            }
        }
        string2 = null;
        return CollectionsKt.contains(iterable, string2);
    }

    public UseArrayLiteralsInAnnotations() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        String[] stringArray = new String[]{"boolean", "char", "byte", "short", "int", "long", "float", "double", "ubyte", "ushort", "uint", "ulong"};
        Iterable $this$map$iv = CollectionsKt.listOf(stringArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it + "ArrayOf");
        }
        arrayOfFunctions = SetsKt.plus(CollectionsKt.toSet((List)var3_3), "arrayOf");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UseArrayLiteralsInAnnotations$Companion;", "", "<init>", "()V", "arrayOfFunctions", "", "", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

