/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.KtValueArgumentKt;
import io.gitlab.arturbosch.detekt.rules.ThrowExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtThrowExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u000e\u001a\u00020\u000f*\u00020\rH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UseCheckOrError;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitThrowExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtThrowExpression;", "isOnlyExpressionInLambda", "", "detekt-rules-style"})
public final class UseCheckOrError
extends Rule {
    @NotNull
    private final Issue issue;

    public UseCheckOrError(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("UseCheckOrError", Severity.Style, "Use check() or error() instead of throwing an IllegalStateException.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UseCheckOrError(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitThrowExpression(@NotNull KtThrowExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (this.isOnlyExpressionInLambda(expression2)) {
            return;
        }
        if (ThrowExtensionsKt.isIllegalStateException(expression2) && KtValueArgumentKt.isEmptyOrSingleStringArgument(ThrowExtensionsKt.getArguments(expression2), this.getBindingContext())) {
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, expression2, 0, 2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
    }

    private final boolean isOnlyExpressionInLambda(KtThrowExpression $this$isOnlyExpressionInLambda) {
        PsiElement p2 = $this$isOnlyExpressionInLambda.getParent();
        return p2 instanceof KtBlockExpression ? ((KtBlockExpression)p2).getStatements().size() == 1 && ((KtBlockExpression)p2).getParent() instanceof KtFunctionLiteral : false;
    }

    public UseCheckOrError() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }
}

