/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UseIfInsteadOfWhen;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "ignoreWhenContainingVariableDeclaration", "", "getIgnoreWhenContainingVariableDeclaration$annotations", "()V", "getIgnoreWhenContainingVariableDeclaration", "()Z", "ignoreWhenContainingVariableDeclaration$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitWhenExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nUseIfInsteadOfWhen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UseIfInsteadOfWhen.kt\nio/gitlab/arturbosch/detekt/rules/style/UseIfInsteadOfWhen\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n2632#2,3:63\n*S KotlinDebug\n*F\n+ 1 UseIfInsteadOfWhen.kt\nio/gitlab/arturbosch/detekt/rules/style/UseIfInsteadOfWhen\n*L\n50#1:63,3\n*E\n"})
public final class UseIfInsteadOfWhen
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty ignoreWhenContainingVariableDeclaration$delegate;

    public UseIfInsteadOfWhen(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("UseIfInsteadOfWhen", Severity.Style, "Binary expressions are better expressed using an `if` expression than a `when` expression.", Debt.Companion.getFIVE_MINS());
        this.ignoreWhenContainingVariableDeclaration$delegate = ConfigPropertyKt.config(false);
    }

    public /* synthetic */ UseIfInsteadOfWhen(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final boolean getIgnoreWhenContainingVariableDeclaration() {
        return (Boolean)this.ignoreWhenContainingVariableDeclaration$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Configuration(description="ignores when statements with a variable declaration used in the subject")
    private static /* synthetic */ void getIgnoreWhenContainingVariableDeclaration$annotations() {
    }

    @Override
    public void visitWhenExpression(@NotNull KtWhenExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        super.visitWhenExpression(expression2);
        if (this.getIgnoreWhenContainingVariableDeclaration() && expression2.getSubjectExpression() instanceof KtProperty) {
            return;
        }
        if (expression2.getEntries().size() == 2 && expression2.getElseExpression() != null) {
            boolean bl;
            block6: {
                List<KtWhenEntry> list = expression2.getEntries();
                Intrinsics.checkNotNullExpressionValue(list, "getEntries(...)");
                Iterable $this$none$iv = list;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        KtWhenEntry it = (KtWhenEntry)element$iv;
                        boolean bl2 = false;
                        if (!(it.getConditions().length > 1)) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            if (bl) {
                this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, expression2, 0, 2, null), "Prefer using 'if' for binary conditions instead of 'when'.", null, null, 24, null));
            }
        }
    }

    public UseIfInsteadOfWhen() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(UseIfInsteadOfWhen.class, "ignoreWhenContainingVariableDeclaration", "getIgnoreWhenContainingVariableDeclaration()Z", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

