/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.TypeUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 !2\u00020\u0001:\u0001!B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0010*\u00020\rH\u0002J\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0010*\u00020\u0010H\u0002J\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0010*\u00020\u0013H\u0002J\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0010*\u00020\rH\u0002J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0010*\u00020\u0010H\u0002J\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0010*\u00020\u0010H\u0002J\u000e\u0010\u0016\u001a\u00020\u000f*\u0004\u0018\u00010\u0010H\u0002J\u000e\u0010\u0017\u001a\u00020\u000f*\u0004\u0018\u00010\u0010H\u0002J\u000e\u0010\u0018\u001a\u00020\u000f*\u0004\u0018\u00010\u0010H\u0002J\u001c\u0010\u0019\u001a\u00020\u000f*\u0004\u0018\u00010\u00102\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\u000e\u0010\u001d\u001a\u0004\u0018\u00010\u001c*\u00020\u0010H\u0002J\f\u0010\u001e\u001a\u00020\u000f*\u00020\u0010H\u0002J\f\u0010\u001f\u001a\u00020\u000f*\u00020\u0010H\u0002J\f\u0010 \u001a\u00020\u000f*\u00020\u0010H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\""}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UseIsNullOrEmpty;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitBinaryExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "isSimpleNameExpression", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "nullCheckedExpression", "sizeCheckedExpression", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "sizeCheckedEmptyString", "sizeCheckedEqualToZero", "isNullKeyword", "isZero", "isEmptyString", "isCalling", "fqNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "classFqName", "isCollectionOrArrayOrString", "isCollectionOrArray", "isString", "Companion", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nUseIsNullOrEmpty.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UseIsNullOrEmpty.kt\nio/gitlab/arturbosch/detekt/rules/style/UseIsNullOrEmpty\n+ 2 Junk.kt\nio/gitlab/arturbosch/detekt/rules/JunkKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n40#2:180\n40#2:182\n40#2:183\n1#3:181\n1557#4:184\n1628#4,3:185\n1557#4:188\n1628#4,3:189\n1557#4:192\n1628#4,3:193\n1557#4:196\n1628#4,3:197\n*S KotlinDebug\n*F\n+ 1 UseIsNullOrEmpty.kt\nio/gitlab/arturbosch/detekt/rules/style/UseIsNullOrEmpty\n*L\n76#1:180\n136#1:182\n137#1:183\n139#1:184\n139#1:185,3\n173#1:188\n173#1:189,3\n174#1:192\n174#1:193,3\n176#1:196\n176#1:197,3\n*E\n"})
public final class UseIsNullOrEmpty
extends Rule {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Issue issue;
    @NotNull
    private static final List<FqName> collectionClasses;
    @NotNull
    private static final FqName arrayClass;
    @NotNull
    private static final FqName stringClass;
    @NotNull
    private static final List<FqName> emptyCheckFunctions;
    @NotNull
    private static final List<FqName> countFunctions;

    public UseIsNullOrEmpty(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("UseIsNullOrEmpty", Severity.Style, "Use `isNullOrEmpty()` call instead of `x == null || x.isEmpty()`.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UseIsNullOrEmpty(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        super.visitBinaryExpression(expression2);
        if (!Intrinsics.areEqual(expression2.getOperationToken(), KtTokens.OROR)) {
            return;
        }
        KtExpression ktExpression = expression2.getLeft();
        KtBinaryExpression ktBinaryExpression = ktExpression instanceof KtBinaryExpression ? (KtBinaryExpression)ktExpression : null;
        if (ktBinaryExpression == null) {
            return;
        }
        KtBinaryExpression left = ktBinaryExpression;
        KtExpression ktExpression2 = expression2.getRight();
        if (ktExpression2 == null) {
            return;
        }
        KtExpression right = ktExpression2;
        KtExpression ktExpression3 = this.nullCheckedExpression(left);
        if (ktExpression3 == null) {
            return;
        }
        KtExpression nullCheckedExpression = ktExpression3;
        KtExpression ktExpression4 = this.sizeCheckedExpression(right);
        if (ktExpression4 == null) {
            return;
        }
        KtExpression sizeCheckedExpression = ktExpression4;
        if (!this.isSimpleNameExpression(nullCheckedExpression) || !this.isSimpleNameExpression(sizeCheckedExpression)) {
            return;
        }
        if (!Intrinsics.areEqual(nullCheckedExpression.getText(), sizeCheckedExpression.getText())) {
            return;
        }
        String message = "This '" + expression2.getText() + "' can be replaced with 'isNullOrEmpty()' call";
        this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, expression2, 0, 2, null), message, null, null, 24, null));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSimpleNameExpression(KtExpression $this$isSimpleNameExpression) {
        if ($this$isSimpleNameExpression instanceof KtSimpleNameExpression) return true;
        KtExpression $this$safeAs$iv = $this$isSimpleNameExpression;
        boolean $i$f$safeAs = false;
        KtExpression ktExpression = $this$safeAs$iv;
        if (!(ktExpression instanceof KtQualifiedExpression)) {
            ktExpression = null;
        }
        KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)ktExpression;
        if (!((ktQualifiedExpression != null ? ktQualifiedExpression.getSelectorExpression() : null) instanceof KtSimpleNameExpression)) return false;
        return true;
    }

    private final KtExpression nullCheckedExpression(KtBinaryExpression $this$nullCheckedExpression) {
        KtExpression ktExpression;
        KtExpression ktExpression2;
        if (!Intrinsics.areEqual($this$nullCheckedExpression.getOperationToken(), KtTokens.EQEQ)) {
            return null;
        }
        KtExpression ktExpression3 = this.isNullKeyword($this$nullCheckedExpression.getRight()) ? $this$nullCheckedExpression.getLeft() : (ktExpression2 = this.isNullKeyword($this$nullCheckedExpression.getLeft()) ? $this$nullCheckedExpression.getRight() : null);
        if (ktExpression2 != null) {
            KtExpression ktExpression4;
            KtExpression it = ktExpression4 = ktExpression2;
            boolean bl = false;
            KotlinType kotlinType = CallUtilKt.getType(it, this.getBindingContext());
            ktExpression = (kotlinType != null ? KotlinTypeKt.isNullable(kotlinType) : false) ? ktExpression4 : null;
        } else {
            ktExpression = null;
        }
        return ktExpression;
    }

    private final KtExpression sizeCheckedExpression(KtExpression $this$sizeCheckedExpression) {
        KtExpression ktExpression = $this$sizeCheckedExpression;
        return ktExpression instanceof KtDotQualifiedExpression ? this.sizeCheckedExpression((KtDotQualifiedExpression)$this$sizeCheckedExpression) : (ktExpression instanceof KtBinaryExpression ? this.sizeCheckedExpression((KtBinaryExpression)$this$sizeCheckedExpression) : null);
    }

    private final KtExpression sizeCheckedExpression(KtDotQualifiedExpression $this$sizeCheckedExpression) {
        KtExpression ktExpression;
        if (!this.isCalling($this$sizeCheckedExpression.getSelectorExpression(), emptyCheckFunctions)) {
            return null;
        }
        KtExpression it = ktExpression = $this$sizeCheckedExpression.getReceiverExpression();
        boolean bl = false;
        return this.isCollectionOrArrayOrString(it) ? ktExpression : null;
    }

    private final KtExpression sizeCheckedExpression(KtBinaryExpression $this$sizeCheckedExpression) {
        KtExpression ktExpression;
        if (!Intrinsics.areEqual($this$sizeCheckedExpression.getOperationToken(), KtTokens.EQEQ)) {
            return null;
        }
        if (this.isEmptyString($this$sizeCheckedExpression.getRight())) {
            KtExpression ktExpression2 = $this$sizeCheckedExpression.getLeft();
            ktExpression = ktExpression2 != null ? this.sizeCheckedEmptyString(ktExpression2) : null;
        } else if (this.isEmptyString($this$sizeCheckedExpression.getLeft())) {
            KtExpression ktExpression3 = $this$sizeCheckedExpression.getRight();
            ktExpression = ktExpression3 != null ? this.sizeCheckedEmptyString(ktExpression3) : null;
        } else if (this.isZero($this$sizeCheckedExpression.getRight())) {
            KtExpression ktExpression4 = $this$sizeCheckedExpression.getLeft();
            ktExpression = ktExpression4 != null ? this.sizeCheckedEqualToZero(ktExpression4) : null;
        } else if (this.isZero($this$sizeCheckedExpression.getLeft())) {
            KtExpression ktExpression5 = $this$sizeCheckedExpression.getRight();
            ktExpression = ktExpression5 != null ? this.sizeCheckedEqualToZero(ktExpression5) : null;
        } else {
            ktExpression = null;
        }
        return ktExpression;
    }

    private final KtExpression sizeCheckedEmptyString(KtExpression $this$sizeCheckedEmptyString) {
        KtExpression ktExpression;
        KtExpression it = ktExpression = $this$sizeCheckedEmptyString;
        boolean bl = false;
        return this.isString(it) ? ktExpression : null;
    }

    private final KtExpression sizeCheckedEqualToZero(KtExpression $this$sizeCheckedEqualToZero) {
        if (!($this$sizeCheckedEqualToZero instanceof KtDotQualifiedExpression)) {
            return null;
        }
        KtExpression receiver = ((KtDotQualifiedExpression)$this$sizeCheckedEqualToZero).getReceiverExpression();
        KtExpression ktExpression = ((KtDotQualifiedExpression)$this$sizeCheckedEqualToZero).getSelectorExpression();
        if (ktExpression == null) {
            return null;
        }
        KtExpression selector = ktExpression;
        if (selector instanceof KtCallExpression ? !this.isCollectionOrArrayOrString(receiver) || !this.isCalling(selector, countFunctions) : (Intrinsics.areEqual(selector.getText(), "size") ? !this.isCollectionOrArray(receiver) : Intrinsics.areEqual(selector.getText(), "length") && !this.isString(receiver))) {
            return null;
        }
        return receiver;
    }

    private final boolean isNullKeyword(KtExpression $this$isNullKeyword) {
        KtExpression ktExpression = $this$isNullKeyword;
        return Intrinsics.areEqual(ktExpression != null ? ktExpression.getText() : null, KtTokens.NULL_KEYWORD.getValue());
    }

    private final boolean isZero(KtExpression $this$isZero) {
        KtExpression ktExpression = $this$isZero;
        return Intrinsics.areEqual(ktExpression != null ? ktExpression.getText() : null, "0");
    }

    private final boolean isEmptyString(KtExpression $this$isEmptyString) {
        KtExpression ktExpression = $this$isEmptyString;
        return Intrinsics.areEqual(ktExpression != null ? ktExpression.getText() : null, "\"\"");
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isCalling(KtExpression $this$isCalling, List<FqName> fqNames) {
        Object object;
        void $this$mapTo$iv$iv;
        KtExpression ktExpression;
        block11: {
            KtExpression ktExpression2;
            KtExpression ktExpression3;
            block10: {
                ktExpression = $this$isCalling;
                if (ktExpression == null) break block10;
                KtExpression $this$safeAs$iv = ktExpression;
                boolean $i$f$safeAs = false;
                KtExpression ktExpression4 = $this$safeAs$iv;
                if (!(ktExpression4 instanceof KtCallExpression)) {
                    ktExpression4 = null;
                }
                if ((ktExpression = (KtCallExpression)ktExpression4) != null) break block11;
            }
            UseIsNullOrEmpty $this$safeAs$iv = this;
            boolean $i$f$safeAs = false;
            UseIsNullOrEmpty useIsNullOrEmpty = $this$safeAs$iv;
            if (!(useIsNullOrEmpty instanceof KtDotQualifiedExpression)) {
                useIsNullOrEmpty = null;
            }
            if ((ktExpression3 = (KtDotQualifiedExpression)((Object)useIsNullOrEmpty)) != null && (ktExpression3 = ktExpression3.getSelectorExpression()) != null) {
                KtExpression $this$safeAs$iv2 = ktExpression3;
                boolean $i$f$safeAs2 = false;
                KtExpression ktExpression5 = $this$safeAs$iv2;
                if (!(ktExpression5 instanceof KtCallExpression)) {
                    ktExpression5 = null;
                }
                ktExpression2 = (KtCallExpression)ktExpression5;
            } else {
                ktExpression2 = ktExpression = null;
            }
            if (ktExpression2 == null) {
                return false;
            }
        }
        KtExpression callExpression = ktExpression;
        Iterable $this$map$iv = fqNames;
        boolean $i$f$map = false;
        Iterable $i$f$safeAs = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FqName fqName = (FqName)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.shortName().asString());
        }
        KtExpression ktExpression6 = ((KtCallExpression)callExpression).getCalleeExpression();
        return CollectionsKt.contains((List)destination$iv$iv, ktExpression6 != null ? ktExpression6.getText() : null) && CollectionsKt.contains((Iterable)fqNames, (object = CallUtilKt.getResolvedCall(callExpression, this.getBindingContext())) != null && (object = object.getResultingDescriptor()) != null ? DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)object) : null);
    }

    private final FqName classFqName(KtExpression $this$classFqName) {
        KotlinType kotlinType = CallUtilKt.getType($this$classFqName, this.getBindingContext());
        return kotlinType != null ? TypeUtilsKt.fqNameOrNull(kotlinType) : null;
    }

    private final boolean isCollectionOrArrayOrString(KtExpression $this$isCollectionOrArrayOrString) {
        FqName fqName = this.classFqName($this$isCollectionOrArrayOrString);
        if (fqName == null) {
            return false;
        }
        FqName classFqName = fqName;
        return CollectionsKt.contains((Iterable)collectionClasses, this.classFqName($this$isCollectionOrArrayOrString)) || Intrinsics.areEqual(classFqName, arrayClass) || Intrinsics.areEqual(classFqName, stringClass);
    }

    private final boolean isCollectionOrArray(KtExpression $this$isCollectionOrArray) {
        FqName fqName = this.classFqName($this$isCollectionOrArray);
        if (fqName == null) {
            return false;
        }
        FqName classFqName = fqName;
        return CollectionsKt.contains((Iterable)collectionClasses, this.classFqName($this$isCollectionOrArray)) || Intrinsics.areEqual(classFqName, arrayClass);
    }

    private final boolean isString(KtExpression $this$isString) {
        return Intrinsics.areEqual(this.classFqName($this$isString), stringClass);
    }

    public UseIsNullOrEmpty() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        String p0;
        String it;
        Collection collection;
        Object item$iv$iv;
        Object $this$mapTo$iv$iv;
        Companion = new Companion(null);
        FqName[] fqNameArray = new FqName[]{StandardNames.FqNames.list, StandardNames.FqNames.set, StandardNames.FqNames.collection, StandardNames.FqNames.map, StandardNames.FqNames.mutableList, StandardNames.FqNames.mutableSet, StandardNames.FqNames.mutableCollection, StandardNames.FqNames.mutableMap};
        collectionClasses = CollectionsKt.listOf(fqNameArray);
        FqName fqName = StandardNames.FqNames.array.toSafe();
        Intrinsics.checkNotNullExpressionValue(fqName, "toSafe(...)");
        arrayClass = fqName;
        FqName fqName2 = StandardNames.FqNames.string.toSafe();
        Intrinsics.checkNotNullExpressionValue(fqName2, "toSafe(...)");
        stringClass = fqName2;
        Object $this$map$iv = (String[])collectionClasses;
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            FqName fqName3 = (FqName)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new FqName(it + ".isEmpty"));
        }
        $this$map$iv = new String[]{"kotlin.collections.isEmpty", "kotlin.text.isEmpty"};
        $this$map$iv = CollectionsKt.listOf($this$map$iv);
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            it = (String)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            boolean $i$f$emptyCheckFunctions$stub_for_inlining = false;
            collection2.add(new FqName(p0));
        }
        emptyCheckFunctions = CollectionsKt.plus(collection, (Iterable)((List)destination$iv$iv));
        $this$map$iv = new String[]{"kotlin.collections.count", "kotlin.text.count"};
        $this$map$iv = CollectionsKt.listOf($this$map$iv);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            p0 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            boolean $i$f$countFunctions$stub_for_inlining$5 = false;
            collection.add(new FqName(p0));
        }
        countFunctions = (List)var3_3;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UseIsNullOrEmpty$Companion;", "", "<init>", "()V", "collectionClasses", "", "Lorg/jetbrains/kotlin/name/FqName;", "arrayClass", "stringClass", "emptyCheckFunctions", "countFunctions", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

