/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi2ir.KotlinUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UseOrEmpty;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitBinaryExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "isEmptyElement", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Companion", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nUseOrEmpty.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UseOrEmpty.kt\nio/gitlab/arturbosch/detekt/rules/style/UseOrEmpty\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n1187#2,2:124\n1261#2,4:126\n1187#2,2:130\n1261#2,4:132\n*S KotlinDebug\n*F\n+ 1 UseOrEmpty.kt\nio/gitlab/arturbosch/detekt/rules/style/UseOrEmpty\n*L\n106#1:124,2\n106#1:126,4\n117#1:130,2\n117#1:132,4\n*E\n"})
public final class UseOrEmpty
extends Rule {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Issue issue;
    @NotNull
    private static final Map<String, FqName> emptyFunctions;
    @NotNull
    private static final Map<String, FqName> factoryFunctions;

    public UseOrEmpty(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("UseOrEmpty", Severity.Style, "Use `orEmpty()` call instead of `?:` with empty collection factory methods", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UseOrEmpty(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        super.visitBinaryExpression(expression2);
        if (!Intrinsics.areEqual(expression2.getOperationToken(), KtTokens.ELVIS)) {
            return;
        }
        KtExpression ktExpression = expression2.getLeft();
        if (ktExpression == null) {
            return;
        }
        KtExpression left = ktExpression;
        KtExpression ktExpression2 = expression2.getRight();
        if (ktExpression2 == null) {
            return;
        }
        KtExpression right = ktExpression2;
        if (!this.isEmptyElement(right)) {
            return;
        }
        KotlinType kotlinType = CallUtilKt.getType(left, this.getBindingContext());
        if (kotlinType == null) {
            return;
        }
        KotlinType leftType = kotlinType;
        if (!KotlinTypeKt.isNullable(leftType)) {
            return;
        }
        if (KotlinUtilsKt.deparenthesize(left) instanceof KtArrayAccessExpression) {
            FunctionDescriptor functionDescriptor;
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(left, this.getBindingContext());
            CallableDescriptor callableDescriptor = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
            FunctionDescriptor functionDescriptor2 = functionDescriptor = callableDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)callableDescriptor : null;
            if (functionDescriptor != null && functionDescriptor.isOperator()) {
                List<TypeParameterDescriptor> list = functionDescriptor.getTypeParameters();
                Intrinsics.checkNotNullExpressionValue(list, "getTypeParameters(...)");
                if (!((Collection)list).isEmpty()) {
                    return;
                }
            }
        }
        KotlinType kotlinType2 = CallUtilKt.getType(right, this.getBindingContext());
        if (kotlinType2 == null) {
            return;
        }
        KotlinType rightType = kotlinType2;
        if (!TypeUtilsKt.isSubtypeOf(TypeUtilsKt.makeNotNullable(leftType), rightType)) {
            return;
        }
        String message = "This '" + KtTokens.ELVIS.getValue() + ' ' + right.getText() + "' can be replaced with 'orEmpty()' call";
        this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, expression2, 0, 2, null), message, null, null, 24, null));
    }

    private final boolean isEmptyElement(KtExpression $this$isEmptyElement) {
        KtExpression ktExpression = $this$isEmptyElement;
        if (ktExpression instanceof KtCallExpression) {
            Object object = ((KtCallExpression)$this$isEmptyElement).getCalleeExpression();
            if (object == null || (object = object.getText()) == null) {
                return false;
            }
            Object calleeText = object;
            FqName emptyFunction = emptyFunctions.get(calleeText);
            FqName factoryFunction = factoryFunctions.get(calleeText);
            if (emptyFunction == null && factoryFunction == null) {
                return false;
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall($this$isEmptyElement, this.getBindingContext());
            if (resolvedCall2 == null || (resolvedCall2 = resolvedCall2.getResultingDescriptor()) == null || (resolvedCall2 = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((Object)resolvedCall2))) == null) {
                return false;
            }
            ResolvedCall<? extends CallableDescriptor> fqName = resolvedCall2;
            return Intrinsics.areEqual(fqName, emptyFunction) || Intrinsics.areEqual(fqName, factoryFunction) && ((KtCallExpression)$this$isEmptyElement).getValueArguments().isEmpty();
        }
        if (ktExpression instanceof KtStringTemplateExpression) {
            KtStringTemplateEntry[] ktStringTemplateEntryArray = ((KtStringTemplateExpression)$this$isEmptyElement).getEntries();
            Intrinsics.checkNotNullExpressionValue(ktStringTemplateEntryArray, "getEntries(...)");
            return ((Object[])ktStringTemplateEntryArray).length == 0;
        }
        return false;
    }

    public UseOrEmpty() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        FqName fqName;
        Object it;
        Map map2;
        Object element$iv$iv;
        Object $this$associateTo$iv$iv;
        Companion = new Companion(null);
        String[] stringArray = new String[]{"kotlin.collections.emptyList", "kotlin.collections.emptySet", "kotlin.collections.emptyMap", "kotlin.sequences.emptySequence", "kotlin.emptyArray"};
        Object $this$associate$iv = (String[])CollectionsKt.listOf(stringArray);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        String[] stringArray2 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        Iterator iterator2 = $this$associateTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = iterator2.next();
            map2 = destination$iv$iv;
            it = (String)element$iv$iv;
            boolean bl = false;
            fqName = new FqName((String)it);
            it = TuplesKt.to(fqName.shortName().asString(), fqName);
            map2.put(((Pair)it).getFirst(), ((Pair)it).getSecond());
        }
        emptyFunctions = destination$iv$iv;
        $this$associate$iv = new String[]{"kotlin.collections.listOf", "kotlin.collections.setOf", "kotlin.collections.mapOf", "kotlin.sequences.sequenceOf", "kotlin.arrayOf"};
        $this$associate$iv = CollectionsKt.listOf($this$associate$iv);
        $i$f$associate = false;
        capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        $this$associateTo$iv$iv = $this$associate$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        $i$f$associateTo = false;
        iterator2 = $this$associateTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = iterator2.next();
            map2 = destination$iv$iv;
            it = (String)element$iv$iv;
            boolean bl = false;
            fqName = new FqName((String)it);
            Pair<String, FqName> pair = TuplesKt.to(fqName.shortName().asString(), fqName);
            map2.put(pair.getFirst(), pair.getSecond());
        }
        factoryFunctions = destination$iv$iv;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001f\u0010\u0004\u001a\u0013\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u0007\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\t\u001a\u0013\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u0007\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UseOrEmpty$Companion;", "", "<init>", "()V", "emptyFunctions", "", "", "Lkotlin/jvm/internal/EnhancedNullability;", "Lorg/jetbrains/kotlin/name/FqName;", "factoryFunctions", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

