/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.KtValueArgumentKt;
import io.gitlab.arturbosch.detekt.rules.ThrowExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u000e\u001a\u00020\u000f*\u00020\rH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UseRequire;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitThrowExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtThrowExpression;", "hasMoreExpressionsInBlock", "", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nUseRequire.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UseRequire.kt\nio/gitlab/arturbosch/detekt/rules/style/UseRequire\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1#2:58\n*E\n"})
public final class UseRequire
extends Rule {
    @NotNull
    private final Issue issue;

    public UseRequire(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("UseRequire", Severity.Style, "Use require() instead of throwing an IllegalArgumentException.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UseRequire(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitThrowExpression(@NotNull KtThrowExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (!ThrowExtensionsKt.isIllegalArgumentException(expression2)) {
            return;
        }
        if (this.hasMoreExpressionsInBlock(expression2)) {
            return;
        }
        if (ThrowExtensionsKt.isEnclosedByConditionalStatement(expression2) && KtValueArgumentKt.isEmptyOrSingleStringArgument(ThrowExtensionsKt.getArguments(expression2), this.getBindingContext())) {
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, expression2, 0, 2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
    }

    private final boolean hasMoreExpressionsInBlock(KtThrowExpression $this$hasMoreExpressionsInBlock) {
        boolean bl;
        PsiElement psiElement = $this$hasMoreExpressionsInBlock.getParent();
        KtBlockExpression ktBlockExpression = psiElement instanceof KtBlockExpression ? (KtBlockExpression)psiElement : null;
        if (ktBlockExpression != null) {
            KtBlockExpression $this$hasMoreExpressionsInBlock_u24lambda_u240 = ktBlockExpression;
            boolean bl2 = false;
            bl = $this$hasMoreExpressionsInBlock_u24lambda_u240.getStatements().size() > 1;
        } else {
            bl = false;
        }
        return bl;
    }

    public UseRequire() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }
}

