/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.KtCallExpressionKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u000e\u001a\u00020\u000f*\u00020\rH\u0002J\u0014\u0010\u0010\u001a\u00020\u000f*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UseSumOfInsteadOfFlatMapSize;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "isFlatMapOrFlatten", "", "isSizeOrCount", "Lorg/jetbrains/kotlin/psi/KtExpression;", "receiver", "Companion", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nUseSumOfInsteadOfFlatMapSize.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UseSumOfInsteadOfFlatMapSize.kt\nio/gitlab/arturbosch/detekt/rules/style/UseSumOfInsteadOfFlatMapSize\n+ 2 Junk.kt\nio/gitlab/arturbosch/detekt/rules/JunkKt\n*L\n1#1,86:1\n40#2:87\n40#2:88\n40#2:89\n40#2:90\n*S KotlinDebug\n*F\n+ 1 UseSumOfInsteadOfFlatMapSize.kt\nio/gitlab/arturbosch/detekt/rules/style/UseSumOfInsteadOfFlatMapSize\n*L\n61#1:87\n69#1:88\n71#1:89\n74#1:90\n*E\n"})
public final class UseSumOfInsteadOfFlatMapSize
extends Rule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Issue issue;
    @NotNull
    private static final List<FqName> flatMapAndFlattenFqName;
    @NotNull
    private static final FqName countFqName;

    public UseSumOfInsteadOfFlatMapSize(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Style, "Use `sumOf` instead of `flatMap` and `size/count` calls", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UseSumOfInsteadOfFlatMapSize(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression2) {
        Object object;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        super.visitCallExpression(expression2);
        Object object2 = expression2.getCalleeExpression();
        if (object2 == null || (object2 = object2.getText()) == null) {
            return;
        }
        Object calleeText = object2;
        if (!this.isFlatMapOrFlatten(expression2)) {
            return;
        }
        KtExpression receiver = KtPsiUtilKt.getQualifiedExpressionForSelectorOrThis(expression2);
        KtExpression ktExpression = KtPsiUtilKt.getQualifiedExpressionForReceiver(receiver);
        if (ktExpression == null || (ktExpression = ktExpression.getSelectorExpression()) == null) {
            return;
        }
        KtExpression selector = ktExpression;
        if (!this.isSizeOrCount(selector, receiver)) {
            return;
        }
        KtExpression $this$safeAs$iv = selector;
        boolean $i$f$safeAs = false;
        KtExpression ktExpression2 = $this$safeAs$iv;
        if (!(ktExpression2 instanceof KtCallExpression)) {
            ktExpression2 = null;
        }
        if ((object = (KtCallExpression)ktExpression2) == null || (object = ((KtCallExpression)object).getCalleeExpression()) == null || (object = object.getText()) == null) {
            object = selector.getText();
        }
        Object selectorText = object;
        String message = "Use 'sumOf' instead of '" + (String)calleeText + "' and '" + (String)selectorText + '\'';
        this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, expression2, 0, 2, null), message, null, null, 24, null));
    }

    private final boolean isFlatMapOrFlatten(KtCallExpression $this$isFlatMapOrFlatten) {
        return KtCallExpressionKt.isCalling($this$isFlatMapOrFlatten, flatMapAndFlattenFqName, this.getBindingContext());
    }

    private final boolean isSizeOrCount(KtExpression $this$isSizeOrCount, KtExpression receiver) {
        boolean $i$f$safeAs;
        KtExpression $this$safeAs$iv;
        block7: {
            ClassifierDescriptor classifierDescriptor;
            block9: {
                block8: {
                    $this$safeAs$iv = $this$isSizeOrCount;
                    $i$f$safeAs = false;
                    KtExpression ktExpression = $this$safeAs$iv;
                    if (!(ktExpression instanceof KtNameReferenceExpression)) {
                        ktExpression = null;
                    }
                    KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)ktExpression;
                    if (!Intrinsics.areEqual(ktNameReferenceExpression != null ? ktNameReferenceExpression.getText() : null, "size")) break block7;
                    KotlinType kotlinType = CallUtilKt.getType(receiver, this.getBindingContext());
                    if (kotlinType == null) {
                        return false;
                    }
                    KotlinType receiverType = kotlinType;
                    classifierDescriptor = receiverType.getConstructor().getDeclarationDescriptor();
                    if (classifierDescriptor == null) break block8;
                    ClassifierDescriptor $this$safeAs$iv2 = classifierDescriptor;
                    boolean $i$f$safeAs2 = false;
                    ClassifierDescriptor classifierDescriptor2 = $this$safeAs$iv2;
                    if (!(classifierDescriptor2 instanceof ClassDescriptor)) {
                        classifierDescriptor2 = null;
                    }
                    if ((classifierDescriptor = (ClassDescriptor)classifierDescriptor2) != null) break block9;
                }
                return false;
            }
            ClassifierDescriptor descriptor2 = classifierDescriptor;
            ClassDescriptor classDescriptor = DefaultBuiltIns.Companion.getInstance().getList();
            Intrinsics.checkNotNullExpressionValue(classDescriptor, "getList(...)");
            return DescriptorUtilsKt.isSubclassOf((ClassDescriptor)descriptor2, classDescriptor);
        }
        $this$safeAs$iv = $this$isSizeOrCount;
        $i$f$safeAs = false;
        KtExpression ktExpression = $this$safeAs$iv;
        if (!(ktExpression instanceof KtCallExpression)) {
            ktExpression = null;
        }
        KtCallExpression ktCallExpression = (KtCallExpression)ktExpression;
        return ktCallExpression != null ? KtCallExpressionKt.isCalling(ktCallExpression, countFqName, this.getBindingContext()) : false;
    }

    public UseSumOfInsteadOfFlatMapSize() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        FqName[] fqNameArray = new FqName[]{new FqName("kotlin.collections.flatMap"), new FqName("kotlin.collections.flatten")};
        flatMapAndFlattenFqName = CollectionsKt.listOf(fqNameArray);
        countFqName = new FqName("kotlin.collections.count");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UseSumOfInsteadOfFlatMapSize$Companion;", "", "<init>", "()V", "flatMapAndFlattenFqName", "", "Lorg/jetbrains/kotlin/name/FqName;", "countFqName", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

