/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style.optional;

import io.github.detekt.metrics.LinesOfCodeKt;
import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.style.optional.MandatoryBracesLoops$checkForBraces$;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0013H\u0002J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0011H\u0002J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0013H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/optional/MandatoryBracesLoops;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitForExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "visitWhileExpression", "Lorg/jetbrains/kotlin/psi/KtWhileExpression;", "visitDoWhileExpression", "Lorg/jetbrains/kotlin/psi/KtDoWhileExpression;", "checkForBraces", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "isNotBlockExpression", "", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nMandatoryBracesLoops.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MandatoryBracesLoops.kt\nio/gitlab/arturbosch/detekt/rules/style/optional/MandatoryBracesLoops\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,108:1\n477#2:109\n1251#2,2:110\n477#2:112\n1251#2,2:113\n*S KotlinDebug\n*F\n+ 1 MandatoryBracesLoops.kt\nio/gitlab/arturbosch/detekt/rules/style/optional/MandatoryBracesLoops\n*L\n84#1:109\n85#1:110,2\n98#1:112\n99#1:113,2\n*E\n"})
public final class MandatoryBracesLoops
extends Rule {
    @NotNull
    private final Issue issue;

    public MandatoryBracesLoops(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("MandatoryBracesLoops", Severity.Style, "A multi-line loop was found that does not have braces. These should be added to improve readability.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ MandatoryBracesLoops(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitForExpression(@NotNull KtForExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.checkForBraces(expression2);
        super.visitForExpression(expression2);
    }

    @Override
    public void visitWhileExpression(@NotNull KtWhileExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.checkForBraces(expression2);
        super.visitWhileExpression(expression2);
    }

    @Override
    public void visitDoWhileExpression(@NotNull KtDoWhileExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.checkForBraces(expression2);
        super.visitDoWhileExpression(expression2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void checkForBraces(KtLoopExpression expression2) {
        PsiWhiteSpace it;
        void $this$any$iv;
        void $this$filterIsInstance$iv;
        if (!this.isNotBlockExpression(expression2)) return;
        PsiElement psiElement = expression2.getRightParenthesis();
        if (psiElement == null) return;
        Sequence<PsiElement> sequence2 = PsiUtilsKt.siblings(psiElement, true, false);
        if (sequence2 == null) return;
        Sequence<PsiElement> sequence3 = sequence2;
        boolean $i$f$filterIsInstance22 = false;
        Sequence sequence4 = SequencesKt.filter($this$filterIsInstance$iv, checkForBraces$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull(sequence4, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Sequence sequence5 = sequence4;
        if (sequence5 == null) return;
        Sequence $i$f$filterIsInstance22 = sequence5;
        boolean $i$f$any = false;
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return;
            Object element$iv = iterator2.next();
            it = (PsiWhiteSpace)element$iv;
            boolean bl = false;
        } while (!it.textContains('\n'));
        boolean bl = true;
        boolean hasNoBraces = bl;
        if (!hasNoBraces) return;
        Issue issue = this.getIssue();
        KtExpression ktExpression = expression2.getBody();
        if (ktExpression == null) {
            ktExpression = expression2;
        }
        this.report(new CodeSmell(issue, Entity.Companion.from$default(Entity.Companion, ktExpression, 0, 2, null), this.getIssue().getDescription(), null, null, 24, null));
    }

    private final void checkForBraces(KtDoWhileExpression expression2) {
        if (this.isNotBlockExpression(expression2) && LinesOfCodeKt.linesOfCode$default(expression2, null, 1, null) > 1) {
            boolean hasNoBraces;
            block4: {
                boolean bl;
                Sequence<PsiElement> $this$filterIsInstance$iv = SequencesKt.takeWhile(PsiUtilsKt.siblings(expression2, true, false), arg_0 -> MandatoryBracesLoops.checkForBraces$lambda$1(expression2, arg_0));
                boolean $i$f$filterIsInstance = false;
                Sequence<PsiElement> sequence2 = SequencesKt.filter($this$filterIsInstance$iv, checkForBraces$$inlined$filterIsInstance$2.INSTANCE);
                Intrinsics.checkNotNull(sequence2, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                Sequence<PsiElement> $this$any$iv = sequence2;
                boolean $i$f$any = false;
                Iterator<PsiElement> iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    PsiElement element$iv = iterator2.next();
                    PsiWhiteSpace it = (PsiWhiteSpace)element$iv;
                    boolean bl2 = false;
                    if (!it.textContains('\n')) continue;
                    bl = true;
                    break block4;
                }
                bl = hasNoBraces = false;
            }
            if (hasNoBraces) {
                Issue issue = this.getIssue();
                KtExpression ktExpression = expression2.getBody();
                if (ktExpression == null) {
                    ktExpression = expression2;
                }
                this.report(new CodeSmell(issue, Entity.Companion.from$default(Entity.Companion, ktExpression, 0, 2, null), this.getIssue().getDescription(), null, null, 24, null));
            }
        }
    }

    private final boolean isNotBlockExpression(KtLoopExpression $this$isNotBlockExpression) {
        return !($this$isNotBlockExpression.getBody() instanceof KtBlockExpression);
    }

    private static final boolean checkForBraces$lambda$1(KtDoWhileExpression $expression, PsiElement it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !Intrinsics.areEqual(it, $expression.getWhileKeyword());
    }

    public MandatoryBracesLoops() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }
}

