/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style.optional;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslatorKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\rH\u0002J\f\u0010\u001a\u001a\u00020\u0012*\u00020\u0013H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001c"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/optional/OptionalUnit;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitBlockExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "canBeUsedAsValue", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "checkFunctionWithExplicitReturnType", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "checkFunctionWithInferredReturnType", "createMessage", "", "isGenericOrNothingType", "Companion", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nOptionalUnit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptionalUnit.kt\nio/gitlab/arturbosch/detekt/rules/style/optional/OptionalUnit\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,146:1\n774#2:147\n865#2:148\n866#2:151\n2642#2:152\n15#3,2:149\n1#4:153\n*S KotlinDebug\n*F\n+ 1 OptionalUnit.kt\nio/gitlab/arturbosch/detekt/rules/style/optional/OptionalUnit\n*L\n77#1:147\n77#1:148\n77#1:151\n89#1:152\n84#1:149,2\n89#1:153\n*E\n"})
public final class OptionalUnit
extends Rule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Issue issue;
    @NotNull
    private static final String UNIT = "Unit";

    public OptionalUnit(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Style, "Return type of `Unit` is unnecessary and can be safely removed.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ OptionalUnit(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        KtTypeReference typeReference = function2.getTypeReference();
        if (typeReference != null) {
            this.checkFunctionWithExplicitReturnType(function2, typeReference);
        } else if (!KtModifierListKt.isOverride(function2)) {
            this.checkFunctionWithInferredReturnType(function2);
        }
        super.visitNamedFunction(function2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitBlockExpression(@NotNull KtBlockExpression expression2) {
        void $this$onEach$iv;
        KtExpression it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        List<KtExpression> list = expression2.getStatements();
        Intrinsics.checkNotNullExpressionValue(list, "getStatements(...)");
        List<KtExpression> statements = list;
        KtExpression ktExpression = CollectionsKt.lastOrNull(statements);
        if (ktExpression == null) {
            return;
        }
        KtExpression lastStatement = ktExpression;
        Iterable iterable = statements;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            it = (KtExpression)element$iv$iv;
            boolean bl2 = false;
            if (!(it instanceof KtNameReferenceExpression) || !Intrinsics.areEqual(((KtNameReferenceExpression)it).getText(), UNIT)) {
                bl = false;
            } else if (!Intrinsics.areEqual(it, lastStatement) || Intrinsics.areEqual(this.getBindingContext(), BindingContext.EMPTY)) {
                bl = true;
            } else if (!BindingContextUtilsKt.isUsedAsExpression(it, this.getBindingContext())) {
                bl = true;
            } else {
                KtExpression prev;
                Object object;
                PsiElement psiElement;
                block10: {
                    Sequence<PsiElement> $this$firstIsInstanceOrNull$iv = PsiUtilsKt.siblings(it, false, false);
                    boolean $i$f$firstIsInstanceOrNull = false;
                    Iterator<PsiElement> iterator2 = $this$firstIsInstanceOrNull$iv.iterator();
                    while (iterator2.hasNext()) {
                        PsiElement element$iv = iterator2.next();
                        if (!(element$iv instanceof KtExpression)) continue;
                        psiElement = element$iv;
                        break block10;
                    }
                    psiElement = null;
                }
                bl = ((object = (prev = (KtExpression)psiElement)) != null && (object = CallUtilKt.getType((KtExpression)object, this.getBindingContext())) != null ? TypeUtilsKt.isUnit((KotlinType)object) : false) && this.canBeUsedAsValue(prev);
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$onEach = false;
        void $this$onEach_u24lambda_u2419$iv = var6_6 = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2419$iv) {
            it = (KtExpression)element$iv;
            boolean bl3 = false;
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, expression2, 0, 2, null), "A single Unit expression is unnecessary and can safely be removed.", null, null, 24, null));
        }
        super.visitBlockExpression(expression2);
    }

    private final boolean canBeUsedAsValue(KtExpression $this$canBeUsedAsValue) {
        boolean bl;
        KtExpression ktExpression = $this$canBeUsedAsValue;
        if (ktExpression instanceof KtIfExpression) {
            KtExpression elseExpression = ((KtIfExpression)$this$canBeUsedAsValue).getElse();
            bl = elseExpression instanceof KtIfExpression ? this.canBeUsedAsValue(elseExpression) : elseExpression != null;
        } else if (ktExpression instanceof KtWhenExpression) {
            List<KtWhenEntry> list = ((KtWhenExpression)$this$canBeUsedAsValue).getEntries();
            Intrinsics.checkNotNullExpressionValue(list, "getEntries(...)");
            KtWhenEntry ktWhenEntry = CollectionsKt.lastOrNull(list);
            bl = (ktWhenEntry != null ? ktWhenEntry.getElseKeyword() : null) != null || WhenChecker.INSTANCE.getMissingCases((KtWhenExpression)$this$canBeUsedAsValue, this.getBindingContext()).isEmpty();
        } else {
            bl = true;
        }
        return bl;
    }

    private final void checkFunctionWithExplicitReturnType(KtNamedFunction function2, KtTypeReference typeReference) {
        String typeElementText;
        KtTypeElement ktTypeElement = typeReference.getTypeElement();
        String string2 = typeElementText = ktTypeElement != null ? ktTypeElement.getText() : null;
        if (Intrinsics.areEqual(typeElementText, UNIT)) {
            KtExpression initializer;
            KtExpression ktExpression = initializer = function2.getInitializer();
            boolean bl = ktExpression != null ? this.isGenericOrNothingType(ktExpression) : false;
            if (bl) {
                return;
            }
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, typeReference, 0, 2, null), this.createMessage(function2), null, null, 24, null));
        }
    }

    private final void checkFunctionWithInferredReturnType(KtNamedFunction function2) {
        KtNameReferenceExpression referenceExpression;
        KtExpression ktExpression = function2.getBodyExpression();
        KtNameReferenceExpression ktNameReferenceExpression = referenceExpression = ktExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression : null;
        if (referenceExpression != null && Intrinsics.areEqual(referenceExpression.getText(), UNIT)) {
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, referenceExpression, 0, 2, null), this.createMessage(function2), null, null, 24, null));
        }
    }

    private final String createMessage(KtNamedFunction function2) {
        return "The function " + function2.getName() + " defines a return type of Unit. This is unnecessary and can safely be removed.";
    }

    private final boolean isGenericOrNothingType(KtExpression $this$isGenericOrNothingType) {
        if (Intrinsics.areEqual(this.getBindingContext(), BindingContext.EMPTY)) {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall($this$isGenericOrNothingType, this.getBindingContext());
        boolean isGenericType = resolvedCall2 != null && (resolvedCall2 = CallTranslatorKt.getReturnType(resolvedCall2)) != null ? TypeUtilsKt.isTypeParameter((KotlinType)((Object)resolvedCall2)) : false;
        KotlinType kotlinType = CallUtilKt.getType($this$isGenericOrNothingType, this.getBindingContext());
        boolean isNothingType = kotlinType != null ? TypeUtilsKt.isNothing(kotlinType) : false;
        return isGenericType && !isNothingType || isNothingType && !isGenericType;
    }

    public OptionalUnit() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/optional/OptionalUnit$Companion;", "", "<init>", "()V", "UNIT", "", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

