/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Supplier;
import javaslang.collection.AbstractIterator;
import javaslang.collection.LinearSeq;
import javaslang.collection.Queue;
import javaslang.collection.Stream;

interface StreamModule {

    public static final class StreamIterator<T>
    extends AbstractIterator<T> {
        private Supplier<Stream<T>> current = () -> stream;

        StreamIterator(Stream.Cons<T> stream) {
        }

        @Override
        public boolean hasNext() {
            return !this.current.get().isEmpty();
        }

        @Override
        public T getNext() {
            Stream<T> stream = this.current.get();
            this.current = stream::tail;
            return stream.head();
        }
    }

    public static interface StreamFactory {
        public static <T> Stream<T> create(Iterator<? extends T> iterator2) {
            return iterator2.hasNext() ? Stream.cons(iterator2.next(), () -> StreamFactory.create(iterator2)) : Stream.Empty.instance();
        }
    }

    public static final class SerializationProxy<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient Stream.Cons<T> stream;

        SerializationProxy(Stream.Cons<T> stream) {
            this.stream = stream;
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            s.writeInt(this.stream.length());
            LinearSeq<T> l = this.stream;
            while (!l.isEmpty()) {
                s.writeObject(l.head());
                l = l.tail();
            }
        }

        private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
            s.defaultReadObject();
            int size = s.readInt();
            if (size <= 0) {
                throw new InvalidObjectException("No elements");
            }
            Stream<Object> temp = Stream.Empty.instance();
            for (int i2 = 0; i2 < size; ++i2) {
                Object element = s.readObject();
                temp = temp.append(element);
            }
            this.stream = (Stream.Cons)temp;
        }

        private Object readResolve() {
            return this.stream;
        }
    }

    public static final class AppendElements<T>
    extends Stream.Cons<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Queue<T> queue;

        AppendElements(T head2, Queue<T> queue, Supplier<Stream<T>> tail) {
            super(head2, tail);
            this.queue = queue;
        }

        @Override
        public Stream<T> append(T element) {
            return new AppendElements<Object>(this.head, this.queue.append(element), this.tail);
        }

        @Override
        public Stream<T> appendAll(Iterable<? extends T> elements) {
            Objects.requireNonNull(this.queue, "elements is null");
            return this.isEmpty() ? Stream.ofAll(this.queue) : new AppendElements<T>(this.head, this.queue.appendAll(elements), this.tail);
        }

        @Override
        public Stream<T> tail() {
            Stream t = (Stream)this.tail.get();
            if (t.isEmpty()) {
                return Stream.ofAll(this.queue);
            }
            if (t instanceof ConsImpl) {
                ConsImpl c = (ConsImpl)t;
                return new AppendElements(c.head(), this.queue, c.tail);
            }
            AppendElements a2 = (AppendElements)t;
            return new AppendElements(a2.head(), a2.queue.appendAll(this.queue), a2.tail);
        }

        private Object writeReplace() {
            return new SerializationProxy(this);
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            throw new InvalidObjectException("Proxy required");
        }
    }

    public static final class ConsImpl<T>
    extends Stream.Cons<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ConsImpl(T head2, Supplier<Stream<T>> tail) {
            super(head2, tail);
        }

        @Override
        public Stream<T> tail() {
            return (Stream)this.tail.get();
        }

        private Object writeReplace() {
            return new SerializationProxy(this);
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            throw new InvalidObjectException("Proxy required");
        }
    }
}

