/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.protobuf;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import kotlin.reflect.jvm.internal.impl.protobuf.ByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.LazyFieldLite;
import kotlin.reflect.jvm.internal.impl.protobuf.MessageLite;
import kotlin.reflect.jvm.internal.impl.protobuf.WireFormat;

public final class CodedOutputStream {
    private final byte[] buffer;
    private final int limit;
    private int position;
    private int totalBytesWritten = 0;
    private final OutputStream output;

    static int computePreferredBufferSize(int dataLength) {
        if (dataLength > 4096) {
            return 4096;
        }
        return dataLength;
    }

    private CodedOutputStream(OutputStream output2, byte[] buffer) {
        this.output = output2;
        this.buffer = buffer;
        this.position = 0;
        this.limit = buffer.length;
    }

    public static CodedOutputStream newInstance(OutputStream output2, int bufferSize) {
        return new CodedOutputStream(output2, new byte[bufferSize]);
    }

    public void writeDouble(int fieldNumber, double value2) throws IOException {
        this.writeTag(fieldNumber, 1);
        this.writeDoubleNoTag(value2);
    }

    public void writeFloat(int fieldNumber, float value2) throws IOException {
        this.writeTag(fieldNumber, 5);
        this.writeFloatNoTag(value2);
    }

    public void writeInt32(int fieldNumber, int value2) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeInt32NoTag(value2);
    }

    public void writeBool(int fieldNumber, boolean value2) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeBoolNoTag(value2);
    }

    public void writeGroup(int fieldNumber, MessageLite value2) throws IOException {
        this.writeTag(fieldNumber, 3);
        this.writeGroupNoTag(value2);
        this.writeTag(fieldNumber, 4);
    }

    public void writeMessage(int fieldNumber, MessageLite value2) throws IOException {
        this.writeTag(fieldNumber, 2);
        this.writeMessageNoTag(value2);
    }

    public void writeBytes(int fieldNumber, ByteString value2) throws IOException {
        this.writeTag(fieldNumber, 2);
        this.writeBytesNoTag(value2);
    }

    public void writeUInt32(int fieldNumber, int value2) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeUInt32NoTag(value2);
    }

    public void writeEnum(int fieldNumber, int value2) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeEnumNoTag(value2);
    }

    public void writeSInt64(int fieldNumber, long value2) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeSInt64NoTag(value2);
    }

    public void writeMessageSetExtension(int fieldNumber, MessageLite value2) throws IOException {
        this.writeTag(1, 3);
        this.writeUInt32(2, fieldNumber);
        this.writeMessage(3, value2);
        this.writeTag(1, 4);
    }

    public void writeDoubleNoTag(double value2) throws IOException {
        this.writeRawLittleEndian64(Double.doubleToRawLongBits(value2));
    }

    public void writeFloatNoTag(float value2) throws IOException {
        this.writeRawLittleEndian32(Float.floatToRawIntBits(value2));
    }

    public void writeUInt64NoTag(long value2) throws IOException {
        this.writeRawVarint64(value2);
    }

    public void writeInt64NoTag(long value2) throws IOException {
        this.writeRawVarint64(value2);
    }

    public void writeInt32NoTag(int value2) throws IOException {
        if (value2 >= 0) {
            this.writeRawVarint32(value2);
        } else {
            this.writeRawVarint64(value2);
        }
    }

    public void writeFixed64NoTag(long value2) throws IOException {
        this.writeRawLittleEndian64(value2);
    }

    public void writeFixed32NoTag(int value2) throws IOException {
        this.writeRawLittleEndian32(value2);
    }

    public void writeBoolNoTag(boolean value2) throws IOException {
        this.writeRawByte(value2 ? 1 : 0);
    }

    public void writeStringNoTag(String value2) throws IOException {
        byte[] bytes = value2.getBytes("UTF-8");
        this.writeRawVarint32(bytes.length);
        this.writeRawBytes(bytes);
    }

    public void writeGroupNoTag(MessageLite value2) throws IOException {
        value2.writeTo(this);
    }

    public void writeMessageNoTag(MessageLite value2) throws IOException {
        this.writeRawVarint32(value2.getSerializedSize());
        value2.writeTo(this);
    }

    public void writeBytesNoTag(ByteString value2) throws IOException {
        this.writeRawVarint32(value2.size());
        this.writeRawBytes(value2);
    }

    public void writeByteArrayNoTag(byte[] value2) throws IOException {
        this.writeRawVarint32(value2.length);
        this.writeRawBytes(value2);
    }

    public void writeUInt32NoTag(int value2) throws IOException {
        this.writeRawVarint32(value2);
    }

    public void writeEnumNoTag(int value2) throws IOException {
        this.writeInt32NoTag(value2);
    }

    public void writeSFixed32NoTag(int value2) throws IOException {
        this.writeRawLittleEndian32(value2);
    }

    public void writeSFixed64NoTag(long value2) throws IOException {
        this.writeRawLittleEndian64(value2);
    }

    public void writeSInt32NoTag(int value2) throws IOException {
        this.writeRawVarint32(CodedOutputStream.encodeZigZag32(value2));
    }

    public void writeSInt64NoTag(long value2) throws IOException {
        this.writeRawVarint64(CodedOutputStream.encodeZigZag64(value2));
    }

    public static int computeDoubleSize(int fieldNumber, double value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeDoubleSizeNoTag(value2);
    }

    public static int computeFloatSize(int fieldNumber, float value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeFloatSizeNoTag(value2);
    }

    public static int computeInt32Size(int fieldNumber, int value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeInt32SizeNoTag(value2);
    }

    public static int computeBoolSize(int fieldNumber, boolean value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeBoolSizeNoTag(value2);
    }

    public static int computeMessageSize(int fieldNumber, MessageLite value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeMessageSizeNoTag(value2);
    }

    public static int computeBytesSize(int fieldNumber, ByteString value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeBytesSizeNoTag(value2);
    }

    public static int computeEnumSize(int fieldNumber, int value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeEnumSizeNoTag(value2);
    }

    public static int computeSInt64Size(int fieldNumber, long value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeSInt64SizeNoTag(value2);
    }

    public static int computeDoubleSizeNoTag(double value2) {
        return 8;
    }

    public static int computeFloatSizeNoTag(float value2) {
        return 4;
    }

    public static int computeUInt64SizeNoTag(long value2) {
        return CodedOutputStream.computeRawVarint64Size(value2);
    }

    public static int computeInt64SizeNoTag(long value2) {
        return CodedOutputStream.computeRawVarint64Size(value2);
    }

    public static int computeInt32SizeNoTag(int value2) {
        if (value2 >= 0) {
            return CodedOutputStream.computeRawVarint32Size(value2);
        }
        return 10;
    }

    public static int computeFixed64SizeNoTag(long value2) {
        return 8;
    }

    public static int computeFixed32SizeNoTag(int value2) {
        return 4;
    }

    public static int computeBoolSizeNoTag(boolean value2) {
        return 1;
    }

    public static int computeStringSizeNoTag(String value2) {
        try {
            byte[] bytes = value2.getBytes("UTF-8");
            return CodedOutputStream.computeRawVarint32Size(bytes.length) + bytes.length;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 not supported.", e);
        }
    }

    public static int computeGroupSizeNoTag(MessageLite value2) {
        return value2.getSerializedSize();
    }

    public static int computeMessageSizeNoTag(MessageLite value2) {
        int size = value2.getSerializedSize();
        return CodedOutputStream.computeRawVarint32Size(size) + size;
    }

    public static int computeLazyFieldSizeNoTag(LazyFieldLite value2) {
        int size = value2.getSerializedSize();
        return CodedOutputStream.computeRawVarint32Size(size) + size;
    }

    public static int computeBytesSizeNoTag(ByteString value2) {
        return CodedOutputStream.computeRawVarint32Size(value2.size()) + value2.size();
    }

    public static int computeByteArraySizeNoTag(byte[] value2) {
        return CodedOutputStream.computeRawVarint32Size(value2.length) + value2.length;
    }

    public static int computeUInt32SizeNoTag(int value2) {
        return CodedOutputStream.computeRawVarint32Size(value2);
    }

    public static int computeEnumSizeNoTag(int value2) {
        return CodedOutputStream.computeInt32SizeNoTag(value2);
    }

    public static int computeSFixed32SizeNoTag(int value2) {
        return 4;
    }

    public static int computeSFixed64SizeNoTag(long value2) {
        return 8;
    }

    public static int computeSInt32SizeNoTag(int value2) {
        return CodedOutputStream.computeRawVarint32Size(CodedOutputStream.encodeZigZag32(value2));
    }

    public static int computeSInt64SizeNoTag(long value2) {
        return CodedOutputStream.computeRawVarint64Size(CodedOutputStream.encodeZigZag64(value2));
    }

    private void refreshBuffer() throws IOException {
        if (this.output == null) {
            throw new OutOfSpaceException();
        }
        this.output.write(this.buffer, 0, this.position);
        this.position = 0;
    }

    public void flush() throws IOException {
        if (this.output != null) {
            this.refreshBuffer();
        }
    }

    public void writeRawByte(byte value2) throws IOException {
        if (this.position == this.limit) {
            this.refreshBuffer();
        }
        this.buffer[this.position++] = value2;
        ++this.totalBytesWritten;
    }

    public void writeRawByte(int value2) throws IOException {
        this.writeRawByte((byte)value2);
    }

    public void writeRawBytes(ByteString value2) throws IOException {
        this.writeRawBytes(value2, 0, value2.size());
    }

    public void writeRawBytes(byte[] value2) throws IOException {
        this.writeRawBytes(value2, 0, value2.length);
    }

    public void writeRawBytes(byte[] value2, int offset2, int length) throws IOException {
        if (this.limit - this.position >= length) {
            System.arraycopy(value2, offset2, this.buffer, this.position, length);
            this.position += length;
            this.totalBytesWritten += length;
        } else {
            int bytesWritten = this.limit - this.position;
            System.arraycopy(value2, offset2, this.buffer, this.position, bytesWritten);
            offset2 += bytesWritten;
            this.position = this.limit;
            this.totalBytesWritten += bytesWritten;
            this.refreshBuffer();
            if ((length -= bytesWritten) <= this.limit) {
                System.arraycopy(value2, offset2, this.buffer, 0, length);
                this.position = length;
            } else {
                this.output.write(value2, offset2, length);
            }
            this.totalBytesWritten += length;
        }
    }

    public void writeRawBytes(ByteString value2, int offset2, int length) throws IOException {
        if (this.limit - this.position >= length) {
            value2.copyTo(this.buffer, offset2, this.position, length);
            this.position += length;
            this.totalBytesWritten += length;
        } else {
            int bytesWritten = this.limit - this.position;
            value2.copyTo(this.buffer, offset2, this.position, bytesWritten);
            offset2 += bytesWritten;
            this.position = this.limit;
            this.totalBytesWritten += bytesWritten;
            this.refreshBuffer();
            if ((length -= bytesWritten) <= this.limit) {
                value2.copyTo(this.buffer, offset2, 0, length);
                this.position = length;
            } else {
                value2.writeTo(this.output, offset2, length);
            }
            this.totalBytesWritten += length;
        }
    }

    public void writeTag(int fieldNumber, int wireType) throws IOException {
        this.writeRawVarint32(WireFormat.makeTag(fieldNumber, wireType));
    }

    public static int computeTagSize(int fieldNumber) {
        return CodedOutputStream.computeRawVarint32Size(WireFormat.makeTag(fieldNumber, 0));
    }

    public void writeRawVarint32(int value2) throws IOException {
        while (true) {
            if ((value2 & 0xFFFFFF80) == 0) {
                this.writeRawByte(value2);
                return;
            }
            this.writeRawByte(value2 & 0x7F | 0x80);
            value2 >>>= 7;
        }
    }

    public static int computeRawVarint32Size(int value2) {
        if ((value2 & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value2 & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value2 & 0xFFE00000) == 0) {
            return 3;
        }
        if ((value2 & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public void writeRawVarint64(long value2) throws IOException {
        while (true) {
            if ((value2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.writeRawByte((int)value2);
                return;
            }
            this.writeRawByte((int)value2 & 0x7F | 0x80);
            value2 >>>= 7;
        }
    }

    public static int computeRawVarint64Size(long value2) {
        if ((value2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((value2 & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((value2 & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((value2 & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((value2 & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((value2 & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((value2 & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((value2 & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((value2 & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    public void writeRawLittleEndian32(int value2) throws IOException {
        this.writeRawByte(value2 & 0xFF);
        this.writeRawByte(value2 >> 8 & 0xFF);
        this.writeRawByte(value2 >> 16 & 0xFF);
        this.writeRawByte(value2 >> 24 & 0xFF);
    }

    public void writeRawLittleEndian64(long value2) throws IOException {
        this.writeRawByte((int)value2 & 0xFF);
        this.writeRawByte((int)(value2 >> 8) & 0xFF);
        this.writeRawByte((int)(value2 >> 16) & 0xFF);
        this.writeRawByte((int)(value2 >> 24) & 0xFF);
        this.writeRawByte((int)(value2 >> 32) & 0xFF);
        this.writeRawByte((int)(value2 >> 40) & 0xFF);
        this.writeRawByte((int)(value2 >> 48) & 0xFF);
        this.writeRawByte((int)(value2 >> 56) & 0xFF);
    }

    public static int encodeZigZag32(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long encodeZigZag64(long n) {
        return n << 1 ^ n >> 63;
    }

    public static class OutOfSpaceException
    extends IOException {
        OutOfSpaceException() {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.");
        }
    }
}

