/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineReferenceLocator;
import org.jetbrains.kotlin.backend.jvm.lower.FakeInliningLocalVariables;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;

@PhaseDescription(name="FakeLocalVariablesForBytecodeInlinerLowering", description="Add fake locals to identify the range of inlined functions and lambdas")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0001\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J(\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0012H\u0016J\u0014\u0010\u001a\u001a\u00020\f*\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/FakeLocalVariablesForBytecodeInlinerLowering;", "Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineReferenceLocator;", "Lorg/jetbrains/kotlin/backend/jvm/lower/FakeInliningLocalVariables;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitFunction", "declaration", "data", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "visitInlineLambda", "argument", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "callee", "parameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "scope", "addFakeLocalVariable", "name", "", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nFakeLocalVariablesForBytecodeInlinerLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FakeLocalVariablesForBytecodeInlinerLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/FakeLocalVariablesForBytecodeInlinerLowering\n+ 2 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 3 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n416#2,10:86\n72#3:96\n73#3:99\n1863#4,2:97\n*S KotlinDebug\n*F\n+ 1 FakeLocalVariablesForBytecodeInlinerLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/FakeLocalVariablesForBytecodeInlinerLowering\n*L\n72#1:86,10\n72#1:96\n72#1:99\n79#1:97,2\n*E\n"})
public final class FakeLocalVariablesForBytecodeInlinerLowering
extends IrInlineReferenceLocator
implements FileLoweringPass,
FakeInliningLocalVariables<IrFunction> {
    @NotNull
    private final JvmBackendContext context;

    public FakeLocalVariablesForBytecodeInlinerLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        super(context);
        this.context = context;
    }

    @Override
    @NotNull
    public JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        irFile.accept(this, null);
    }

    @Override
    public void visitFunction(@NotNull IrFunction declaration, @Nullable IrDeclaration data) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        super.visitFunction(declaration, data);
        this.addFakeLocalVariableForFun((IrElement)declaration, declaration);
    }

    @Override
    public void visitInlineLambda(@NotNull IrFunctionReference argument, @NotNull IrFunction callee, @NotNull IrValueParameter parameter, @NotNull IrDeclaration scope2) {
        Intrinsics.checkNotNullParameter(argument, "argument");
        Intrinsics.checkNotNullParameter(callee, "callee");
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        IrFunction lambda2 = ((IrFunctionSymbol)argument.getSymbol()).getOwner();
        this.addFakeLocalVariableForLambda((IrElement)lambda2, argument, callee);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addFakeLocalVariable(@NotNull IrFunction $this$addFakeLocalVariable, @NotNull String name2) {
        void $this$addFakeLocalVariable_u24lambda_u241;
        void this_$iv$iv;
        Intrinsics.checkNotNullParameter($this$addFakeLocalVariable, "<this>");
        Intrinsics.checkNotNullParameter(name2, "name");
        IrBuilderWithScope $this$irBlockBody_u24default$iv = LowerUtilsKt.createIrBuilder$default(this.getContext(), (IrSymbol)$this$addFakeLocalVariable.getSymbol(), 0, 0, 6, null);
        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        void var9_9 = this_$iv$iv;
        IrFunction irFunction = $this$addFakeLocalVariable;
        boolean bl = false;
        IrBuilderKt.createTmpVariable$default((IrStatementsBuilder)$this$addFakeLocalVariable_u24lambda_u241, (IrExpression)ExpressionHelpersKt.irInt$default((IrBuilderWithScope)$this$addFakeLocalVariable_u24lambda_u241, 0, null, 2, null), StringsKt.removeSuffix(name2, (CharSequence)"$$forInline"), false, (IrDeclarationOrigin)IrDeclarationOrigin.Companion.getDEFINED(), null, 20, null);
        IrBody oldBody = $this$addFakeLocalVariable.getBody();
        if (oldBody instanceof IrExpressionBody) {
            $this$addFakeLocalVariable_u24lambda_u241.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$addFakeLocalVariable_u24lambda_u241, ((IrExpressionBody)oldBody).getExpression()));
        } else if (oldBody instanceof IrBlockBody) {
            Iterable $this$forEach$iv = ((IrBlockBody)oldBody).getStatements();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrStatement it = (IrStatement)element$iv;
                boolean bl2 = false;
                $this$addFakeLocalVariable_u24lambda_u241.unaryPlus(it);
            }
        } else {
            throw new AssertionError((Object)("Unexpected body:\n" + DumpIrTreeKt.dump$default($this$addFakeLocalVariable, null, 1, null)));
        }
        irFunction.setBody(this_$iv$iv.doBuild());
    }
}

