/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.repl;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.repl.ReplCodeLine;
import org.jetbrains.kotlin.com.google.common.base.Throwables;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.LineSeparator;
import org.jetbrains.kotlin.utils.repl.ReplEscapeType;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u001a\u000f\u0010\u0006\u001a\u00070\u0002\u00a2\u0006\u0002\b\u0007*\u00020\u0002\u001a\u000f\u0010\b\u001a\u00070\u0002\u00a2\u0006\u0002\b\u0007*\u00020\u0002\u001a\u0012\u0010\t\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b\u001a\n\u0010\f\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\r\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u000e\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u000f\u001a\u00020\u0002*\u00020\u0002\u001a\u000e\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u000e\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u0016\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002\u001a\u0012\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0001*\u00020\u001cH\u0000\u001a\u0012\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0001*\u00020\u001eH\u0000\u001a*\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H 0\u0001\"\b\b\u0000\u0010 *\u00020!*\b\u0012\u0004\u0012\u0002H 0\u00012\u0006\u0010\"\u001a\u00020\u0002H\u0000\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"SOURCE_CHARS", "", "", "XML_REPLACEMENTS", "END_LINE", "XML_PREAMBLE", "replUnescapeLineBreaks", "Lorg/jetbrains/annotations/NotNull;", "replEscapeLineBreaks", "replOutputAsXml", "escapeType", "Lorg/jetbrains/kotlin/utils/repl/ReplEscapeType;", "replInputAsXml", "replAddLineBreak", "replRemoveLineBreaksInTheEnd", "replNormalizeLineBreaks", "makeScriptBaseName", "codeLine", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;", "scriptResultFieldName", "lineNo", "", "renderReplStackTrace", "cause", "", "startFromMethodName", "listAllUrlsAsFiles", "Ljava/io/File;", "Ljava/lang/ClassLoader;", "listLocalUrlsAsFiles", "Ljava/net/URLClassLoader;", "ensureNotEmpty", "T", "", "error", "cli-common"})
@SourceDebugExtension(value={"SMAP\nreplUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 replUtil.kt\norg/jetbrains/kotlin/cli/common/repl/ReplUtilKt\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n37#2,2:91\n1288#3,3:93\n11483#4,9:96\n13409#4:105\n13410#4:107\n11492#4:108\n1#5:106\n1557#6:109\n1628#6,3:110\n*S KotlinDebug\n*F\n+ 1 replUtil.kt\norg/jetbrains/kotlin/cli/common/repl/ReplUtilKt\n*L\n70#1:91,2\n77#1:93,3\n83#1:96,9\n83#1:105\n83#1:107\n83#1:108\n83#1:106\n83#1:109\n83#1:110,3\n*E\n"})
public final class ReplUtilKt {
    @NotNull
    private static final List<String> SOURCE_CHARS;
    @NotNull
    private static final List<String> XML_REPLACEMENTS;
    @NotNull
    private static final String END_LINE;

    @NotNull
    public static final String replUnescapeLineBreaks(@NotNull String $this$replUnescapeLineBreaks) {
        Intrinsics.checkNotNullParameter($this$replUnescapeLineBreaks, "<this>");
        String string2 = StringUtil.replace($this$replUnescapeLineBreaks, XML_REPLACEMENTS, SOURCE_CHARS);
        Intrinsics.checkNotNullExpressionValue(string2, "replace(...)");
        return string2;
    }

    @NotNull
    public static final String replEscapeLineBreaks(@NotNull String $this$replEscapeLineBreaks) {
        Intrinsics.checkNotNullParameter($this$replEscapeLineBreaks, "<this>");
        String string2 = StringUtil.replace($this$replEscapeLineBreaks, SOURCE_CHARS, XML_REPLACEMENTS);
        Intrinsics.checkNotNullExpressionValue(string2, "replace(...)");
        return string2;
    }

    @NotNull
    public static final String replOutputAsXml(@NotNull String $this$replOutputAsXml, @NotNull ReplEscapeType escapeType) {
        Intrinsics.checkNotNullParameter($this$replOutputAsXml, "<this>");
        Intrinsics.checkNotNullParameter((Object)escapeType, "escapeType");
        String string2 = StringUtil.escapeXmlEntities(ReplUtilKt.replEscapeLineBreaks($this$replOutputAsXml));
        Intrinsics.checkNotNullExpressionValue(string2, "escapeXmlEntities(...)");
        String escapedXml = string2;
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><output type=\"" + (Object)((Object)escapeType) + "\">" + escapedXml + "</output>";
    }

    @NotNull
    public static final String replInputAsXml(@NotNull String $this$replInputAsXml) {
        Intrinsics.checkNotNullParameter($this$replInputAsXml, "<this>");
        String string2 = StringUtil.escapeXmlEntities(ReplUtilKt.replEscapeLineBreaks($this$replInputAsXml));
        Intrinsics.checkNotNullExpressionValue(string2, "escapeXmlEntities(...)");
        String escapedXml = string2;
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><input>" + escapedXml + "</input>";
    }

    @NotNull
    public static final String replAddLineBreak(@NotNull String $this$replAddLineBreak) {
        Intrinsics.checkNotNullParameter($this$replAddLineBreak, "<this>");
        return $this$replAddLineBreak + END_LINE;
    }

    @NotNull
    public static final String replRemoveLineBreaksInTheEnd(@NotNull String $this$replRemoveLineBreaksInTheEnd) {
        Intrinsics.checkNotNullParameter($this$replRemoveLineBreaksInTheEnd, "<this>");
        char[] cArray = END_LINE.toCharArray();
        Intrinsics.checkNotNullExpressionValue(cArray, "toCharArray(...)");
        char[] cArray2 = cArray;
        return StringsKt.trimEnd($this$replRemoveLineBreaksInTheEnd, Arrays.copyOf(cArray2, cArray2.length));
    }

    @NotNull
    public static final String replNormalizeLineBreaks(@NotNull String $this$replNormalizeLineBreaks) {
        Intrinsics.checkNotNullParameter($this$replNormalizeLineBreaks, "<this>");
        return StringsKt.replace$default($this$replNormalizeLineBreaks, END_LINE, "\n", false, 4, null);
    }

    @NotNull
    public static final String makeScriptBaseName(@NotNull ReplCodeLine codeLine) {
        Intrinsics.checkNotNullParameter(codeLine, "codeLine");
        return "Line_" + codeLine.getNo() + (codeLine.getGeneration() > 1 ? "_gen_" + codeLine.getGeneration() : "");
    }

    @NotNull
    public static final String scriptResultFieldName(int lineNo) {
        return "res" + lineNo;
    }

    @NotNull
    public static final String renderReplStackTrace(@NotNull Throwable cause, @NotNull String startFromMethodName) {
        Intrinsics.checkNotNullParameter(cause, "cause");
        Intrinsics.checkNotNullParameter(startFromMethodName, "startFromMethodName");
        ArrayList<StackTraceElement> newTrace = new ArrayList<StackTraceElement>();
        boolean skip = true;
        StackTraceElement[] stackTraceElementArray = cause.getStackTrace();
        Intrinsics.checkNotNullExpressionValue(stackTraceElementArray, "getStackTrace(...)");
        List<Object> list = ArraysKt.reversed((Object[])stackTraceElementArray);
        int n = list.size();
        for (int j = 0; j < n; ++j) {
            StackTraceElement element = (StackTraceElement)list.get(j);
            if (Intrinsics.areEqual(element.getClassName() + '.' + element.getMethodName(), startFromMethodName)) {
                skip = false;
            }
            if (skip) continue;
            newTrace.add(element);
        }
        List resultingTrace = CollectionsKt.dropLast(CollectionsKt.reversed((Iterable)newTrace), 1);
        Collection $this$toTypedArray$iv = resultingTrace;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        cause.setStackTrace(thisCollection$iv.toArray(new StackTraceElement[0]));
        String string2 = Throwables.getStackTraceAsString(cause);
        Intrinsics.checkNotNullExpressionValue(string2, "getStackTraceAsString(...)");
        return ((Object)StringsKt.trimEnd((CharSequence)string2)).toString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> listAllUrlsAsFiles(@NotNull ClassLoader $this$listAllUrlsAsFiles) {
        void $this$fold$iv;
        Sequence<URLClassLoader> parents2;
        Intrinsics.checkNotNullParameter($this$listAllUrlsAsFiles, "<this>");
        Sequence<URLClassLoader> sequence2 = parents2 = SequencesKt.filterIsInstance(SequencesKt.generateSequence($this$listAllUrlsAsFiles, ReplUtilKt::listAllUrlsAsFiles$lambda$0), URLClassLoader.class);
        List initial$iv = CollectionsKt.emptyList();
        boolean $i$f$fold = false;
        List accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void loader;
            URLClassLoader uRLClassLoader = (URLClassLoader)element$iv;
            List accum = accumulator$iv;
            boolean bl = false;
            accumulator$iv = CollectionsKt.plus((Collection)ReplUtilKt.listLocalUrlsAsFiles((URLClassLoader)loader), (Iterable)accum);
        }
        return CollectionsKt.distinct(accumulator$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> listLocalUrlsAsFiles(@NotNull URLClassLoader $this$listLocalUrlsAsFiles) {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$listLocalUrlsAsFiles, "<this>");
        URL[] uRLArray = $this$listLocalUrlsAsFiles.getURLs();
        Intrinsics.checkNotNullExpressionValue(uRLArray, "getURLs(...)");
        Object[] $this$mapNotNull$iv = uRLArray;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            String it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
            boolean bl = false;
            URL it = (URL)element$iv$iv;
            boolean bl2 = false;
            String string2 = it.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            if (StringsKt.removePrefix(string2, (CharSequence)"file:") == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string3 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new File((String)p0));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final <T> List<T> ensureNotEmpty(@NotNull List<? extends T> $this$ensureNotEmpty, @NotNull String error) {
        Intrinsics.checkNotNullParameter($this$ensureNotEmpty, "<this>");
        Intrinsics.checkNotNullParameter(error, "error");
        if ($this$ensureNotEmpty.isEmpty()) {
            throw new IllegalStateException(error);
        }
        return $this$ensureNotEmpty;
    }

    private static final ClassLoader listAllUrlsAsFiles$lambda$0(ClassLoader loader) {
        Intrinsics.checkNotNullParameter(loader, "loader");
        return loader.getParent();
    }

    static {
        String[] stringArray = new String[]{"\r", "\n", "#"};
        SOURCE_CHARS = CollectionsKt.listOf(stringArray);
        stringArray = new String[]{"#r", "#n", "#diez"};
        XML_REPLACEMENTS = CollectionsKt.listOf(stringArray);
        String string2 = LineSeparator.getSystemLineSeparator().getSeparatorString();
        Intrinsics.checkNotNullExpressionValue(string2, "getSeparatorString(...)");
        END_LINE = string2;
    }
}

