/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.GregorianCalendar;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import kotlin.io.FilesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.modules.ModuleChunk;
import org.jetbrains.kotlin.cli.common.modules.ModuleXmlParser;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentException;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtilRt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;
import org.jetbrains.kotlin.utils.PathUtil;

public class CompileEnvironmentUtil {
    public static long DOS_EPOCH = new GregorianCalendar(1980, 0, 1, 0, 0, 0).getTimeInMillis();

    @NotNull
    public static ModuleChunk loadModuleChunk(File buildFile, MessageCollector messageCollector) {
        if (!buildFile.exists()) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "Module definition file does not exist: " + buildFile, null);
            ModuleChunk moduleChunk = ModuleChunk.EMPTY;
            if (moduleChunk == null) {
                CompileEnvironmentUtil.$$$reportNull$$$0(0);
            }
            return moduleChunk;
        }
        if ("xml".equalsIgnoreCase(FilesKt.getExtension(buildFile))) {
            ModuleChunk moduleChunk = ModuleXmlParser.parseModuleScript(buildFile.getPath(), messageCollector);
            if (moduleChunk == null) {
                CompileEnvironmentUtil.$$$reportNull$$$0(1);
            }
            return moduleChunk;
        }
        messageCollector.report(CompilerMessageSeverity.ERROR, "Unknown module definition type: " + buildFile, null);
        ModuleChunk moduleChunk = ModuleChunk.EMPTY;
        if (moduleChunk == null) {
            CompileEnvironmentUtil.$$$reportNull$$$0(2);
        }
        return moduleChunk;
    }

    private static void doWriteToJar(OutputFileCollection outputFiles, OutputStream fos, @Nullable FqName mainClass, boolean includeRuntime, boolean noReflect, boolean resetJarTimestamps) {
        try {
            Manifest manifest = new Manifest();
            Attributes mainAttributes = manifest.getMainAttributes();
            mainAttributes.putValue("Manifest-Version", "1.0");
            mainAttributes.putValue("Created-By", "JetBrains Kotlin");
            if (mainClass != null) {
                mainAttributes.putValue("Main-Class", mainClass.asString());
            }
            JarOutputStream stream = new JarOutputStream(fos);
            JarEntry manifestEntry = new JarEntry("META-INF/MANIFEST.MF");
            if (resetJarTimestamps) {
                manifestEntry.setTime(DOS_EPOCH);
            }
            stream.putNextEntry(manifestEntry);
            manifest.write(new BufferedOutputStream(stream));
            for (OutputFile outputFile : outputFiles.asList()) {
                JarEntry entry = new JarEntry(outputFile.getRelativePath());
                if (resetJarTimestamps) {
                    entry.setTime(DOS_EPOCH);
                }
                stream.putNextEntry(entry);
                stream.write(outputFile.asByteArray());
            }
            if (includeRuntime) {
                CompileEnvironmentUtil.writeRuntimeToJar(stream, resetJarTimestamps);
                if (!noReflect) {
                    CompileEnvironmentUtil.writeReflectToJar(stream, resetJarTimestamps);
                }
            }
            stream.finish();
        }
        catch (IOException e) {
            throw new CompileEnvironmentException("Failed to generate jar file", e);
        }
    }

    /*
     * Loose catch block
     */
    public static void writeToJar(File jarPath, boolean jarRuntime, boolean noReflect, boolean resetJarTimestamps, FqName mainClass, OutputFileCollection outputFiles, MessageCollector messageCollector) {
        FileOutputStream outputStream = null;
        try {
            if (jarPath.getParentFile() != null) {
                jarPath.getParentFile().mkdirs();
            }
            outputStream = new FileOutputStream(jarPath);
            CompileEnvironmentUtil.doWriteToJar(outputFiles, outputStream, mainClass, jarRuntime, noReflect, resetJarTimestamps);
            outputStream.close();
        }
        catch (FileNotFoundException e) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "Invalid jar path: " + jarPath, null);
            ExceptionUtilsKt.closeQuietly(outputStream);
        }
        catch (IOException e2) {
            throw ExceptionUtilsKt.rethrow(e2);
            {
                catch (Throwable throwable) {
                    ExceptionUtilsKt.closeQuietly(outputStream);
                    throw throwable;
                }
            }
        }
        ExceptionUtilsKt.closeQuietly(outputStream);
    }

    private static void writeRuntimeToJar(JarOutputStream stream, boolean resetJarTimestamps) throws IOException {
        File stdlibPath = PathUtil.getKotlinPathsForCompiler().getStdlibPath();
        if (!stdlibPath.exists()) {
            throw new CompileEnvironmentException("Couldn't find kotlin-stdlib at " + stdlibPath);
        }
        CompileEnvironmentUtil.copyJarImpl(stream, stdlibPath, resetJarTimestamps);
    }

    private static void writeReflectToJar(JarOutputStream stream, boolean resetJarTimestamps) throws IOException {
        File reflectPath = PathUtil.getKotlinPathsForCompiler().getReflectPath();
        if (!reflectPath.exists()) {
            throw new CompileEnvironmentException("Couldn't find kotlin-reflect at " + reflectPath);
        }
        CompileEnvironmentUtil.copyJarImpl(stream, reflectPath, resetJarTimestamps);
    }

    private static void copyJarImpl(JarOutputStream stream, File jarPath, boolean resetJarTimestamps) throws IOException {
        try (JarInputStream jis = new JarInputStream(new FileInputStream(jarPath));){
            JarEntry e;
            while ((e = jis.getNextJarEntry()) != null) {
                String name2 = e.getName();
                if (!FileUtilRt.extensionEquals(name2, "class") && !FileUtilRt.extensionEquals(name2, "kotlin_builtins") && !name2.startsWith("META-INF/services/") || StringsKt.substringAfterLast(name2, "/", name2).equals("module-info.class")) continue;
                if (resetJarTimestamps) {
                    e.setTime(DOS_EPOCH);
                }
                stream.putNextEntry(e);
                FileUtil.copy(jis, stream);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/CompileEnvironmentUtil", "loadModuleChunk"));
    }
}

