/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.config.ContentRootsKt;
import org.jetbrains.kotlin.cli.common.config.KotlinSourceRoot;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.CompilerConfigurationKey;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.extensions.CompilerConfigurationExtension;
import org.jetbrains.kotlin.extensions.PreprocessedFileCreator;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.modules.Module;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.multiplatform.IsCommonSourceKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000l\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a&\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u001a]\u0010\t\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\b2/\u0010\u0010\u001a+\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0015\u0012\u0013\u0018\u00010\u0006\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00010\u0011\u001a6\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\b\u001a\u001c\u0010 \u001a\u00020\u0002*\u00020\u00022\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$\u001a\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u00022\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c\"\u0015\u0010\u001b\u001a\u00020\u001c*\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006&"}, d2={"report", "", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "message", "", "location", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageLocation;", "forAllFiles", "", "Lorg/jetbrains/kotlin/cli/common/config/KotlinSourceRoot;", "configuration", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "reportLocation", "body", "Lkotlin/Function3;", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "", "Lkotlin/ParameterName;", "name", "moduleName", "createSourceFilesFromSourceRoots", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "sourceRoots", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "getMessageCollector", "(Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;)Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "applyModuleProperties", "module", "Lorg/jetbrains/kotlin/modules/Module;", "buildFile", "Ljava/io/File;", "getSourceRootsCheckingForDuplicates", "cli-base"})
@SourceDebugExtension(value={"SMAP\ncoreEnvironmentUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 coreEnvironmentUtils.kt\norg/jetbrains/kotlin/cli/jvm/compiler/CoreEnvironmentUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n1#2:151\n*E\n"})
public final class CoreEnvironmentUtilsKt {
    public static final void report(@NotNull CompilerConfiguration $this$report, @NotNull CompilerMessageSeverity severity, @NotNull String message, @Nullable CompilerMessageLocation location) {
        Intrinsics.checkNotNullParameter($this$report, "<this>");
        Intrinsics.checkNotNullParameter((Object)severity, "severity");
        Intrinsics.checkNotNullParameter(message, "message");
        CommonConfigurationKeysKt.getMessageCollector($this$report).report(severity, message, location);
    }

    public static /* synthetic */ void report$default(CompilerConfiguration compilerConfiguration, CompilerMessageSeverity compilerMessageSeverity, String string2, CompilerMessageLocation compilerMessageLocation, int n, Object object) {
        if ((n & 4) != 0) {
            compilerMessageLocation = null;
        }
        CoreEnvironmentUtilsKt.report(compilerConfiguration, compilerMessageSeverity, string2, compilerMessageLocation);
    }

    public static final void forAllFiles(@NotNull List<KotlinSourceRoot> $this$forAllFiles, @NotNull CompilerConfiguration configuration2, @NotNull Project project, @Nullable CompilerMessageLocation reportLocation, @NotNull Function3<? super VirtualFile, ? super Boolean, ? super String, Unit> body2) {
        Intrinsics.checkNotNullParameter($this$forAllFiles, "<this>");
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        Intrinsics.checkNotNullParameter(project, "project");
        Intrinsics.checkNotNullParameter(body2, "body");
        VirtualFileSystem localFileSystem = VirtualFileManager.getInstance().getFileSystem("file");
        HashSet<VirtualFile> processedFiles = new HashSet<VirtualFile>();
        PreprocessedFileCreator virtualFileCreator = new PreprocessedFileCreator(project);
        Ref.BooleanRef pluginsConfigured = new Ref.BooleanRef();
        for (KotlinSourceRoot kotlinSourceRoot : $this$forAllFiles) {
            String sourceRootPath = kotlinSourceRoot.component1();
            boolean isCommon = kotlinSourceRoot.component2();
            String hmppModuleName = kotlinSourceRoot.component3();
            File sourceRoot = new File(sourceRootPath);
            VirtualFile vFile = localFileSystem.findFileByPath(FilesKt.normalize(sourceRoot).getPath());
            if (vFile == null) {
                String message = "Source file or directory not found: " + sourceRootPath;
                File buildFilePath = configuration2.get(JVMConfigurationKeys.MODULE_XML_FILE);
                if (buildFilePath != null && Logger.isInitialized()) {
                    Logger.getInstance(KotlinCoreEnvironment.class).warn(message + "\n\nbuild file path: " + buildFilePath + "\ncontent:\n" + FilesKt.readText$default(buildFilePath, null, 1, null));
                }
                CoreEnvironmentUtilsKt.report(configuration2, CompilerMessageSeverity.ERROR, message, reportLocation);
                continue;
            }
            if (!vFile.isDirectory() && !Intrinsics.areEqual(vFile.getExtension(), "kt")) {
                CoreEnvironmentUtilsKt.forAllFiles$ensurePluginsConfigured(pluginsConfigured, project);
                if (!Intrinsics.areEqual(vFile.getFileType(), KotlinFileType.INSTANCE)) {
                    CoreEnvironmentUtilsKt.report(configuration2, CompilerMessageSeverity.ERROR, "Source entry is not a Kotlin file: " + sourceRootPath, reportLocation);
                    continue;
                }
            }
            Iterator<File> iterator2 = FilesKt.walkTopDown(sourceRoot).iterator();
            while (iterator2.hasNext()) {
                VirtualFile virtualFile;
                VirtualFile virtualFile2;
                File file2 = iterator2.next();
                if (!file2.isFile()) continue;
                File file3 = file2.getAbsoluteFile();
                Intrinsics.checkNotNullExpressionValue(file3, "getAbsoluteFile(...)");
                if (localFileSystem.findFileByPath(FilesKt.normalize(file3).getPath()) != null) {
                    VirtualFile p0;
                    boolean bl = false;
                    virtualFile2 = virtualFileCreator.create(p0);
                } else {
                    virtualFile2 = null;
                }
                if ((virtualFile = virtualFile2) == null || !processedFiles.add(virtualFile)) continue;
                if (!Intrinsics.areEqual(virtualFile.getExtension(), "kt")) {
                    CoreEnvironmentUtilsKt.forAllFiles$ensurePluginsConfigured(pluginsConfigured, project);
                }
                if (!Intrinsics.areEqual(virtualFile.getExtension(), "kt") && !Intrinsics.areEqual(virtualFile.getFileType(), KotlinFileType.INSTANCE)) continue;
                body2.invoke(virtualFile, (Boolean)isCommon, hmppModuleName);
            }
        }
    }

    public static /* synthetic */ void forAllFiles$default(List list, CompilerConfiguration compilerConfiguration, Project project, CompilerMessageLocation compilerMessageLocation, Function3 function3, int n, Object object) {
        if ((n & 4) != 0) {
            compilerMessageLocation = null;
        }
        CoreEnvironmentUtilsKt.forAllFiles(list, compilerConfiguration, project, compilerMessageLocation, function3);
    }

    @NotNull
    public static final List<KtFile> createSourceFilesFromSourceRoots(@NotNull CompilerConfiguration configuration2, @NotNull Project project, @NotNull List<KotlinSourceRoot> sourceRoots, @Nullable CompilerMessageLocation reportLocation) {
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        Intrinsics.checkNotNullParameter(project, "project");
        Intrinsics.checkNotNullParameter(sourceRoots, "sourceRoots");
        PsiManager psiManager = PsiManager.getInstance(project);
        Intrinsics.checkNotNullExpressionValue(psiManager, "getInstance(...)");
        PsiManager psiManager2 = psiManager;
        List result2 = new ArrayList();
        CoreEnvironmentUtilsKt.forAllFiles(sourceRoots, configuration2, project, reportLocation, (arg_0, arg_1, arg_2) -> CoreEnvironmentUtilsKt.createSourceFilesFromSourceRoots$lambda$1(psiManager2, result2, arg_0, arg_1, arg_2));
        return result2;
    }

    public static /* synthetic */ List createSourceFilesFromSourceRoots$default(CompilerConfiguration compilerConfiguration, Project project, List list, CompilerMessageLocation compilerMessageLocation, int n, Object object) {
        if ((n & 8) != 0) {
            compilerMessageLocation = null;
        }
        return CoreEnvironmentUtilsKt.createSourceFilesFromSourceRoots(compilerConfiguration, project, list, compilerMessageLocation);
    }

    @NotNull
    public static final MessageCollector getMessageCollector(@NotNull KotlinCoreEnvironment $this$messageCollector) {
        Intrinsics.checkNotNullParameter($this$messageCollector, "<this>");
        MessageCollector messageCollector = $this$messageCollector.getConfiguration().getNotNull(CommonConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkNotNullExpressionValue(messageCollector, "getNotNull(...)");
        return messageCollector;
    }

    @NotNull
    public static final CompilerConfiguration applyModuleProperties(@NotNull CompilerConfiguration $this$applyModuleProperties, @NotNull Module module2, @Nullable File buildFile) {
        CompilerConfiguration compilerConfiguration;
        Intrinsics.checkNotNullParameter($this$applyModuleProperties, "<this>");
        Intrinsics.checkNotNullParameter(module2, "module");
        CompilerConfiguration $this$applyModuleProperties_u24lambda_u243 = compilerConfiguration = $this$applyModuleProperties.copy();
        boolean bl = false;
        if (buildFile != null) {
            CompilerConfigurationKey<File> compilerConfigurationKey = JVMConfigurationKeys.OUTPUT_DIRECTORY;
            Intrinsics.checkNotNullExpressionValue(compilerConfigurationKey, "OUTPUT_DIRECTORY");
            CoreEnvironmentUtilsKt.applyModuleProperties$lambda$3$checkKeyIsNull($this$applyModuleProperties_u24lambda_u243, compilerConfigurationKey, "OUTPUT_DIRECTORY");
            CompilerConfigurationKey<File> compilerConfigurationKey2 = JVMConfigurationKeys.OUTPUT_JAR;
            Intrinsics.checkNotNullExpressionValue(compilerConfigurationKey2, "OUTPUT_JAR");
            CoreEnvironmentUtilsKt.applyModuleProperties$lambda$3$checkKeyIsNull($this$applyModuleProperties_u24lambda_u243, compilerConfigurationKey2, "OUTPUT_JAR");
            $this$applyModuleProperties_u24lambda_u243.put(JVMConfigurationKeys.OUTPUT_DIRECTORY, new File(module2.getOutputDirectory()));
        }
        CompilerConfiguration compilerConfiguration2 = compilerConfiguration;
        Intrinsics.checkNotNullExpressionValue(compilerConfiguration2, "apply(...)");
        return compilerConfiguration2;
    }

    @NotNull
    public static final List<KotlinSourceRoot> getSourceRootsCheckingForDuplicates(@NotNull CompilerConfiguration configuration2, @Nullable MessageCollector messageCollector) {
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        HashSet<String> uniqueSourceRoots = new HashSet<String>();
        List result2 = new ArrayList();
        for (KotlinSourceRoot root : ContentRootsKt.getKotlinSourceRoots(configuration2)) {
            if (!uniqueSourceRoots.add(root.getPath())) {
                MessageCollector messageCollector2 = messageCollector;
                if (messageCollector2 != null) {
                    MessageCollector.report$default(messageCollector2, CompilerMessageSeverity.STRONG_WARNING, "Duplicate source root: " + root.getPath(), null, 4, null);
                }
            }
            result2.add(root);
        }
        return result2;
    }

    private static final void forAllFiles$ensurePluginsConfigured(Ref.BooleanRef pluginsConfigured, Project $project) {
        if (!pluginsConfigured.element) {
            for (CompilerConfigurationExtension extension : CompilerConfigurationExtension.Companion.getInstances($project)) {
                extension.updateFileRegistry();
            }
            pluginsConfigured.element = true;
        }
    }

    private static final Unit createSourceFilesFromSourceRoots$lambda$1(PsiManager $psiManager, List $result, VirtualFile virtualFile, boolean isCommon, String moduleName) {
        block2: {
            Intrinsics.checkNotNullParameter(virtualFile, "virtualFile");
            PsiFile psiFile = $psiManager.findFile(virtualFile);
            if (psiFile == null) break block2;
            PsiFile it = psiFile;
            boolean bl = false;
            if (it instanceof KtFile) {
                IsCommonSourceKt.setCommonSource((KtFile)it, isCommon);
                if (moduleName != null) {
                    IsCommonSourceKt.setHmppModuleName((KtFile)it, moduleName);
                }
                $result.add(it);
            }
        }
        return Unit.INSTANCE;
    }

    private static final void applyModuleProperties$lambda$3$checkKeyIsNull(CompilerConfiguration $this_apply, CompilerConfigurationKey<?> key, String name2) {
        boolean bl;
        boolean bl2 = bl = $this_apply.get(key) == null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = name2 + " should be null, when buildFile is used";
            throw new AssertionError((Object)string2);
        }
    }
}

