/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.base;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.kotlin.com.google.common.base.Platform;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.errorprone.annotations.InlineMe;
import org.jetbrains.kotlin.com.google.errorprone.annotations.InlineMeValidationDisabled;

public final class Strings {
    private Strings() {
    }

    public static String nullToEmpty(String string2) {
        return Platform.nullToEmpty(string2);
    }

    public static String emptyToNull(String string2) {
        return Platform.emptyToNull(string2);
    }

    public static boolean isNullOrEmpty(String string2) {
        return Platform.stringIsNullOrEmpty(string2);
    }

    public static String padStart(String string2, int minLength, char padChar) {
        Preconditions.checkNotNull(string2);
        if (string2.length() >= minLength) {
            return string2;
        }
        StringBuilder sb = new StringBuilder(minLength);
        for (int i2 = string2.length(); i2 < minLength; ++i2) {
            sb.append(padChar);
        }
        sb.append(string2);
        return sb.toString();
    }

    public static String padEnd(String string2, int minLength, char padChar) {
        Preconditions.checkNotNull(string2);
        if (string2.length() >= minLength) {
            return string2;
        }
        StringBuilder sb = new StringBuilder(minLength);
        sb.append(string2);
        for (int i2 = string2.length(); i2 < minLength; ++i2) {
            sb.append(padChar);
        }
        return sb.toString();
    }

    @InlineMe(replacement="string.repeat(count)")
    @InlineMeValidationDisabled(value="Java 11+ API only")
    public static String repeat(String string2, int count2) {
        int n;
        Preconditions.checkNotNull(string2);
        if (count2 <= 1) {
            Preconditions.checkArgument(count2 >= 0, "invalid count: %s", count2);
            return count2 == 0 ? "" : string2;
        }
        int len = string2.length();
        long longSize = (long)len * (long)count2;
        int size = (int)longSize;
        if ((long)size != longSize) {
            throw new ArrayIndexOutOfBoundsException("Required array size too large: " + longSize);
        }
        char[] array = new char[size];
        string2.getChars(0, len, array, 0);
        for (n = len; n < size - n; n <<= 1) {
            System.arraycopy(array, 0, array, n, n);
        }
        System.arraycopy(array, 0, array, n, size - n);
        return new String(array);
    }

    public static String commonPrefix(CharSequence a2, CharSequence b2) {
        int p2;
        Preconditions.checkNotNull(a2);
        Preconditions.checkNotNull(b2);
        int maxPrefixLength = Math.min(a2.length(), b2.length());
        for (p2 = 0; p2 < maxPrefixLength && a2.charAt(p2) == b2.charAt(p2); ++p2) {
        }
        if (Strings.validSurrogatePairAt(a2, p2 - 1) || Strings.validSurrogatePairAt(b2, p2 - 1)) {
            --p2;
        }
        return a2.subSequence(0, p2).toString();
    }

    public static String commonSuffix(CharSequence a2, CharSequence b2) {
        int s;
        Preconditions.checkNotNull(a2);
        Preconditions.checkNotNull(b2);
        int maxSuffixLength = Math.min(a2.length(), b2.length());
        for (s = 0; s < maxSuffixLength && a2.charAt(a2.length() - s - 1) == b2.charAt(b2.length() - s - 1); ++s) {
        }
        if (Strings.validSurrogatePairAt(a2, a2.length() - s - 1) || Strings.validSurrogatePairAt(b2, b2.length() - s - 1)) {
            --s;
        }
        return a2.subSequence(a2.length() - s, a2.length()).toString();
    }

    static boolean validSurrogatePairAt(CharSequence string2, int index) {
        return index >= 0 && index <= string2.length() - 2 && Character.isHighSurrogate(string2.charAt(index)) && Character.isLowSurrogate(string2.charAt(index + 1));
    }

    public static String lenientFormat(String template, Object ... args2) {
        int placeholderStart;
        template = String.valueOf(template);
        if (args2 == null) {
            args2 = new Object[]{"(Object[])null"};
        } else {
            for (int i2 = 0; i2 < args2.length; ++i2) {
                args2[i2] = Strings.lenientToString(args2[i2]);
            }
        }
        StringBuilder builder = new StringBuilder(template.length() + 16 * args2.length);
        int templateStart = 0;
        int i3 = 0;
        while (i3 < args2.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template, templateStart, placeholderStart);
            builder.append(args2[i3++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template, templateStart, template.length());
        if (i3 < args2.length) {
            builder.append(" [");
            builder.append(args2[i3++]);
            while (i3 < args2.length) {
                builder.append(", ");
                builder.append(args2[i3++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }

    private static String lenientToString(Object o) {
        if (o == null) {
            return "null";
        }
        try {
            return o.toString();
        }
        catch (Exception e) {
            String objectToString = o.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(o));
            Logger.getLogger("org.jetbrains.kotlin.com.google.common.base.Strings").log(Level.WARNING, "Exception during lenientFormat for " + objectToString, e);
            return "<" + objectToString + " threw " + e.getClass().getName() + ">";
        }
    }
}

