/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.patterns;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.patterns.ElementPattern;
import org.jetbrains.kotlin.com.intellij.util.PairProcessor;
import org.jetbrains.kotlin.com.intellij.util.ProcessingContext;

public abstract class PatternCondition<T> {
    private static final Logger LOG = Logger.getInstance(PatternCondition.class);
    private final String myDebugMethodName;

    public PatternCondition(@Nullable @NonNls String debugMethodName) {
        this.myDebugMethodName = debugMethodName;
    }

    private static void appendValue(StringBuilder builder, String indent, Object obj) {
        if (obj instanceof ElementPattern) {
            ((ElementPattern)obj).getCondition().append(builder, indent + "  ");
        } else if (obj instanceof Object[]) {
            PatternCondition.appendArray(builder, indent, (Object[])obj);
        } else if (obj instanceof Collection) {
            PatternCondition.appendArray(builder, indent, ((Collection)obj).toArray());
        } else if (obj instanceof String) {
            builder.append('\"').append(obj).append('\"');
        } else {
            builder.append(obj);
        }
    }

    protected static void appendArray(StringBuilder builder, String indent, Object[] objects) {
        builder.append("[");
        boolean first2 = true;
        for (Object o : objects) {
            if (!first2) {
                builder.append(", ");
            }
            first2 = false;
            PatternCondition.appendValue(builder, indent, o);
        }
        builder.append("]");
    }

    public abstract boolean accepts(@NotNull T var1, ProcessingContext var2);

    @NonNls
    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.append(builder, "");
        return builder.toString();
    }

    public void append(StringBuilder builder, String indent) {
        builder.append(this.myDebugMethodName);
        builder.append("(");
        this.appendParams(builder, indent);
        builder.append(")");
    }

    private void appendParams(final StringBuilder builder, final String indent) {
        this.processParameters((PairProcessor<String, Object>)new PairProcessor<String, Object>(){
            int count;
            String prevName;
            int prevOffset;

            @Override
            public boolean process(String name2, Object value2) {
                ++this.count;
                if (this.count == 2) {
                    builder.insert(this.prevOffset, this.prevName + "=");
                }
                if (this.count > 1) {
                    builder.append(", ");
                }
                this.prevOffset = builder.length();
                if (this.count > 1) {
                    builder.append(name2).append("=");
                }
                PatternCondition.appendValue(builder, indent, value2);
                this.prevName = name2;
                return true;
            }
        });
    }

    public boolean processParameters(PairProcessor<? super String, Object> processor) {
        for (Class<?> aClass = this.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            for (Field field : aClass.getDeclaredFields()) {
                Object value2;
                String name2;
                String fixedName;
                if (Modifier.isStatic(field.getModifiers()) || (field.isSynthetic() || aClass.equals(PatternCondition.class)) && !field.getName().startsWith("val$") || processor.process(fixedName = (name2 = field.getName()).startsWith("val$") ? name2.substring("val$".length()) : name2, value2 = this.getFieldValue(field))) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getFieldValue(Field field) {
        boolean accessible = field.isAccessible();
        try {
            field.setAccessible(true);
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException e) {
            LOG.error(e);
        }
        finally {
            field.setAccessible(accessible);
        }
        return null;
    }
}

