/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPointName;
import org.jetbrains.kotlin.com.intellij.openapi.module.Module;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VfsUtilCore;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;

public abstract class JavaCompilerConfigurationProxy {
    private static final ExtensionPointName<JavaCompilerConfigurationProxy> EP_NAME = new ExtensionPointName("org.jetbrains.kotlin.com.intellij.javaCompilerConfigurationProxy");

    protected abstract List<String> getAdditionalOptionsImpl(@NotNull Project var1, @NotNull Module var2);

    protected abstract void setAdditionalOptionsImpl(@NotNull Project var1, @NotNull Module var2, @NotNull List<String> var3);

    public static List<String> getAdditionalOptions(@NotNull Project project, @NotNull Module module2) {
        JavaCompilerConfigurationProxy[] extensions;
        if (project == null) {
            JavaCompilerConfigurationProxy.$$$reportNull$$$0(0);
        }
        if (module2 == null) {
            JavaCompilerConfigurationProxy.$$$reportNull$$$0(1);
        }
        if ((extensions = EP_NAME.getExtensions()).length == 0) {
            return Collections.emptyList();
        }
        return extensions[0].getAdditionalOptionsImpl(project, module2);
    }

    public static void setAdditionalOptions(@NotNull Project project, @NotNull Module module2, @NotNull List<String> options) {
        JavaCompilerConfigurationProxy[] extensions;
        if (project == null) {
            JavaCompilerConfigurationProxy.$$$reportNull$$$0(2);
        }
        if (module2 == null) {
            JavaCompilerConfigurationProxy.$$$reportNull$$$0(3);
        }
        if (options == null) {
            JavaCompilerConfigurationProxy.$$$reportNull$$$0(4);
        }
        if ((extensions = EP_NAME.getExtensions()).length == 0) {
            return;
        }
        extensions[0].setAdditionalOptionsImpl(project, module2, options);
    }

    public static boolean isPatchedModuleRoot(@NotNull String targetModuleName, @NotNull Module module2, @NotNull VirtualFile root) {
        List<String> options;
        if (targetModuleName == null) {
            JavaCompilerConfigurationProxy.$$$reportNull$$$0(5);
        }
        if (module2 == null) {
            JavaCompilerConfigurationProxy.$$$reportNull$$$0(6);
        }
        if (root == null) {
            JavaCompilerConfigurationProxy.$$$reportNull$$$0(7);
        }
        if ((options = JavaCompilerConfigurationProxy.getAdditionalOptions(module2.getProject(), module2)).isEmpty()) {
            return false;
        }
        String prefix = targetModuleName + "=";
        for (String option2 : JavaCompilerConfigurationProxy.optionValues(options, "--patch-module")) {
            String[] patchingPaths;
            if (!option2.startsWith(prefix)) continue;
            for (String patchingPath : patchingPaths = option2.substring(prefix.length()).split(File.pathSeparator)) {
                if (!VfsUtilCore.pathEqualsTo(root, FileUtil.toSystemIndependentName(patchingPath))) continue;
                return true;
            }
        }
        return false;
    }

    public static List<String> optionValues(List<String> options, String name2) {
        if (options.isEmpty()) {
            return Collections.emptyList();
        }
        boolean useValue = false;
        ArrayList<String> result2 = new ArrayList<String>();
        for (String option2 : options) {
            if (option2.equals(name2)) {
                useValue = true;
                continue;
            }
            if (useValue) {
                useValue = false;
            } else {
                if (!option2.startsWith(name2) || option2.length() <= name2.length() + 1 || option2.charAt(name2.length()) != '=') continue;
                option2 = option2.substring(name2.length() + 1);
            }
            if (option2.isEmpty()) continue;
            result2.add(option2);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetModuleName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/JavaCompilerConfigurationProxy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getAdditionalOptions";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setAdditionalOptions";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isPatchedModuleRoot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

