/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.LighterAST;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.lang.LighterLazyParseableNode;
import org.jetbrains.kotlin.com.intellij.lang.impl.TokenSequence;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaParserDefinition;
import org.jetbrains.kotlin.com.intellij.lexer.Lexer;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaFile;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaDocElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaSourceUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LightTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.stubs.LightStubBuilder;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;

public class JavaLightStubBuilder
extends LightStubBuilder {
    @Override
    @NotNull
    protected StubElement<?> createStubForFile(@NotNull PsiFile file2, @NotNull LighterAST tree) {
        LighterASTNode ref;
        if (file2 == null) {
            JavaLightStubBuilder.$$$reportNull$$$0(0);
        }
        if (tree == null) {
            JavaLightStubBuilder.$$$reportNull$$$0(1);
        }
        if (!(file2 instanceof PsiJavaFile)) {
            StubElement<?> stubElement = super.createStubForFile(file2, tree);
            if (stubElement == null) {
                JavaLightStubBuilder.$$$reportNull$$$0(2);
            }
            return stubElement;
        }
        String refText = "";
        LighterASTNode pkg = LightTreeUtil.firstChildOfType(tree, tree.getRoot(), JavaElementType.PACKAGE_STATEMENT);
        if (pkg != null && (ref = LightTreeUtil.firstChildOfType(tree, pkg, JavaElementType.JAVA_CODE_REFERENCE)) != null) {
            refText = JavaSourceUtil.getReferenceText(tree, ref);
        }
        return new PsiJavaFileStubImpl((PsiJavaFile)file2, refText, null, false);
    }

    @Override
    public boolean skipChildProcessingWhenBuildingStubs(@NotNull ASTNode parent2, @NotNull ASTNode node) {
        IElementType nodeType;
        IElementType parentType;
        if (parent2 == null) {
            JavaLightStubBuilder.$$$reportNull$$$0(3);
        }
        if (node == null) {
            JavaLightStubBuilder.$$$reportNull$$$0(4);
        }
        if (JavaLightStubBuilder.checkByTypes(parentType = parent2.getElementType(), nodeType = node.getElementType())) {
            return true;
        }
        if (nodeType == JavaElementType.CODE_BLOCK) {
            return JavaLightStubBuilder.isCodeBlockWithoutStubs(node);
        }
        return false;
    }

    private static boolean isCodeBlockWithoutStubs(@NotNull ASTNode node) {
        if (node == null) {
            JavaLightStubBuilder.$$$reportNull$$$0(5);
        }
        CodeBlockVisitor visitor2 = new CodeBlockVisitor();
        if (TreeUtil.isCollapsedChameleon(node)) {
            Lexer lexer = JavaParserDefinition.createLexer(PsiUtil.getLanguageLevel(node.getPsi()));
            TokenSequence tokens = TokenSequence.performLexing(node.getChars(), lexer);
            for (int i2 = 0; i2 < tokens.getTokenCount(); ++i2) {
                visitor2.visit(tokens.getTokenType(i2));
            }
        } else {
            ((TreeElement)node).acceptTree(visitor2);
        }
        return visitor2.result;
    }

    @Override
    protected boolean skipChildProcessingWhenBuildingStubs(@NotNull LighterAST tree, @NotNull LighterASTNode parent2, @NotNull LighterASTNode node) {
        if (tree == null) {
            JavaLightStubBuilder.$$$reportNull$$$0(6);
        }
        if (parent2 == null) {
            JavaLightStubBuilder.$$$reportNull$$$0(7);
        }
        if (node == null) {
            JavaLightStubBuilder.$$$reportNull$$$0(8);
        }
        return JavaLightStubBuilder.checkByTypes(parent2.getTokenType(), node.getTokenType()) || JavaLightStubBuilder.isCodeBlockWithoutStubs(node);
    }

    public static boolean isCodeBlockWithoutStubs(@NotNull LighterASTNode node) {
        if (node == null) {
            JavaLightStubBuilder.$$$reportNull$$$0(9);
        }
        if (node.getTokenType() == JavaElementType.CODE_BLOCK && node instanceof LighterLazyParseableNode) {
            CodeBlockVisitor visitor2 = new CodeBlockVisitor();
            ((LighterLazyParseableNode)node).accept(visitor2);
            return visitor2.result;
        }
        return false;
    }

    private static boolean checkByTypes(IElementType parentType, IElementType nodeType) {
        if (ElementType.IMPORT_STATEMENT_BASE_BIT_SET.contains(parentType)) {
            return true;
        }
        if (nodeType == JavaElementType.RECEIVER_PARAMETER) {
            return true;
        }
        if (nodeType == JavaElementType.PARAMETER && parentType != JavaElementType.PARAMETER_LIST) {
            return true;
        }
        if (nodeType == JavaElementType.PARAMETER_LIST && parentType == JavaElementType.LAMBDA_EXPRESSION) {
            return true;
        }
        return nodeType == JavaDocElementType.DOC_COMMENT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/JavaLightStubBuilder";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/JavaLightStubBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createStubForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createStubForFile";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "skipChildProcessingWhenBuildingStubs";
                break;
            }
            case 5: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isCodeBlockWithoutStubs";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CodeBlockVisitor
    extends RecursiveTreeElementWalkingVisitor
    implements LighterLazyParseableNode.Visitor {
        private static final TokenSet BLOCK_ELEMENTS = TokenSet.create(JavaElementType.CLASS, JavaElementType.ANONYMOUS_CLASS, JavaTokenType.ARROW, JavaTokenType.DOUBLE_COLON, JavaTokenType.AT);
        private boolean result = true;
        private IElementType preLast;
        private IElementType last;
        private boolean seenNew;
        private boolean seenLParen;
        private boolean seenModifier;

        private CodeBlockVisitor() {
        }

        @Override
        protected void visitNode(TreeElement element) {
            if (BLOCK_ELEMENTS.contains(element.getElementType())) {
                this.result = false;
                this.stopWalking();
                return;
            }
            super.visitNode(element);
        }

        @Override
        public boolean visit(IElementType type2) {
            if (ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(type2)) {
                return true;
            }
            if (type2 == JavaTokenType.AT || type2 == JavaTokenType.ARROW || type2 == JavaTokenType.DOUBLE_COLON) {
                this.result = false;
                return false;
            }
            if (type2 == JavaTokenType.NEW_KEYWORD) {
                this.seenNew = true;
            } else if (this.seenNew && type2 == JavaTokenType.SEMICOLON) {
                this.seenNew = false;
                this.seenLParen = false;
            } else {
                if (this.seenNew && type2 == JavaTokenType.LBRACE && this.seenLParen) {
                    this.result = false;
                    return false;
                }
                if (this.seenNew && type2 == JavaTokenType.LPARENTH) {
                    this.seenLParen = true;
                } else if (ElementType.MODIFIER_BIT_SET.contains(type2)) {
                    this.seenModifier = true;
                } else {
                    if (type2 == JavaTokenType.CLASS_KEYWORD && (this.last != JavaTokenType.DOT || this.preLast != JavaTokenType.IDENTIFIER || this.seenModifier) || type2 == JavaTokenType.ENUM_KEYWORD || type2 == JavaTokenType.INTERFACE_KEYWORD) {
                        this.result = false;
                        return false;
                    }
                    if (this.preLast == JavaTokenType.IDENTIFIER && this.last == JavaTokenType.IDENTIFIER && (type2 == JavaTokenType.LPARENTH || type2 == JavaTokenType.LT)) {
                        this.result = false;
                        return false;
                    }
                }
            }
            this.preLast = this.last;
            this.last = type2;
            return true;
        }
    }
}

