/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints;

import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import org.jetbrains.kotlin.com.intellij.core.JavaPsiBundle;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.LambdaUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiCall;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiConditionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiDiamondType;
import org.jetbrains.kotlin.com.intellij.psi.PsiDisjunctionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaParameterType;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiParenthesizedExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiSwitchExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.InputOutputConstraintFormula;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.LambdaExpressionCompatibilityConstraint;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.PsiMethodReferenceCompatibilityConstraint;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import org.jetbrains.kotlin.com.intellij.psi.infos.MethodCandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;

public class ExpressionCompatibilityConstraint
extends InputOutputConstraintFormula {
    private final PsiExpression myExpression;

    public ExpressionCompatibilityConstraint(@NotNull PsiExpression expression2, @NotNull PsiType type2) {
        if (expression2 == null) {
            ExpressionCompatibilityConstraint.$$$reportNull$$$0(0);
        }
        if (type2 == null) {
            ExpressionCompatibilityConstraint.$$$reportNull$$$0(1);
        }
        super(type2);
        this.myExpression = expression2;
    }

    @Override
    public boolean reduce(InferenceSession session2, List<? super ConstraintFormula> constraints) {
        PsiExpression expression3;
        PsiType myT = this.getCurrentType();
        if (!PsiPolyExpressionUtil.isPolyExpression(this.myExpression)) {
            PsiType exprType = this.myExpression.getType();
            if (session2.isProperType(myT)) {
                boolean assignmentCompatible;
                boolean bl = assignmentCompatible = exprType == null || TypeConversionUtil.isAssignable(myT, exprType);
                if (!assignmentCompatible) {
                    PsiType type2 = this.myExpression.getType();
                    session2.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type", type2 != null ? type2.getPresentableText() : this.myExpression.getText(), session2.getPresentableText(myT)));
                } else if (TypeCompatibilityConstraint.isUncheckedConversion(myT, exprType, session2) && !JavaGenericsUtil.isReifiableType(myT)) {
                    session2.setErased();
                }
                return assignmentCompatible;
            }
            if (exprType instanceof PsiLambdaParameterType) {
                return false;
            }
            if (exprType instanceof PsiClassType && ((PsiClassType)exprType).resolve() == null) {
                return true;
            }
            if (exprType != null && exprType != PsiTypes.nullType()) {
                if (exprType instanceof PsiDisjunctionType) {
                    exprType = ((PsiDisjunctionType)exprType).getLeastUpperBound();
                }
                constraints.add(new TypeCompatibilityConstraint(myT, exprType));
            }
            return true;
        }
        if (this.myExpression instanceof PsiParenthesizedExpression && (expression3 = ((PsiParenthesizedExpression)this.myExpression).getExpression()) != null && !InferenceSession.ignoreLambdaConstraintTree(expression3)) {
            constraints.add(new ExpressionCompatibilityConstraint(expression3, myT));
            return true;
        }
        if (this.myExpression instanceof PsiConditionalExpression) {
            PsiExpression elseExpression;
            PsiExpression thenExpression = ((PsiConditionalExpression)this.myExpression).getThenExpression();
            if (thenExpression != null && !InferenceSession.ignoreLambdaConstraintTree(thenExpression)) {
                constraints.add(new ExpressionCompatibilityConstraint(thenExpression, myT));
            }
            if ((elseExpression = ((PsiConditionalExpression)this.myExpression).getElseExpression()) != null && !InferenceSession.ignoreLambdaConstraintTree(elseExpression)) {
                constraints.add(new ExpressionCompatibilityConstraint(elseExpression, myT));
            }
            return true;
        }
        if (this.myExpression instanceof PsiSwitchExpression) {
            PsiUtil.getSwitchResultExpressions((PsiSwitchExpression)this.myExpression).forEach(expression2 -> {
                if (!InferenceSession.ignoreLambdaConstraintTree(expression2)) {
                    constraints.add(new ExpressionCompatibilityConstraint((PsiExpression)expression2, myT));
                }
            });
            return true;
        }
        if (this.myExpression instanceof PsiCall) {
            InferenceSession callSession = ExpressionCompatibilityConstraint.reduceExpressionCompatibilityConstraint(session2, this.myExpression, myT, true);
            if (callSession == null) {
                return false;
            }
            if (callSession != session2) {
                MethodCandidateInfo resolveResult;
                session2.getInferenceSessionContainer().registerNestedSession(callSession);
                session2.propagateVariables(callSession);
                for (Pair<InferenceVariable[], PsiClassType> pair : callSession.myIncorporationPhase.getCaptures()) {
                    session2.myIncorporationPhase.addCapture((InferenceVariable[])pair.first, (PsiClassType)pair.second);
                }
                MethodCandidateInfo currentMethod = session2.getCurrentMethod(((PsiCall)((Object)this.myExpression)).getArgumentList());
                JavaResolveResult javaResolveResult = resolveResult = currentMethod != null ? currentMethod : PsiDiamondType.getDiamondsAwareResolveResult((PsiCall)((Object)this.myExpression));
                if (resolveResult instanceof MethodCandidateInfo && callSession.isErased()) {
                    resolveResult.setErased();
                }
            }
            return true;
        }
        if (this.myExpression instanceof PsiMethodReferenceExpression) {
            constraints.add(new PsiMethodReferenceCompatibilityConstraint((PsiMethodReferenceExpression)this.myExpression, myT));
            return true;
        }
        if (this.myExpression instanceof PsiLambdaExpression) {
            constraints.add(new LambdaExpressionCompatibilityConstraint((PsiLambdaExpression)this.myExpression, myT));
            return true;
        }
        return true;
    }

    public static InferenceSession reduceExpressionCompatibilityConstraint(InferenceSession session2, PsiExpression expression2, PsiType targetType, boolean registerErrorOnFailure) {
        if (!PsiPolyExpressionUtil.isPolyExpression(expression2)) {
            return session2;
        }
        PsiExpressionList argumentList = ((PsiCall)((Object)expression2)).getArgumentList();
        if (argumentList != null) {
            PsiMethod method;
            JavaResolveResult resolveResult;
            MethodCandidateInfo currentMethod = session2.getCurrentMethod(argumentList);
            PsiType returnType = null;
            PsiTypeParameter[] typeParams = null;
            JavaResolveResult javaResolveResult = resolveResult = currentMethod != null ? null : PsiDiamondType.getDiamondsAwareResolveResult((PsiCall)((Object)expression2));
            PsiMethod psiMethod = currentMethod != null ? currentMethod.getElement() : (method = resolveResult instanceof MethodCandidateInfo ? ((MethodCandidateInfo)resolveResult).getElement() : null);
            if (method != null && !method.isConstructor()) {
                returnType = method.getReturnType();
                typeParams = method.getTypeParameters();
            } else if (resolveResult != null) {
                PsiClass psiClass;
                PsiClass psiClass2 = psiClass = method != null ? method.getContainingClass() : (PsiClass)resolveResult.getElement();
                if (psiClass != null) {
                    returnType = JavaPsiFacade.getElementFactory(argumentList.getProject()).createType(psiClass, PsiSubstitutor.EMPTY);
                    typeParams = psiClass.getTypeParameters();
                    if (method != null && method.hasTypeParameters()) {
                        typeParams = ArrayUtil.mergeArrays(typeParams, method.getTypeParameters());
                    }
                }
            } else {
                return session2;
            }
            if (typeParams != null) {
                List<String> messages;
                PsiSubstitutor siteSubstitutor = InferenceSession.chooseSiteSubstitutor(currentMethod, resolveResult, method);
                InferenceSession callSession = new InferenceSession(typeParams, siteSubstitutor, expression2.getManager(), expression2, session2.getInferencePolicy());
                callSession.propagateVariables(session2);
                if (method != null) {
                    PsiExpression[] args2 = argumentList.getExpressions();
                    PsiParameter[] parameters = method.getParameterList().getParameters();
                    callSession.initExpressionConstraints(parameters, args2, method, InferenceSession.chooseVarargsMode(currentMethod, resolveResult));
                }
                if (callSession.repeatInferencePhases()) {
                    if (PsiTypes.voidType().equals(targetType)) {
                        return callSession;
                    }
                    if (returnType != null) {
                        callSession.registerReturnTypeConstraints(siteSubstitutor.substitute(returnType), targetType, expression2);
                    }
                    if (callSession.repeatInferencePhases()) {
                        if (callSession.isErased() && !JavaGenericsUtil.isReifiableType(targetType) && session2.getInferenceVariable(targetType) == null) {
                            session2.setErased();
                        }
                        return callSession;
                    }
                }
                if ((messages = callSession.getIncompatibleErrorMessages()) != null) {
                    for (String message : messages) {
                        session2.registerIncompatibleErrorMessage(message);
                    }
                }
                return null;
            }
            if (registerErrorOnFailure) {
                session2.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.failed.to.resolve.argument", new Object[0]));
                return null;
            }
        }
        return session2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpressionCompatibilityConstraint that = (ExpressionCompatibilityConstraint)o;
        return this.myExpression.equals(that.myExpression);
    }

    public int hashCode() {
        return this.myExpression.hashCode();
    }

    @Override
    public PsiExpression getExpression() {
        return this.myExpression;
    }

    @Override
    protected InputOutputConstraintFormula createSelfConstraint(PsiType type2, PsiExpression expression2) {
        return new ExpressionCompatibilityConstraint(expression2, type2);
    }

    @Override
    protected void collectReturnTypeVariables(InferenceSession session2, PsiExpression psiExpression, PsiType returnType, Set<? super InferenceVariable> result2) {
        if (psiExpression instanceof PsiLambdaExpression && !PsiTypes.voidType().equals(returnType)) {
            List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)psiExpression);
            for (PsiExpression expression2 : returnExpressions) {
                Set<InferenceVariable> resultInputVars = this.createSelfConstraint(returnType, expression2).getInputVariables(session2);
                if (resultInputVars == null) continue;
                result2.addAll(resultInputVars);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "expression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "type";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/constraints/ExpressionCompatibilityConstraint";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

