/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiForStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaToken;
import org.jetbrains.kotlin.com.intellij.psi.PsiStatement;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.Constants;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.PsiLoopStatementImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.PsiWhileStatementImpl;
import org.jetbrains.kotlin.com.intellij.psi.scope.ElementClassHint;
import org.jetbrains.kotlin.com.intellij.psi.scope.PatternResolveState;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

public class PsiForStatementImpl
extends PsiLoopStatementImpl
implements PsiForStatement,
Constants {
    private static final Logger LOG = Logger.getInstance(PsiForStatementImpl.class);

    public PsiForStatementImpl() {
        super(FOR_STATEMENT);
    }

    @Override
    public PsiStatement getInitialization() {
        return (PsiStatement)this.findChildByRoleAsPsiElement(39);
    }

    @Override
    public PsiExpression getCondition() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(32);
    }

    @Override
    public PsiStatement getUpdate() {
        return (PsiStatement)this.findChildByRoleAsPsiElement(40);
    }

    @Override
    public PsiStatement getBody() {
        return (PsiStatement)this.findChildByRoleAsPsiElement(38);
    }

    @Override
    public PsiJavaToken getLParenth() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(24);
    }

    @Override
    public PsiJavaToken getRParenth() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(25);
    }

    @Override
    public ASTNode findChildByRole(int role) {
        ASTNode rparenth;
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 37: {
                return this.findChildByType(FOR_KEYWORD);
            }
            case 24: {
                return this.findChildByType(LPARENTH);
            }
            case 39: {
                ASTNode paren;
                ASTNode initialization = PsiImplUtil.findStatementChild(this);
                for (ASTNode child = paren = this.findChildByRole(24); child != null; child = child.getTreeNext()) {
                    if (child == initialization) {
                        return initialization;
                    }
                    if (child.getElementType() != RPARENTH) continue;
                    return null;
                }
                return null;
            }
            case 32: {
                return this.findChildByType(EXPRESSION_BIT_SET);
            }
            case 41: {
                return this.findChildByType(SEMICOLON);
            }
            case 40: {
                ASTNode semicolon;
                for (ASTNode child = semicolon = this.findChildByRole(41); child != null; child = child.getTreeNext()) {
                    if (child.getPsi() instanceof PsiStatement) {
                        return child;
                    }
                    if (child.getElementType() == RPARENTH) break;
                }
                return null;
            }
            case 25: {
                return this.findChildByType(RPARENTH);
            }
            case 38: 
        }
        for (ASTNode child = rparenth = this.findChildByRole(25); child != null; child = child.getTreeNext()) {
            if (!(child.getPsi() instanceof PsiStatement)) continue;
            return child;
        }
        return null;
    }

    @Override
    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiForStatementImpl.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i2 = child.getElementType();
        if (i2 == FOR_KEYWORD) {
            return 37;
        }
        if (i2 == LPARENTH) {
            return 24;
        }
        if (i2 == RPARENTH) {
            return 25;
        }
        if (i2 == SEMICOLON) {
            return 41;
        }
        if (EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 32;
        }
        if (child.getPsi() instanceof PsiStatement) {
            int role = this.getChildRole(child, 39);
            if (role != 0) {
                return role;
            }
            role = this.getChildRole(child, 40);
            if (role != 0) {
                return role;
            }
            return 38;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiForStatementImpl.$$$reportNull$$$0(1);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitForStatement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiForStatement";
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            PsiForStatementImpl.$$$reportNull$$$0(2);
        }
        if (this.getChildRole(child) == 39) {
            this.replaceChildInternal(child, (TreeElement)((Object)JavaPsiFacade.getElementFactory(this.getProject()).createStatementFromText(";", null)));
        } else {
            super.deleteChildInternal(child);
        }
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            PsiForStatementImpl.$$$reportNull$$$0(3);
        }
        if (state == null) {
            PsiForStatementImpl.$$$reportNull$$$0(4);
        }
        if (place == null) {
            PsiForStatementImpl.$$$reportNull$$$0(5);
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        ElementClassHint elementClassHint = processor.getHint(ElementClassHint.KEY);
        if (elementClassHint != null && !elementClassHint.shouldProcess(ElementClassHint.DeclarationKind.VARIABLE)) {
            return true;
        }
        if (lastParent == null) {
            return PsiWhileStatementImpl.processDeclarationsInLoopCondition(processor, state, place, this);
        }
        if (lastParent.getParent() != this) {
            return true;
        }
        PsiStatement initialization = this.getInitialization();
        if (initialization != null && lastParent != initialization && !initialization.processDeclarations(processor, state, null, place)) {
            return false;
        }
        PsiExpression condition = this.getCondition();
        if (condition != null && (lastParent == this.getBody() || lastParent == this.getUpdate())) {
            return condition.processDeclarations(processor, PatternResolveState.WHEN_TRUE.putInto(state), null, place);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiForStatementImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildRole";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteChildInternal";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processDeclarations";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

