/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.scope.conflictResolvers;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiConflictResolver;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;

public class JavaVariableConflictResolver
implements PsiConflictResolver {
    @Override
    public CandidateInfo resolveConflict(@NotNull List<CandidateInfo> conflicts) {
        int size;
        if (conflicts == null) {
            JavaVariableConflictResolver.$$$reportNull$$$0(0);
        }
        if ((size = conflicts.size()) == 1) {
            return conflicts.get(0);
        }
        if (size == 0) {
            return null;
        }
        CandidateInfo[] uncheckedResult = conflicts.toArray(new CandidateInfo[size]);
        CandidateInfo currentResult = uncheckedResult[0];
        PsiElement currentElement = currentResult.getElement();
        if (currentElement instanceof PsiField) {
            for (int i2 = 1; i2 < uncheckedResult.length; ++i2) {
                CandidateInfo candidate2 = uncheckedResult[i2];
                PsiElement otherElement = candidate2.getElement();
                if (!(otherElement instanceof PsiField)) {
                    if (PsiUtil.isJvmLocalVariable(otherElement)) {
                        return candidate2;
                    }
                    if (!currentResult.isAccessible()) {
                        return candidate2;
                    }
                    conflicts.remove(candidate2);
                    continue;
                }
                PsiClass newClass = ((PsiField)otherElement).getContainingClass();
                PsiClass oldClass = ((PsiField)currentElement).getContainingClass();
                PsiElement scope2 = currentResult.getCurrentFileResolveScope();
                Boolean oldClassIsInheritor = null;
                if (newClass != null && oldClass != null) {
                    if (newClass.isInheritor(oldClass, true)) {
                        if (scope2 instanceof PsiClass && (scope2.equals(oldClass) || scope2.equals(newClass) || !((PsiClass)scope2).isInheritorDeep(oldClass, newClass))) {
                            conflicts.remove(currentResult);
                            currentResult = candidate2;
                            currentElement = currentResult.getElement();
                            continue;
                        }
                    } else {
                        oldClassIsInheritor = oldClass.isInheritor(newClass, true);
                        if (oldClassIsInheritor.booleanValue() && (!(scope2 instanceof PsiClass) || scope2.equals(oldClass) || scope2.equals(newClass) || !((PsiClass)scope2).isInheritorDeep(newClass, oldClass))) {
                            conflicts.remove(candidate2);
                            continue;
                        }
                    }
                }
                if (!candidate2.isAccessible()) {
                    conflicts.remove(candidate2);
                    continue;
                }
                if (!currentResult.isAccessible()) {
                    conflicts.remove(currentResult);
                    currentResult = candidate2;
                    currentElement = currentResult.getElement();
                    continue;
                }
                if (otherElement == currentElement) {
                    conflicts.remove(candidate2);
                    continue;
                }
                if (oldClassIsInheritor == null) {
                    oldClassIsInheritor = oldClass != null && newClass != null && oldClass.isInheritor(newClass, true);
                }
                if (oldClassIsInheritor.booleanValue() && (scope2 instanceof PsiAnonymousClass || !(scope2 instanceof PsiClass) || !((PsiClass)scope2).isInheritorDeep(oldClass, newClass))) {
                    conflicts.remove(candidate2);
                    continue;
                }
                return null;
            }
        }
        return currentResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "org/jetbrains/kotlin/com/intellij/psi/scope/conflictResolvers/JavaVariableConflictResolver", "resolveConflict"));
    }
}

