/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.Forceable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.ThrowableNotNullFunction;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtil;
import org.jetbrains.kotlin.com.intellij.util.io.Bits;
import org.jetbrains.kotlin.com.intellij.util.io.ClosedStorageException;
import org.jetbrains.kotlin.com.intellij.util.io.DirectBufferWrapper;
import org.jetbrains.kotlin.com.intellij.util.io.FileChannelInterruptsRetryer;
import org.jetbrains.kotlin.com.intellij.util.io.IOStatistics;
import org.jetbrains.kotlin.com.intellij.util.io.OpenChannelsCache;
import org.jetbrains.kotlin.com.intellij.util.io.PageCacheUtils;
import org.jetbrains.kotlin.com.intellij.util.io.PagedFileStorageCache;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentHashMapValueStorage;
import org.jetbrains.kotlin.com.intellij.util.io.StorageLockContext;
import org.jetbrains.kotlin.com.intellij.util.io.storage.AbstractStorage;

public final class PagedFileStorage
implements Forceable,
Closeable {
    static final Logger LOG = Logger.getInstance(PagedFileStorage.class);
    private static final int DEFAULT_PAGE_SIZE = PageCacheUtils.DEFAULT_PAGE_SIZE;
    @NotNull
    private static final ThreadLocal<byte[]> ourTypedIOBuffer = ThreadLocal.withInitial(() -> new byte[8]);
    @NotNull
    public static final ThreadLocal<StorageLockContext> THREAD_LOCAL_STORAGE_LOCK_CONTEXT = new ThreadLocal();
    @NotNull
    private final StorageLockContext myStorageLockContext;
    private final boolean myNativeBytesOrder;
    private long myStorageIndex;
    @NotNull
    private final PagedFileStorageCache myLastAccessedBufferCache;
    @NotNull
    private final Path myFile;
    private final boolean myReadOnly;
    private final Object myInputStreamLock;
    private final int myPageSize;
    private final boolean myValuesAreBufferAligned;
    private volatile boolean isDirty;
    private volatile long mySize;

    public PagedFileStorage(@NotNull Path file2, @Nullable StorageLockContext storageLockContext, int pageSize, boolean valuesAreBufferAligned, boolean nativeBytesOrder) {
        if (file2 == null) {
            PagedFileStorage.$$$reportNull$$$0(0);
        }
        this.myLastAccessedBufferCache = new PagedFileStorageCache();
        this.myInputStreamLock = new Object();
        this.mySize = -1L;
        this.myFile = file2;
        this.myReadOnly = PersistentHashMapValueStorage.CreationTimeOptions.READONLY.get() == Boolean.TRUE;
        this.myStorageLockContext = PagedFileStorage.lookupStorageContext(storageLockContext);
        this.myPageSize = Math.max(pageSize > 0 ? pageSize : DEFAULT_PAGE_SIZE, AbstractStorage.PAGE_SIZE);
        this.myValuesAreBufferAligned = valuesAreBufferAligned;
        this.myStorageIndex = this.myStorageLockContext.getBufferCache().registerPagedFileStorage(this);
        this.myNativeBytesOrder = nativeBytesOrder;
    }

    public int getPageSize() {
        return this.myPageSize;
    }

    public void lockRead() {
        this.myStorageLockContext.lockRead();
    }

    public void unlockRead() {
        this.myStorageLockContext.unlockRead();
    }

    public void lockWrite() {
        this.myStorageLockContext.lockWrite();
    }

    public void unlockWrite() {
        this.myStorageLockContext.unlockWrite();
    }

    @NotNull
    public StorageLockContext getStorageLockContext() {
        StorageLockContext storageLockContext = this.myStorageLockContext;
        if (storageLockContext == null) {
            PagedFileStorage.$$$reportNull$$$0(1);
        }
        return storageLockContext;
    }

    @NotNull
    public Path getFile() {
        Path path = this.myFile;
        if (path == null) {
            PagedFileStorage.$$$reportNull$$$0(2);
        }
        return path;
    }

    public boolean isNativeBytesOrder() {
        return this.myNativeBytesOrder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public <R> R readInputStream(@NotNull ThrowableNotNullFunction<? super InputStream, R, ? extends IOException> consumer2) throws IOException {
        Object object;
        if (consumer2 == null) {
            PagedFileStorage.$$$reportNull$$$0(3);
        }
        Object object2 = this.myInputStreamLock;
        synchronized (object2) {
            try {
                object = this.executeOp(ch -> {
                    ch.position(0L);
                    return consumer2.fun(Channels.newInputStream(ch));
                }, true);
            }
            catch (NoSuchFileException ignored) {
                R r = consumer2.fun(new ByteArrayInputStream(ArrayUtil.EMPTY_BYTE_ARRAY));
                // MONITOREXIT @DISABLED, blocks:[2, 3] lbl11 : MonitorExitStatement: MONITOREXIT : object2
                if (r == null) {
                    PagedFileStorage.$$$reportNull$$$0(5);
                }
                return r;
            }
        }
        if (object == null) {
            PagedFileStorage.$$$reportNull$$$0(4);
        }
        return (R)object;
    }

    <R> R executeOp(@NotNull OpenChannelsCache.FileChannelOperation<R> operation, boolean readOnly) throws IOException {
        if (operation == null) {
            PagedFileStorage.$$$reportNull$$$0(9);
        }
        return this.myStorageLockContext.executeOp(this.myFile, operation, readOnly);
    }

    <R> R executeIdempotentOp(@NotNull FileChannelInterruptsRetryer.FileChannelIdempotentOperation<R> operation, boolean readOnly) throws IOException {
        if (operation == null) {
            PagedFileStorage.$$$reportNull$$$0(10);
        }
        return this.myStorageLockContext.executeIdempotentOp(this.myFile, operation, readOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putInt(long addr, int value2) throws IOException {
        if (this.myValuesAreBufferAligned) {
            long page = addr / (long)this.myPageSize;
            int page_offset = (int)(addr % (long)this.myPageSize);
            DirectBufferWrapper buffer = this.getBuffer(page);
            try {
                buffer.putInt(page_offset, value2);
            }
            finally {
                buffer.unlock();
            }
        } else {
            Bits.putInt(PagedFileStorage.getThreadLocalTypedIOBuffer(), 0, value2);
            this.put(addr, PagedFileStorage.getThreadLocalTypedIOBuffer(), 0, 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(long addr) throws IOException {
        if (this.myValuesAreBufferAligned) {
            long page = addr / (long)this.myPageSize;
            int page_offset = (int)(addr % (long)this.myPageSize);
            DirectBufferWrapper buffer = this.getReadOnlyBuffer(page, true);
            try {
                int n = buffer.getInt(page_offset);
                return n;
            }
            finally {
                buffer.unlock();
            }
        }
        this.get(addr, PagedFileStorage.getThreadLocalTypedIOBuffer(), 0, 4, true);
        return Bits.getInt(PagedFileStorage.getThreadLocalTypedIOBuffer(), 0);
    }

    public int getOffsetInPage(long addr) {
        return (int)(addr % (long)this.myPageSize);
    }

    public DirectBufferWrapper getByteBuffer(long address2, boolean modify) throws IOException {
        long page = address2 / (long)this.myPageSize;
        assert (page >= 0L && page <= 0xFFFFFFFFL) : address2 + " in " + this.myFile;
        return this.getBufferWrapper(page, modify, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putLong(long addr, long value2) throws IOException {
        if (this.myValuesAreBufferAligned) {
            long page = addr / (long)this.myPageSize;
            int page_offset = (int)(addr % (long)this.myPageSize);
            DirectBufferWrapper buffer = this.getBuffer(page);
            try {
                buffer.putLong(page_offset, value2);
            }
            finally {
                buffer.unlock();
            }
        } else {
            Bits.putLong(PagedFileStorage.getThreadLocalTypedIOBuffer(), 0, value2);
            this.put(addr, PagedFileStorage.getThreadLocalTypedIOBuffer(), 0, 8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(long addr) throws IOException {
        if (this.myValuesAreBufferAligned) {
            long page = addr / (long)this.myPageSize;
            int page_offset = (int)(addr % (long)this.myPageSize);
            DirectBufferWrapper buffer = this.getReadOnlyBuffer(page, true);
            try {
                long l = buffer.getLong(page_offset);
                return l;
            }
            finally {
                buffer.unlock();
            }
        }
        this.get(addr, PagedFileStorage.getThreadLocalTypedIOBuffer(), 0, 8, true);
        return Bits.getLong(PagedFileStorage.getThreadLocalTypedIOBuffer(), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte get(long index, boolean checkAccess) throws IOException {
        long page = index / (long)this.myPageSize;
        int offset2 = (int)(index % (long)this.myPageSize);
        DirectBufferWrapper buffer = this.getReadOnlyBuffer(page, checkAccess);
        try {
            byte by = buffer.get(offset2, checkAccess);
            return by;
        }
        finally {
            buffer.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(long index, byte[] dst, int offset2, int length, boolean checkAccess) throws IOException {
        long i2 = index;
        int o = offset2;
        int l = length;
        while (l > 0) {
            long page = i2 / (long)this.myPageSize;
            int page_offset = (int)(i2 % (long)this.myPageSize);
            int page_len = Math.min(l, this.myPageSize - page_offset);
            DirectBufferWrapper buffer = this.getReadOnlyBuffer(page, checkAccess);
            try {
                buffer.readToArray(dst, o, page_offset, page_len, checkAccess);
            }
            finally {
                buffer.unlock();
            }
            l -= page_len;
            o += page_len;
            i2 += (long)page_len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(long index, byte[] src, int offset2, int length) throws IOException {
        long i2 = index;
        int o = offset2;
        int l = length;
        while (l > 0) {
            long page = i2 / (long)this.myPageSize;
            int page_offset = (int)(i2 % (long)this.myPageSize);
            int page_len = Math.min(l, this.myPageSize - page_offset);
            DirectBufferWrapper buffer = this.getBuffer(page);
            try {
                buffer.putFromArray(src, o, page_offset, page_len);
            }
            finally {
                buffer.unlock();
            }
            l -= page_len;
            o += page_len;
            i2 += (long)page_len;
        }
    }

    @Override
    public void close() throws IOException {
        ExceptionUtil.runAllAndRethrowAllExceptions(IOException.class, () -> new IOException("Failed to close PagedFileStorage[" + this.getFile() + "]"), this::force, () -> {
            this.unmapAll();
            this.myStorageLockContext.getBufferCache().removeStorage(this.myStorageIndex);
            this.myStorageIndex = -1L;
        }, () -> PageCacheUtils.CHANNELS_CACHE.closeChannel(this.myFile));
    }

    private void unmapAll() {
        this.myStorageLockContext.getBufferCache().unmapBuffersForOwner(this);
        this.myLastAccessedBufferCache.clear();
    }

    public void resize(long newSize) throws IOException {
        long oldSize;
        if (Files.exists(this.myFile, new LinkOption[0])) {
            oldSize = Files.size(this.myFile);
        } else {
            Files.createDirectories(this.myFile.getParent(), new FileAttribute[0]);
            oldSize = 0L;
        }
        if (oldSize == newSize && oldSize == this.length()) {
            return;
        }
        long delta = newSize - oldSize;
        this.mySize = -1L;
        if (delta > 0L) {
            this.myStorageLockContext.executeOp(this.myFile, channel -> {
                channel.write(ByteBuffer.allocate(1), newSize - 1L);
                return null;
            }, false);
            this.mySize = newSize;
            this.fillWithZeros(oldSize, delta);
        } else {
            this.myStorageLockContext.executeOp(this.myFile, channel -> {
                channel.truncate(newSize);
                return null;
            }, false);
            this.mySize = newSize;
        }
    }

    private void fillWithZeros(long from2, long length) throws IOException {
        byte[] zeroes = new byte[8192];
        long offset2 = from2;
        long remaining = length;
        while (remaining > 0L) {
            int toFill = (int)Math.min(remaining, 8192L);
            if (toFill <= 0) {
                throw new AssertionError((Object)("Bug: toFill(=" + toFill + ") -- must be positive. Details: from: " + from2 + ", length: " + length + " -> offset: " + offset2 + ", remaining: " + remaining));
            }
            this.put(offset2, zeroes, 0, toFill);
            remaining -= (long)toFill;
            offset2 += (long)toFill;
        }
    }

    public long length() {
        long size = this.mySize;
        if (size == -1L) {
            if (Files.exists(this.myFile, new LinkOption[0])) {
                try {
                    this.mySize = size = Files.size(this.myFile);
                }
                catch (IOException e) {
                    LOG.error(e);
                }
            } else {
                size = 0L;
                this.mySize = 0L;
            }
        }
        return size;
    }

    private DirectBufferWrapper getBuffer(long page) throws IOException {
        return this.getBufferWrapper(page, true, true);
    }

    private DirectBufferWrapper getReadOnlyBuffer(long page, boolean checkAccess) throws IOException {
        return this.getBufferWrapper(page, false, checkAccess);
    }

    private DirectBufferWrapper getBufferWrapper(long page, boolean modify, boolean checkAccess) throws IOException {
        DirectBufferWrapper wrapper;
        do {
            wrapper = this.doGetBufferWrapper(page, modify, checkAccess);
            assert (this == wrapper.getFile());
        } while (!wrapper.tryLock());
        return wrapper;
    }

    @NotNull
    private DirectBufferWrapper doGetBufferWrapper(long page, boolean modify, boolean checkAccess) throws IOException {
        if (this.myReadOnly && modify) {
            throw new IOException("Read-only storage can't be modified");
        }
        DirectBufferWrapper pageFromCache = this.myLastAccessedBufferCache.getPageFromCache(page);
        if (pageFromCache != null) {
            this.myStorageLockContext.getBufferCache().incrementFastCacheHitsCount();
            DirectBufferWrapper directBufferWrapper = pageFromCache;
            if (directBufferWrapper == null) {
                PagedFileStorage.$$$reportNull$$$0(12);
            }
            return directBufferWrapper;
        }
        if (page < 0L || page > 0xFFFFFFFFL) {
            throw new AssertionError((Object)("Page " + page + " is outside of [0, " + 0xFFFFFFFFL + ")"));
        }
        if (this.myStorageIndex == -1L) {
            throw new ClosedStorageException("storage is already closed; path " + this.myFile);
        }
        DirectBufferWrapper byteBufferWrapper = this.myStorageLockContext.getBufferCache().get(this.myStorageIndex | page, !modify, checkAccess);
        this.myLastAccessedBufferCache.updateCache(page, byteBufferWrapper);
        DirectBufferWrapper directBufferWrapper = byteBufferWrapper;
        if (directBufferWrapper == null) {
            PagedFileStorage.$$$reportNull$$$0(13);
        }
        return directBufferWrapper;
    }

    void markDirty() {
        if (!this.isDirty) {
            this.isDirty = true;
        }
    }

    public void ensureCachedSizeAtLeast(long size) {
        if (this.mySize < size) {
            this.mySize = size;
        }
    }

    public boolean isReadOnly() {
        return this.myReadOnly;
    }

    private static byte[] getThreadLocalTypedIOBuffer() {
        return ourTypedIOBuffer.get();
    }

    @Override
    public void force() throws IOException {
        long finished;
        long started;
        long l = started = IOStatistics.DEBUG ? System.currentTimeMillis() : 0L;
        if (this.isDirty) {
            this.myStorageLockContext.getBufferCache().flushBuffersForOwner(this);
            this.isDirty = false;
        }
        if (IOStatistics.DEBUG && (finished = System.currentTimeMillis()) - started > 100L) {
            IOStatistics.dump("Flushed " + this.myFile + " for " + (finished - started));
        }
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    public String toString() {
        return "PagedFileStorage[" + this.myFile + "]";
    }

    @NotNull
    public static StorageLockContext lookupStorageContext(@Nullable StorageLockContext storageLockContext) {
        StorageLockContext threadLocalContext = THREAD_LOCAL_STORAGE_LOCK_CONTEXT.get();
        if (threadLocalContext != null) {
            if (storageLockContext != null && storageLockContext != threadLocalContext) {
                throw new IllegalStateException("Context(" + storageLockContext + ") != THREAD_LOCAL_STORAGE_LOCK_CONTEXT(" + threadLocalContext + ")");
            }
            StorageLockContext storageLockContext2 = threadLocalContext;
            if (storageLockContext2 == null) {
                PagedFileStorage.$$$reportNull$$$0(14);
            }
            return storageLockContext2;
        }
        if (storageLockContext != null) {
            StorageLockContext storageLockContext3 = storageLockContext;
            if (storageLockContext3 == null) {
                PagedFileStorage.$$$reportNull$$$0(15);
            }
            return storageLockContext3;
        }
        StorageLockContext storageLockContext4 = StorageLockContext.DEFAULT_CONTEXT;
        if (storageLockContext4 == null) {
            PagedFileStorage.$$$reportNull$$$0(16);
        }
        return storageLockContext4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/io/PagedFileStorage";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/PagedFileStorage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorageLockContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "readInputStream";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "readChannel";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetBufferWrapper";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "lookupStorageContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readInputStream";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readChannel";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "executeOp";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "executeIdempotentOp";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "putBuffer";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

