/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyGetter;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertySetter;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u0016\u001a\u00020\u000e*\u00020\u0002H\u0002J\f\u0010\u0017\u001a\u00020\u000e*\u00020\u0002H\u0002J\f\u0010\u0018\u001a\u00020\u000e*\u00020\u0002H\u0002J&\u0010\u0019\u001a\u00020\u0007*\u00020\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0018\u0010\u0013\u001a\u00020\u000e*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInapplicableLateinitChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "hasUnderlyingTypeForbiddenForLateinit", "", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "hasNullableUpperBound", "getHasNullableUpperBound", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Z", "isNullable", "hasGetter", "hasSetter", "reportError", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "target", "", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirInapplicableLateinitChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirInapplicableLateinitChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInapplicableLateinitChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n48#2:138\n12#2:139\n1755#3,3:140\n*S KotlinDebug\n*F\n+ 1 FirInapplicableLateinitChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInapplicableLateinitChecker\n*L\n31#1:138\n79#1:139\n124#1:140,3\n*E\n"})
public final class FirInapplicableLateinitChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirInapplicableLateinitChecker INSTANCE = new FirInapplicableLateinitChecker();

    private FirInapplicableLateinitChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirProperty declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirMemberDeclaration $this$isLateInit$iv = declaration;
        boolean $i$f$isLateInit = false;
        if (!$this$isLateInit$iv.getStatus().isLateInit() || declaration.getReturnTypeRef() instanceof FirErrorTypeRef) {
            return;
        }
        if (declaration.isVal()) {
            this.reportError(reporter, declaration.getSource(), "is allowed only on mutable properties", context);
        }
        if (declaration.getInitializer() != null) {
            if (declaration.isLocal()) {
                this.reportError(reporter, declaration.getSource(), "is not allowed on local variables with initializer", context);
            } else {
                this.reportError(reporter, declaration.getSource(), "is not allowed on properties with initializer", context);
            }
        }
        if (declaration.getDelegate() != null) {
            this.reportError(reporter, declaration.getSource(), "is not allowed on delegated properties", context);
        }
        if (this.isNullable(declaration)) {
            this.reportError(reporter, declaration.getSource(), "is not allowed on properties of a type with nullable upper bound", context);
        }
        if (ConeBuiltinTypeUtilsKt.isPrimitive(FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef()))) {
            if (declaration.isLocal()) {
                this.reportError(reporter, declaration.getSource(), "is not allowed on local variables of primitive types", context);
            } else {
                this.reportError(reporter, declaration.getSource(), "is not allowed on properties of primitive types", context);
            }
        }
        if (DeclarationAttributesKt.getHasExplicitBackingField(declaration)) {
            this.reportError(reporter, declaration.getSource(), "must be moved to the field declaration", context);
        }
        if ((this.hasGetter(declaration) || this.hasSetter(declaration)) && declaration.getDelegate() == null) {
            this.reportError(reporter, declaration.getSource(), "is not allowed on properties with a custom getter or setter", context);
        }
        if (FirDeclarationUtilKt.isExtension(declaration)) {
            this.reportError(reporter, declaration.getSource(), "is not allowed on extension properties", context);
        }
        if (!((Collection)declaration.getContextReceivers()).isEmpty()) {
            this.reportError(reporter, declaration.getSource(), "is not allowed on properties with context receivers", context);
        }
        FirMemberDeclaration $this$isAbstract$iv = declaration;
        boolean $i$f$isAbstract = false;
        if ($this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT) {
            this.reportError(reporter, declaration.getSource(), "is not allowed on abstract properties", context);
        }
        if (FirHelpersKt.isSingleFieldValueClass(FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef()), context.getSession())) {
            ConeKotlinType declarationType = TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef()), context.getSession(), null, 2, null);
            String variables2 = declaration.isLocal() ? "local variables" : "properties";
            if (ConeBuiltinTypeUtilsKt.isUnsignedType(declarationType)) {
                this.reportError(reporter, declaration.getSource(), "is not allowed on " + variables2 + " of unsigned types", context);
            } else if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.InlineLateinit)) {
                this.reportError(reporter, declaration.getSource(), "is not allowed on " + variables2 + " of inline class types", context);
            } else if (this.hasUnderlyingTypeForbiddenForLateinit(declarationType, context.getSession())) {
                this.reportError(reporter, declaration.getSource(), "is not allowed on " + variables2 + " of inline type with underlying type not suitable for lateinit declaration", context);
            }
        }
    }

    private final boolean hasUnderlyingTypeForbiddenForLateinit(ConeKotlinType type2, FirSession session2) {
        if (FirHelpersKt.isRecursiveValueClassType(type2, session2)) {
            return false;
        }
        return FirInapplicableLateinitChecker.hasUnderlyingTypeForbiddenForLateinit$isForbiddenTypeForLateinit(session2, FirHelpersKt.getInlineClassUnderlyingType(type2, session2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getHasNullableUpperBound(ConeKotlinType $this$hasNullableUpperBound) {
        if ($this$hasNullableUpperBound instanceof ConeTypeParameterType) {
            FirResolvedTypeRef it;
            if (ConeTypeUtilsKt.isNullable($this$hasNullableUpperBound)) return true;
            Iterable $this$any$iv = ((ConeTypeParameterType)$this$hasNullableUpperBound).getLookupTag().getTypeParameterSymbol().getResolvedBounds();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                it = (FirResolvedTypeRef)element$iv;
                boolean bl = false;
            } while (!ConeTypeUtilsKt.isNullable(FirTypeUtilsKt.getConeType(it)));
            return true;
        }
        boolean bl = ConeTypeUtilsKt.isNullable($this$hasNullableUpperBound);
        return bl;
    }

    private final boolean isNullable(FirProperty $this$isNullable) {
        return this.getHasNullableUpperBound(FirTypeUtilsKt.getConeType($this$isNullable.getReturnTypeRef()));
    }

    private final boolean hasGetter(FirProperty $this$hasGetter) {
        return $this$hasGetter.getGetter() != null && !($this$hasGetter.getGetter() instanceof FirDefaultPropertyGetter);
    }

    private final boolean hasSetter(FirProperty $this$hasSetter) {
        return $this$hasSetter.getSetter() != null && !($this$hasSetter.getSetter() instanceof FirDefaultPropertySetter);
    }

    private final void reportError(DiagnosticReporter $this$reportError, KtSourceElement source2, String target, CheckerContext context) {
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportError, (AbstractKtSourceElement)source2, FirErrors.INSTANCE.getINAPPLICABLE_LATEINIT_MODIFIER(), (Object)target, (DiagnosticContext)context, null, 16, null);
    }

    private static final boolean hasUnderlyingTypeForbiddenForLateinit$isForbiddenTypeForLateinit(FirSession $session, ConeKotlinType type2) {
        if (ConeBuiltinTypeUtilsKt.isPrimitiveOrNullablePrimitive(type2)) {
            return true;
        }
        if (INSTANCE.getHasNullableUpperBound(type2)) {
            return true;
        }
        if (FirHelpersKt.isSingleFieldValueClass(type2, $session)) {
            return FirInapplicableLateinitChecker.hasUnderlyingTypeForbiddenForLateinit$isForbiddenTypeForLateinit($session, FirHelpersKt.getInlineClassUnderlyingType(type2, $session));
        }
        return false;
    }
}

