/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtRealPsiSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.util.LightTreeUtilsKt;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsPackageDirectiveChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFileChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsPackageDirectiveChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsPackageDirectiveChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsPackageDirectiveChecker\n+ 2 FirSourceUtils.kt\norg/jetbrains/kotlin/fir/analysis/FirSourceUtilsKt\n+ 3 KtSourceElement.kt\norg/jetbrains/kotlin/KtSourceElementKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,42:1\n42#2,7:43\n64#2:50\n96#2,6:51\n66#2:57\n102#2:58\n49#2:59\n50#2:65\n105#2,5:66\n67#2:71\n110#2,2:74\n113#2:77\n69#2:78\n51#2,2:79\n80#2:81\n96#2,6:82\n82#2:88\n102#2:89\n53#2:97\n105#2,5:98\n83#2:103\n110#2,4:104\n85#2:108\n54#2:109\n797#3,5:60\n803#3,7:90\n229#4:72\n1863#5:73\n1864#5:76\n*S KotlinDebug\n*F\n+ 1 FirJsPackageDirectiveChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsPackageDirectiveChecker\n*L\n29#1:43,7\n29#1:50\n29#1:51,6\n29#1:57\n29#1:58\n29#1:59\n29#1:65\n29#1:66,5\n29#1:71\n29#1:74,2\n29#1:77\n29#1:78\n29#1:79,2\n29#1:81\n29#1:82,6\n29#1:88\n29#1:89\n29#1:97\n29#1:98,5\n29#1:103\n29#1:104,4\n29#1:108\n29#1:109\n29#1:60,5\n29#1:90,7\n29#1:72\n29#1:73\n29#1:76\n*E\n"})
public final class FirJsPackageDirectiveChecker
extends FirDeclarationChecker<FirFile> {
    @NotNull
    public static final FirJsPackageDirectiveChecker INSTANCE = new FirJsPackageDirectiveChecker();

    private FirJsPackageDirectiveChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirFile declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (UtilsKt.getPackageFqName(declaration).isRoot()) {
            return;
        }
        if (context.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsAllowInvalidCharsIdentifiersEscaping)) {
            return;
        }
        KtSourceElement ktSourceElement = declaration.getPackageDirective().getSource();
        if (ktSourceElement != null) {
            void $this$forEachChildOfType_u24default$iv;
            KtSourceElement ktSourceElement2 = ktSourceElement;
            Set<IElementType> types$iv = SetsKt.setOf(KtNodeTypes.REFERENCE_EXPRESSION);
            int depth$iv = -1;
            boolean reverse$iv = false;
            boolean $i$f$forEachChildOfType = false;
            void var9_9 = $this$forEachChildOfType_u24default$iv;
            if (var9_9 instanceof KtPsiSourceElement) {
                PsiElement $this$forEachChildOfType$iv$iv = ((KtPsiSourceElement)$this$forEachChildOfType_u24default$iv).getPsi();
                boolean $i$f$forEachChildOfType2 = false;
                boolean $i$f$forEachChildOfType3 = false;
                Object object = new Pair[]{TuplesKt.to($this$forEachChildOfType$iv$iv, 0)};
                List<Pair> stack$iv$iv$iv = CollectionsKt.mutableListOf(object);
                while (!((Collection)stack$iv$iv$iv).isEmpty()) {
                    void $this$forEach$iv$iv$iv$iv;
                    Iterable $this$butIf$iv$iv$iv$iv;
                    PsiElement it$iv$iv;
                    object = AddToStdlibKt.popLast(stack$iv$iv$iv);
                    Object element$iv$iv$iv = ((Pair)object).component1();
                    int currentDepth$iv$iv$iv = ((Number)((Pair)object).component2()).intValue();
                    if (currentDepth$iv$iv$iv != 0) {
                        PsiElement psiElement = (PsiElement)element$iv$iv$iv;
                        Set<IElementType> set = types$iv;
                        boolean bl = false;
                        IElementType iElementType = it$iv$iv.getNode().getElementType();
                        Intrinsics.checkNotNullExpressionValue(iElementType, "getElementType(...)");
                        if (set.contains(iElementType)) {
                            String name2;
                            KtPsiSourceElement ktPsiSourceElement;
                            PsiElement it$iv = (PsiElement)element$iv$iv$iv;
                            boolean bl2 = false;
                            PsiElement $this$toKtPsiSourceElement_u24default$iv$iv = it$iv;
                            KtSourceElementKind kind$iv$iv = KtRealSourceElementKind.INSTANCE;
                            boolean $i$f$toKtPsiSourceElement = false;
                            KtSourceElementKind ktSourceElementKind = kind$iv$iv;
                            if (ktSourceElementKind instanceof KtRealSourceElementKind) {
                                ktPsiSourceElement = new KtRealPsiSourceElement($this$toKtPsiSourceElement_u24default$iv$iv);
                            } else if (ktSourceElementKind instanceof KtFakeSourceElementKind) {
                                ktPsiSourceElement = new KtFakeSourceElement($this$toKtPsiSourceElement_u24default$iv$iv, (KtFakeSourceElementKind)kind$iv$iv);
                            } else {
                                throw new NoWhenBranchMatchedException();
                            }
                            KtSourceElement it = ktPsiSourceElement;
                            boolean bl3 = false;
                            Intrinsics.checkNotNullExpressionValue(KtPsiUtil.unquoteIdentifier(String.valueOf(KtSourceElementKt.getText(it))), "unquoteIdentifier(...)");
                            if (!Intrinsics.areEqual(FirJsHelpersKt.sanitizeName(name2), name2)) {
                                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getINVALID_CHARACTERS(), (Object)(name2 + " contains illegal characters"), (DiagnosticContext)context, null, 16, null);
                            }
                        }
                    }
                    if (currentDepth$iv$iv$iv == depth$iv) continue;
                    it$iv$iv = (PsiElement)element$iv$iv$iv;
                    boolean bl = false;
                    List list = SequencesKt.toList(PsiUtilsKt.getAllChildren(it$iv$iv));
                    boolean condition$iv$iv$iv$iv = true;
                    boolean $i$f$butIf22 = false;
                    void it$iv$iv$iv = $this$butIf$iv$iv$iv$iv;
                    boolean bl4 = false;
                    $this$butIf$iv$iv$iv$iv = CollectionsKt.asReversed(it$iv$iv$iv);
                    boolean $i$f$forEach = false;
                    Iterator $i$f$butIf22 = $this$forEach$iv$iv$iv$iv.iterator();
                    while ($i$f$butIf22.hasNext()) {
                        Object element$iv$iv$iv$iv;
                        Object child$iv$iv$iv = element$iv$iv$iv$iv = $i$f$butIf22.next();
                        boolean bl5 = false;
                        ((Collection)stack$iv$iv$iv).add(TuplesKt.to(child$iv$iv$iv, currentDepth$iv$iv$iv + 1));
                    }
                }
            } else if (var9_9 instanceof KtLightSourceElement) {
                LighterASTNode $this$forEachChildOfType$iv$iv = ((KtLightSourceElement)$this$forEachChildOfType_u24default$iv).getLighterASTNode();
                FlyweightCapableTreeStructure<LighterASTNode> treeStructure$iv$iv = ((KtLightSourceElement)$this$forEachChildOfType_u24default$iv).getTreeStructure();
                boolean $i$f$forEachChildOfType4 = false;
                boolean $i$f$forEachChildOfType5 = false;
                Object object = new Pair[]{TuplesKt.to($this$forEachChildOfType$iv$iv, 0)};
                List<Pair> stack$iv$iv$iv = CollectionsKt.mutableListOf(object);
                while (!((Collection)stack$iv$iv$iv).isEmpty()) {
                    void $this$forEach$iv$iv$iv$iv;
                    Iterable $this$butIf$iv$iv$iv$iv;
                    LighterASTNode it$iv$iv;
                    object = AddToStdlibKt.popLast(stack$iv$iv$iv);
                    Object element$iv$iv$iv = ((Pair)object).component1();
                    int currentDepth$iv$iv$iv = ((Number)((Pair)object).component2()).intValue();
                    if (currentDepth$iv$iv$iv != 0) {
                        LighterASTNode lighterASTNode = (LighterASTNode)element$iv$iv$iv;
                        Set<IElementType> set = types$iv;
                        boolean bl = false;
                        IElementType iElementType = it$iv$iv.getTokenType();
                        Intrinsics.checkNotNullExpressionValue(iElementType, "getTokenType(...)");
                        if (set.contains(iElementType)) {
                            String name3;
                            void $this$toKtLightSourceElement_u24default$iv$iv;
                            LighterASTNode it$iv = (LighterASTNode)element$iv$iv$iv;
                            boolean bl6 = false;
                            LighterASTNode kind$iv$iv = it$iv;
                            FlyweightCapableTreeStructure<LighterASTNode> tree$iv$iv = ((KtLightSourceElement)$this$forEachChildOfType_u24default$iv).getTreeStructure();
                            KtSourceElementKind kind$iv$iv2 = KtRealSourceElementKind.INSTANCE;
                            int startOffset$iv$iv = $this$toKtLightSourceElement_u24default$iv$iv.getStartOffset();
                            int endOffset$iv$iv = $this$toKtLightSourceElement_u24default$iv$iv.getEndOffset();
                            boolean $i$f$toKtLightSourceElement = false;
                            KtSourceElement it = new KtLightSourceElement((LighterASTNode)$this$toKtLightSourceElement_u24default$iv$iv, startOffset$iv$iv, endOffset$iv$iv, tree$iv$iv, kind$iv$iv2);
                            boolean bl7 = false;
                            Intrinsics.checkNotNullExpressionValue(KtPsiUtil.unquoteIdentifier(String.valueOf(KtSourceElementKt.getText(it))), "unquoteIdentifier(...)");
                            if (!Intrinsics.areEqual(FirJsHelpersKt.sanitizeName(name3), name3)) {
                                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getINVALID_CHARACTERS(), (Object)(name3 + " contains illegal characters"), (DiagnosticContext)context, null, 16, null);
                            }
                        }
                    }
                    if (currentDepth$iv$iv$iv == depth$iv) continue;
                    it$iv$iv = (LighterASTNode)element$iv$iv$iv;
                    boolean bl = false;
                    List<LighterASTNode> element$iv$iv$iv$iv = LightTreeUtilsKt.getChildren(it$iv$iv, treeStructure$iv$iv);
                    boolean condition$iv$iv$iv$iv = true;
                    boolean $i$f$butIf = false;
                    void it$iv$iv$iv = $this$butIf$iv$iv$iv$iv;
                    boolean bl8 = false;
                    $this$butIf$iv$iv$iv$iv = CollectionsKt.asReversed(it$iv$iv$iv);
                    boolean $i$f$forEach = false;
                    Iterator iterator2 = $this$forEach$iv$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object element$iv$iv$iv$iv2;
                        Object child$iv$iv$iv = element$iv$iv$iv$iv2 = iterator2.next();
                        boolean bl9 = false;
                        ((Collection)stack$iv$iv$iv).add(TuplesKt.to(child$iv$iv$iv, currentDepth$iv$iv$iv + 1));
                    }
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }
}

