/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression.FirJavaSamConstructorNullabilityChecker;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirReturnExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.SubstitutionUtilsKt;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirControlFlowGraphReference;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.dfa.FirControlFlowGraphReferenceImplKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.BlockExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.FinallyBlockEnterNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.FinallyBlockExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.JumpNode;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.scopes.impl.FirAbstractImportingScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.ImportedFromObjectOrStaticData;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJavaSamConstructorNullabilityChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "getReturnedExpressions", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnonymousFunctionExpression;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJavaSamConstructorNullabilityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJavaSamConstructorNullabilityChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJavaSamConstructorNullabilityChecker\n+ 2 declarationUtils.kt\norg/jetbrains/kotlin/fir/declarations/DeclarationUtilsKt\n+ 3 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,81:1\n96#2:82\n87#2,11:83\n57#3,4:94\n1#4:98\n1#4:109\n1611#5,9:99\n1863#5:108\n1864#5:110\n1620#5:111\n295#5,2:114\n15#6,2:112\n*S KotlinDebug\n*F\n+ 1 FirJavaSamConstructorNullabilityChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJavaSamConstructorNullabilityChecker\n*L\n35#1:82\n35#1:83,11\n37#1:94,4\n78#1:109\n78#1:99,9\n78#1:108\n78#1:110\n78#1:111\n71#1:114,2\n70#1:112,2\n*E\n"})
public final class FirJavaSamConstructorNullabilityChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirJavaSamConstructorNullabilityChecker INSTANCE = new FirJavaSamConstructorNullabilityChecker();

    private FirJavaSamConstructorNullabilityChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull FirFunctionCall expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (FirLanguageSettingsComponentKt.getLanguageVersionSettings(context.getSession()).supportsFeature(LanguageFeature.JavaTypeParameterDefaultRepresentationWithDNN)) {
            return;
        }
        FirNamedReference calleeReference = expression2.getCalleeReference();
        if (FirReferenceUtilsKt.isError(calleeReference)) {
            return;
        }
        FirFunctionSymbol firFunctionSymbol = FirReferenceUtilsKt.toResolvedFunctionSymbol$default(calleeReference, false, 1, null);
        if (firFunctionSymbol == null) {
            return;
        }
        FirFunctionSymbol symbol = firFunctionSymbol;
        if (!Intrinsics.areEqual(symbol.getOrigin(), FirDeclarationOrigin.SamConstructor.INSTANCE)) {
            return;
        }
        FirRegularClassSymbol firRegularClassSymbol = TypeUtilsKt.toRegularClassSymbol(symbol.getResolvedReturnType(), context.getSession());
        if (firRegularClassSymbol == null) return;
        FirBasedSymbol $this$isJavaOrEnhancement$iv = firRegularClassSymbol;
        boolean $i$f$isJavaOrEnhancement = false;
        FirDeclarationOrigin $this$isJavaOrEnhancement$iv$iv = $this$isJavaOrEnhancement$iv.getOrigin();
        boolean $i$f$isJavaOrEnhancement22 = false;
        if (!($this$isJavaOrEnhancement$iv$iv instanceof FirDeclarationOrigin.Java || Intrinsics.areEqual($this$isJavaOrEnhancement$iv$iv, FirDeclarationOrigin.Enhancement.INSTANCE))) {
            Object $i$f$isJavaOrEnhancement22 = $this$isJavaOrEnhancement$iv.getFir();
            if (!($i$f$isJavaOrEnhancement22 instanceof FirCallableDeclaration)) return;
            FirCallableDeclaration firCallableDeclaration = (FirCallableDeclaration)$i$f$isJavaOrEnhancement22;
            Object object = firCallableDeclaration;
            if (firCallableDeclaration == null) return;
            ImportedFromObjectOrStaticData<FirCallableDeclaration> importedFromObjectOrStaticData = FirAbstractImportingScopeKt.getImportedFromObjectOrStaticData(object);
            object = importedFromObjectOrStaticData;
            if (importedFromObjectOrStaticData == null) return;
            Object d = ((ImportedFromObjectOrStaticData)object).getOriginal();
            object = d;
            if (d == null) return;
            if (!DeclarationUtilsKt.isJavaOrEnhancement((FirDeclaration)object)) return;
            boolean bl = true;
            if (!bl) return;
        }
        boolean bl = true;
        if (!bl) return;
        boolean bl2 = true;
        if (!bl2) {
            return;
        }
        FirCall $this$resolvedArgumentMapping$iv = expression2;
        boolean $i$f$getResolvedArgumentMapping = false;
        FirArgumentList argumentList$iv = $this$resolvedArgumentMapping$iv.getArgumentList();
        if (!(argumentList$iv instanceof FirResolvedArgumentList)) return;
        LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = ((FirResolvedArgumentList)argumentList$iv).getMapping();
        Object object = linkedHashMap;
        if (linkedHashMap == null) return;
        Set<Map.Entry<FirExpression, FirValueParameter>> set = ((LinkedHashMap)object).entrySet();
        object = set;
        if (set == null) return;
        if ((object = (Map.Entry)CollectionsKt.singleOrNull((Iterable)object)) == null) {
            return;
        }
        Object object2 = object;
        Object k = object2.getKey();
        Intrinsics.checkNotNullExpressionValue(k, "component1(...)");
        FirExpression lambda2 = (FirExpression)k;
        Object v = object2.getValue();
        Intrinsics.checkNotNullExpressionValue(v, "component2(...)");
        FirValueParameter parameter = (FirValueParameter)v;
        if (!(lambda2 instanceof FirAnonymousFunctionExpression)) {
            return;
        }
        ConeKotlinType parameterFunctionType = FirTypeUtilsKt.getConeType(parameter.getReturnTypeRef());
        ConeSubstitutor substitutor2 = SubstitutionUtilsKt.createConeSubstitutorFromTypeArguments$default(expression2, symbol, context.getSession(), false, true, 4, null);
        ConeTypeProjection coneTypeProjection = ArraysKt.lastOrNull(parameterFunctionType.getTypeArguments());
        ConeTypeProjection coneTypeProjection2 = coneTypeProjection;
        if (coneTypeProjection == null) return;
        ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType(coneTypeProjection2);
        coneTypeProjection2 = coneKotlinType;
        if (coneKotlinType == null) return;
        ConeTypeProjection p0 = coneTypeProjection2;
        boolean bl3 = false;
        ConeKotlinType coneKotlinType2 = substitutor2.substituteOrSelf((ConeKotlinType)p0);
        coneTypeProjection2 = coneKotlinType2;
        if (coneKotlinType2 == null) {
            return;
        }
        ConeTypeProjection expectedReturnType = coneTypeProjection2;
        Iterator<FirExpression> iterator2 = this.getReturnedExpressions((FirAnonymousFunctionExpression)lambda2).iterator();
        while (iterator2.hasNext()) {
            FirExpression returnedExpression = iterator2.next();
            ConeKotlinType returnedExpressionType = FirTypeUtilsKt.getResolvedType(returnedExpression);
            if (AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, TypeComponentsKt.getTypeContext(context.getSession()), (KotlinTypeMarker)returnedExpressionType, (KotlinTypeMarker)((Object)expectedReturnType), false, 8, null)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)returnedExpression.getSource(), FirJvmErrors.INSTANCE.getTYPE_MISMATCH_WHEN_FLEXIBILITY_CHANGES(), (Object)expectedReturnType, (Object)returnedExpressionType, (DiagnosticContext)context, null, 32, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirExpression> getReturnedExpressions(FirAnonymousFunctionExpression $this$getReturnedExpressions) {
        void $this$mapNotNullTo$iv$iv;
        Object object = $this$getReturnedExpressions.getAnonymousFunction().getControlFlowGraphReference();
        if (object == null || (object = FirControlFlowGraphReferenceImplKt.getControlFlowGraph((FirControlFlowGraphReference)object)) == null || (object = ((ControlFlowGraph)object).getExitNode()) == null) {
            return CollectionsKt.emptyList();
        }
        CFGNode<?> exitNode = object;
        Iterable $this$mapNotNull$iv = exitNode.getPreviousNodes();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FirExpression it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            CFGNode p0 = (CFGNode)element$iv$iv;
            boolean bl2 = false;
            if (FirJavaSamConstructorNullabilityChecker.getReturnedExpressions$extractReturnedExpression(exitNode, p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final FirExpression getReturnedExpressions$extractReturnedExpression(CFGNode<?> exitNode, CFGNode<?> it) {
        FirExpression firExpression;
        CFGNode<?> cFGNode = it;
        if (cFGNode instanceof JumpNode) {
            FirElement firElement = ((JumpNode)it).getFir();
            FirReturnExpression firReturnExpression = firElement instanceof FirReturnExpression ? (FirReturnExpression)firElement : null;
            firExpression = firReturnExpression != null ? firReturnExpression.getResult() : null;
        } else if (cFGNode instanceof BlockExitNode) {
            FirStatement firStatement = CollectionsKt.lastOrNull(((BlockExitNode)it).getFir().getStatements());
            FirReturnExpression firReturnExpression = firStatement instanceof FirReturnExpression ? (FirReturnExpression)firStatement : null;
            firExpression = firReturnExpression != null ? firReturnExpression.getResult() : null;
        } else if (cFGNode instanceof FinallyBlockExitNode) {
            CFGNode<Object> cFGNode2;
            block12: {
                CFGNode<?> cFGNode3;
                CFGNode<Object> element$iv;
                Iterator<CFGNode<Object>> iterator2;
                block11: {
                    Sequence<CFGNode<?>> $this$firstIsInstanceOrNull$iv = SequencesKt.generateSequence(it, (Function1)getReturnedExpressions.extractReturnedExpression.finallyBlockEnterNode.1.INSTANCE);
                    boolean $i$f$firstIsInstanceOrNull = false;
                    iterator2 = $this$firstIsInstanceOrNull$iv.iterator();
                    while (iterator2.hasNext()) {
                        element$iv = iterator2.next();
                        if (!(element$iv instanceof FinallyBlockEnterNode)) continue;
                        cFGNode3 = element$iv;
                        break block11;
                    }
                    cFGNode3 = null;
                }
                FinallyBlockEnterNode finallyBlockEnterNode2 = (FinallyBlockEnterNode)cFGNode3;
                if (finallyBlockEnterNode2 == null) {
                    return null;
                }
                FinallyBlockEnterNode finallyBlockEnterNode3 = finallyBlockEnterNode2;
                Iterable $this$firstOrNull$iv = finallyBlockEnterNode3.getPreviousNodes();
                boolean $i$f$firstOrNull = false;
                iterator2 = $this$firstOrNull$iv.iterator();
                while (iterator2.hasNext()) {
                    CFGNode<Object> x = element$iv = iterator2.next();
                    boolean bl = false;
                    if (!Intrinsics.areEqual(finallyBlockEnterNode3.edgeFrom(x), exitNode.edgeFrom(it))) continue;
                    cFGNode2 = element$iv;
                    break block12;
                }
                cFGNode2 = null;
            }
            CFGNode cFGNode4 = cFGNode2;
            if (cFGNode4 != null) {
                CFGNode p0 = cFGNode4;
                boolean bl = false;
                firExpression = FirJavaSamConstructorNullabilityChecker.getReturnedExpressions$extractReturnedExpression(exitNode, p0);
            } else {
                firExpression = null;
            }
        } else {
            firExpression = null;
        }
        return firExpression;
    }
}

