/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.declarations.comparators;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirConstructedClassTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirOuterClassTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRefComparator;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u0018\u0010\u0006\u001a\u00020\u0007*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/comparators/FirTypeParameterRefComparator;", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameterRef;", "Lkotlin/Comparator;", "<init>", "()V", "priority", "", "getPriority", "(Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameterRef;)I", "compare", "a", "b", "tree"})
public final class FirTypeParameterRefComparator
implements Comparator<FirTypeParameterRef> {
    @NotNull
    public static final FirTypeParameterRefComparator INSTANCE = new FirTypeParameterRefComparator();

    private FirTypeParameterRefComparator() {
    }

    private final int getPriority(FirTypeParameterRef $this$priority) {
        FirTypeParameterRef firTypeParameterRef = $this$priority;
        return firTypeParameterRef instanceof FirConstructedClassTypeParameterRef ? 3 : (firTypeParameterRef instanceof FirOuterClassTypeParameterRef ? 2 : (firTypeParameterRef instanceof FirTypeParameter ? 1 : 0));
    }

    @Override
    public int compare(@NotNull FirTypeParameterRef a2, @NotNull FirTypeParameterRef b2) {
        Intrinsics.checkNotNullParameter(a2, "a");
        Intrinsics.checkNotNullParameter(b2, "b");
        int priorityDiff = this.getPriority(a2) - this.getPriority(b2);
        if (priorityDiff != 0) {
            return priorityDiff;
        }
        FirTypeParameterRef firTypeParameterRef = a2;
        if (firTypeParameterRef instanceof FirConstructedClassTypeParameterRef) {
            if (!(b2 instanceof FirConstructedClassTypeParameterRef)) {
                boolean $i$a$-require-FirTypeParameterRefComparator$compare$42 = false;
                String $i$a$-require-FirTypeParameterRefComparator$compare$42 = "priority is inconsistent: " + UtilsKt.render(a2) + " v.s. " + UtilsKt.render(b2);
                throw new IllegalArgumentException($i$a$-require-FirTypeParameterRefComparator$compare$42.toString());
            }
            return ((FirConstructedClassTypeParameterRef)a2).getSymbol().getName().compareTo(((FirConstructedClassTypeParameterRef)b2).getSymbol().getName());
        }
        if (firTypeParameterRef instanceof FirOuterClassTypeParameterRef) {
            if (!(b2 instanceof FirOuterClassTypeParameterRef)) {
                boolean $i$a$-require-FirTypeParameterRefComparator$compare$52 = false;
                String $i$a$-require-FirTypeParameterRefComparator$compare$52 = "priority is inconsistent: " + UtilsKt.render(a2) + " v.s. " + UtilsKt.render(b2);
                throw new IllegalArgumentException($i$a$-require-FirTypeParameterRefComparator$compare$52.toString());
            }
            return ((FirOuterClassTypeParameterRef)a2).getSymbol().getName().compareTo(((FirOuterClassTypeParameterRef)b2).getSymbol().getName());
        }
        if (firTypeParameterRef instanceof FirTypeParameter) {
            if (!(b2 instanceof FirTypeParameter)) {
                boolean $i$a$-require-FirTypeParameterRefComparator$compare$62 = false;
                String $i$a$-require-FirTypeParameterRefComparator$compare$62 = "priority is inconsistent: " + UtilsKt.render(a2) + " v.s. " + UtilsKt.render(b2);
                throw new IllegalArgumentException($i$a$-require-FirTypeParameterRefComparator$compare$62.toString());
            }
            int nameDiff = ((FirTypeParameter)a2).getSymbol().getName().compareTo(((FirTypeParameter)b2).getSymbol().getName());
            if (nameDiff != 0) {
                return nameDiff;
            }
            int varianceDiff = ((FirTypeParameter)a2).getVariance().ordinal() - ((FirTypeParameter)b2).getVariance().ordinal();
            if (varianceDiff != 0) {
                return varianceDiff;
            }
            int boundsSizeDiff = ((FirTypeParameter)a2).getBounds().size() - ((FirTypeParameter)b2).getBounds().size();
            if (boundsSizeDiff != 0) {
                return boundsSizeDiff;
            }
            for (Pair pair : CollectionsKt.zip((Iterable)((FirTypeParameter)a2).getBounds(), (Iterable)((FirTypeParameter)b2).getBounds())) {
                FirTypeRef bBound;
                FirTypeRef aBound = (FirTypeRef)pair.component1();
                int boundDiff = FirTypeRefComparator.INSTANCE.compare(aBound, bBound = (FirTypeRef)pair.component2());
                if (boundDiff == 0) continue;
                return boundDiff;
            }
            return 0;
        }
        throw new IllegalStateException(("Unsupported type parameter reference comparison: " + UtilsKt.render(a2) + " v.s. " + UtilsKt.render(b2)).toString());
    }
}

