/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.booleans;

import java.io.Serializable;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Arrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Hash;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.booleans.BooleanComparator;

public final class BooleanArrays {
    public static final boolean[] EMPTY_ARRAY = new boolean[0];
    public static final boolean[] DEFAULT_EMPTY_ARRAY = new boolean[0];
    public static final Hash.Strategy<boolean[]> HASH_STRATEGY = new ArrayHashStrategy();

    public static void ensureOffsetLength(boolean[] a2, int offset2, int length) {
        Arrays.ensureOffsetLength(a2.length, offset2, length);
    }

    public static void swap(boolean[] x, int a2, int b2) {
        boolean t = x[a2];
        x[a2] = x[b2];
        x[b2] = t;
    }

    public static void swap(boolean[] x, int a2, int b2, int n) {
        int i2 = 0;
        while (i2 < n) {
            BooleanArrays.swap(x, a2, b2);
            ++i2;
            ++a2;
            ++b2;
        }
    }

    private static int med3(boolean[] x, int a2, int b2, int c, BooleanComparator comp) {
        int ab = comp.compare(x[a2], x[b2]);
        int ac = comp.compare(x[a2], x[c]);
        int bc = comp.compare(x[b2], x[c]);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c : a2)) : (bc > 0 ? b2 : (ac > 0 ? c : a2));
    }

    private static void selectionSort(boolean[] a2, int from2, int to, BooleanComparator comp) {
        for (int i2 = from2; i2 < to - 1; ++i2) {
            int m = i2;
            for (int j = i2 + 1; j < to; ++j) {
                if (comp.compare(a2[j], a2[m]) >= 0) continue;
                m = j;
            }
            if (m == i2) continue;
            boolean u = a2[i2];
            a2[i2] = a2[m];
            a2[m] = u;
        }
    }

    private static void insertionSort(boolean[] a2, int from2, int to, BooleanComparator comp) {
        int i2 = from2;
        while (++i2 < to) {
            boolean t = a2[i2];
            int j = i2;
            boolean u = a2[j - 1];
            while (comp.compare(t, u) < 0) {
                a2[j] = u;
                if (from2 == j - 1) {
                    --j;
                    break;
                }
                u = a2[--j - 1];
            }
            a2[j] = t;
        }
    }

    public static void quickSort(boolean[] x, int from2, int to, BooleanComparator comp) {
        int c;
        int a2;
        int len = to - from2;
        if (len < 16) {
            BooleanArrays.selectionSort(x, from2, to, comp);
            return;
        }
        int m = from2 + len / 2;
        int l = from2;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = BooleanArrays.med3(x, l, l + s, l + 2 * s, comp);
            m = BooleanArrays.med3(x, m - s, m, m + s, comp);
            n = BooleanArrays.med3(x, n - 2 * s, n - s, n, comp);
        }
        m = BooleanArrays.med3(x, l, m, n, comp);
        boolean v = x[m];
        int b2 = a2 = from2;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c && (comparison = comp.compare(x[b2], v)) <= 0) {
                if (comparison == 0) {
                    BooleanArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c >= b2 && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    BooleanArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b2 > c) break;
            BooleanArrays.swap(x, b2++, c--);
        }
        int s = Math.min(a2 - from2, b2 - a2);
        BooleanArrays.swap(x, from2, b2 - s, s);
        s = Math.min(d - c, to - d - 1);
        BooleanArrays.swap(x, b2, to - s, s);
        s = b2 - a2;
        if (s > 1) {
            BooleanArrays.quickSort(x, from2, from2 + s, comp);
        }
        if ((s = d - c) > 1) {
            BooleanArrays.quickSort(x, to - s, to, comp);
        }
    }

    private static int med3(boolean[] x, int a2, int b2, int c) {
        int ab = Boolean.compare(x[a2], x[b2]);
        int ac = Boolean.compare(x[a2], x[c]);
        int bc = Boolean.compare(x[b2], x[c]);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c : a2)) : (bc > 0 ? b2 : (ac > 0 ? c : a2));
    }

    private static void selectionSort(boolean[] a2, int from2, int to) {
        for (int i2 = from2; i2 < to - 1; ++i2) {
            int m = i2;
            for (int j = i2 + 1; j < to; ++j) {
                if (a2[j] || !a2[m]) continue;
                m = j;
            }
            if (m == i2) continue;
            boolean u = a2[i2];
            a2[i2] = a2[m];
            a2[m] = u;
        }
    }

    public static void quickSort(boolean[] x, int from2, int to) {
        int c;
        int a2;
        int len = to - from2;
        if (len < 16) {
            BooleanArrays.selectionSort(x, from2, to);
            return;
        }
        int m = from2 + len / 2;
        int l = from2;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = BooleanArrays.med3(x, l, l + s, l + 2 * s);
            m = BooleanArrays.med3(x, m - s, m, m + s);
            n = BooleanArrays.med3(x, n - 2 * s, n - s, n);
        }
        m = BooleanArrays.med3(x, l, m, n);
        boolean v = x[m];
        int b2 = a2 = from2;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c && (comparison = Boolean.compare(x[b2], v)) <= 0) {
                if (comparison == 0) {
                    BooleanArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c >= b2 && (comparison = Boolean.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    BooleanArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b2 > c) break;
            BooleanArrays.swap(x, b2++, c--);
        }
        int s = Math.min(a2 - from2, b2 - a2);
        BooleanArrays.swap(x, from2, b2 - s, s);
        s = Math.min(d - c, to - d - 1);
        BooleanArrays.swap(x, b2, to - s, s);
        s = b2 - a2;
        if (s > 1) {
            BooleanArrays.quickSort(x, from2, from2 + s);
        }
        if ((s = d - c) > 1) {
            BooleanArrays.quickSort(x, to - s, to);
        }
    }

    public static void unstableSort(boolean[] a2, int from2, int to) {
        BooleanArrays.quickSort(a2, from2, to);
    }

    public static void unstableSort(boolean[] a2) {
        BooleanArrays.unstableSort(a2, 0, a2.length);
    }

    public static void unstableSort(boolean[] a2, int from2, int to, BooleanComparator comp) {
        BooleanArrays.quickSort(a2, from2, to, comp);
    }

    public static void unstableSort(boolean[] a2, BooleanComparator comp) {
        BooleanArrays.unstableSort(a2, 0, a2.length, comp);
    }

    public static void mergeSort(boolean[] a2, int from2, int to, BooleanComparator comp, boolean[] supp) {
        int len = to - from2;
        if (len < 16) {
            BooleanArrays.insertionSort(a2, from2, to, comp);
            return;
        }
        if (supp == null) {
            supp = java.util.Arrays.copyOf(a2, to);
        }
        int mid = from2 + to >>> 1;
        BooleanArrays.mergeSort(supp, from2, mid, comp, a2);
        BooleanArrays.mergeSort(supp, mid, to, comp, a2);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from2, a2, from2, len);
            return;
        }
        int p2 = from2;
        int q2 = mid;
        for (int i2 = from2; i2 < to; ++i2) {
            a2[i2] = q2 >= to || p2 < mid && comp.compare(supp[p2], supp[q2]) <= 0 ? supp[p2++] : supp[q2++];
        }
    }

    public static void mergeSort(boolean[] a2, int from2, int to, BooleanComparator comp) {
        BooleanArrays.mergeSort(a2, from2, to, comp, null);
    }

    public static void stableSort(boolean[] a2, int from2, int to, BooleanComparator comp) {
        BooleanArrays.mergeSort(a2, from2, to, comp);
    }

    public static void stableSort(boolean[] a2, BooleanComparator comp) {
        BooleanArrays.stableSort(a2, 0, a2.length, comp);
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<boolean[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(boolean[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(boolean[] a2, boolean[] b2) {
            return java.util.Arrays.equals(a2, b2);
        }
    }
}

