/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Arrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.AbstractByteList;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteArrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteComparator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteConsumer;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteIterators;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteList;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteListIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteSpliterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteSpliterators;

public class ByteArrayList
extends AbstractByteList
implements Serializable,
Cloneable,
RandomAccess {
    private static final long serialVersionUID = -7046029254386353130L;
    protected transient byte[] a;
    protected int size;

    private static final byte[] copyArraySafe(byte[] a2, int length) {
        if (length == 0) {
            return ByteArrays.EMPTY_ARRAY;
        }
        return java.util.Arrays.copyOf(a2, length);
    }

    protected ByteArrayList(byte[] a2, boolean wrapped) {
        this.a = a2;
    }

    public ByteArrayList() {
        this.a = ByteArrays.DEFAULT_EMPTY_ARRAY;
    }

    private void grow(int capacity) {
        if (capacity <= this.a.length) {
            return;
        }
        if (this.a != ByteArrays.DEFAULT_EMPTY_ARRAY) {
            capacity = (int)Math.max(Math.min((long)this.a.length + (long)(this.a.length >> 1), 0x7FFFFFF7L), (long)capacity);
        } else if (capacity < 10) {
            capacity = 10;
        }
        this.a = ByteArrays.forceCapacity(this.a, capacity, this.size);
        assert (this.size <= this.a.length);
    }

    @Override
    public void add(int index, byte k) {
        this.ensureIndex(index);
        this.grow(this.size + 1);
        if (index != this.size) {
            System.arraycopy(this.a, index, this.a, index + 1, this.size - index);
        }
        this.a[index] = k;
        ++this.size;
        assert (this.size <= this.a.length);
    }

    @Override
    public boolean add(byte k) {
        this.grow(this.size + 1);
        this.a[this.size++] = k;
        assert (this.size <= this.a.length);
        return true;
    }

    @Override
    public byte getByte(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        return this.a[index];
    }

    @Override
    public int indexOf(byte k) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (k != this.a[i2]) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(byte k) {
        int i2 = this.size;
        while (i2-- != 0) {
            if (k != this.a[i2]) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public byte removeByte(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        byte old = this.a[index];
        --this.size;
        if (index != this.size) {
            System.arraycopy(this.a, index + 1, this.a, index, this.size - index);
        }
        assert (this.size <= this.a.length);
        return old;
    }

    @Override
    public boolean rem(byte k) {
        int index = this.indexOf(k);
        if (index == -1) {
            return false;
        }
        this.removeByte(index);
        assert (this.size <= this.a.length);
        return true;
    }

    @Override
    public byte set(int index, byte k) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        byte old = this.a[index];
        this.a[index] = k;
        return old;
    }

    @Override
    public void clear() {
        this.size = 0;
        assert (this.size <= this.a.length);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public ByteList subList(int from2, int to) {
        if (from2 == 0 && to == this.size()) {
            return this;
        }
        this.ensureIndex(from2);
        this.ensureIndex(to);
        if (from2 > to) {
            throw new IndexOutOfBoundsException("Start index (" + from2 + ") is greater than end index (" + to + ")");
        }
        return new SubList(from2, to);
    }

    @Override
    public void getElements(int from2, byte[] a2, int offset2, int length) {
        ByteArrays.ensureOffsetLength(a2, offset2, length);
        System.arraycopy(this.a, from2, a2, offset2, length);
    }

    @Override
    public void removeElements(int from2, int to) {
        Arrays.ensureFromTo(this.size, from2, to);
        System.arraycopy(this.a, to, this.a, from2, this.size - to);
        this.size -= to - from2;
    }

    @Override
    public void setElements(int index, byte[] a2, int offset2, int length) {
        this.ensureIndex(index);
        ByteArrays.ensureOffsetLength(a2, offset2, length);
        if (index + length > this.size) {
            throw new IndexOutOfBoundsException("End index (" + (index + length) + ") is greater than list size (" + this.size + ")");
        }
        System.arraycopy(a2, offset2, this.a, index, length);
    }

    @Override
    public void forEach(ByteConsumer action) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            action.accept(this.a[i2]);
        }
    }

    @Override
    public boolean addAll(int index, ByteCollection c) {
        if (c instanceof ByteList) {
            return this.addAll(index, (ByteList)c);
        }
        this.ensureIndex(index);
        int n = c.size();
        if (n == 0) {
            return false;
        }
        this.grow(this.size + n);
        System.arraycopy(this.a, index, this.a, index + n, this.size - index);
        ByteIterator i2 = c.iterator();
        this.size += n;
        while (n-- != 0) {
            this.a[index++] = i2.nextByte();
        }
        assert (this.size <= this.a.length);
        return true;
    }

    public boolean addAll(int index, ByteList l) {
        this.ensureIndex(index);
        int n = l.size();
        if (n == 0) {
            return false;
        }
        this.grow(this.size + n);
        System.arraycopy(this.a, index, this.a, index + n, this.size - index);
        l.getElements(0, this.a, index, n);
        this.size += n;
        assert (this.size <= this.a.length);
        return true;
    }

    @Override
    public boolean removeAll(ByteCollection c) {
        byte[] a2 = this.a;
        int j = 0;
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (c.contains(a2[i2])) continue;
            a2[j++] = a2[i2];
        }
        boolean modified = this.size != j;
        this.size = j;
        return modified;
    }

    @Override
    public byte[] toArray(byte[] a2) {
        if (a2 == null || a2.length < this.size) {
            a2 = java.util.Arrays.copyOf(a2, this.size);
        }
        System.arraycopy(this.a, 0, a2, 0, this.size);
        return a2;
    }

    @Override
    public ByteListIterator listIterator(final int index) {
        this.ensureIndex(index);
        return new ByteListIterator(){
            int pos;
            int last;
            {
                this.pos = index;
                this.last = -1;
            }

            @Override
            public boolean hasNext() {
                return this.pos < ByteArrayList.this.size;
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > 0;
            }

            @Override
            public byte nextByte() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return ByteArrayList.this.a[this.last];
            }

            @Override
            public byte previousByte() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return ByteArrayList.this.a[this.pos];
            }

            @Override
            public int nextIndex() {
                return this.pos;
            }

            @Override
            public int previousIndex() {
                return this.pos - 1;
            }

            @Override
            public void add(byte k) {
                ByteArrayList.this.add(this.pos++, k);
                this.last = -1;
            }

            @Override
            public void set(byte k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                ByteArrayList.this.set(this.last, k);
            }

            @Override
            public void remove() {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                ByteArrayList.this.removeByte(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1;
            }

            @Override
            public void forEachRemaining(ByteConsumer action) {
                while (this.pos < ByteArrayList.this.size) {
                    ++this.pos;
                    this.last = this.last;
                    action.accept(ByteArrayList.this.a[this.last]);
                }
            }
        };
    }

    @Override
    public ByteSpliterator spliterator() {
        return new Spliterator();
    }

    @Override
    public void sort(ByteComparator comp) {
        if (comp == null) {
            ByteArrays.stableSort(this.a, 0, this.size);
        } else {
            ByteArrays.stableSort(this.a, 0, this.size, comp);
        }
    }

    @Override
    public void unstableSort(ByteComparator comp) {
        if (comp == null) {
            ByteArrays.unstableSort(this.a, 0, this.size);
        } else {
            ByteArrays.unstableSort(this.a, 0, this.size, comp);
        }
    }

    public ByteArrayList clone() {
        ByteArrayList cloned = null;
        if (this.getClass() == ByteArrayList.class) {
            cloned = new ByteArrayList(ByteArrayList.copyArraySafe(this.a, this.size), false);
            cloned.size = this.size;
        } else {
            try {
                cloned = (ByteArrayList)super.clone();
            }
            catch (CloneNotSupportedException err) {
                throw new InternalError(err);
            }
            cloned.a = ByteArrayList.copyArraySafe(this.a, this.size);
        }
        return cloned;
    }

    public boolean equals(ByteArrayList l) {
        if (l == this) {
            return true;
        }
        int s = this.size();
        if (s != l.size()) {
            return false;
        }
        byte[] a1 = this.a;
        byte[] a2 = l.a;
        if (a1 == a2 && s == l.size()) {
            return true;
        }
        while (s-- != 0) {
            if (a1[s] == a2[s]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof List)) {
            return false;
        }
        if (o instanceof ByteArrayList) {
            return this.equals((ByteArrayList)o);
        }
        if (o instanceof SubList) {
            return ((SubList)o).equals(this);
        }
        return super.equals(o);
    }

    @Override
    public int compareTo(ByteArrayList l) {
        int i2;
        int s1 = this.size();
        int s2 = l.size();
        byte[] a1 = this.a;
        byte[] a2 = l.a;
        if (a1 == a2 && s1 == s2) {
            return 0;
        }
        for (i2 = 0; i2 < s1 && i2 < s2; ++i2) {
            byte e1 = a1[i2];
            byte e2 = a2[i2];
            int r = Byte.compare(e1, e2);
            if (r == 0) continue;
            return r;
        }
        return i2 < s2 ? -1 : (i2 < s1 ? 1 : 0);
    }

    @Override
    public int compareTo(List<? extends Byte> l) {
        if (l instanceof ByteArrayList) {
            return this.compareTo((ByteArrayList)l);
        }
        if (l instanceof SubList) {
            return -((SubList)l).compareTo(this);
        }
        return super.compareTo(l);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        for (int i2 = 0; i2 < this.size; ++i2) {
            s.writeByte(this.a[i2]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.a = new byte[this.size];
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.a[i2] = s.readByte();
        }
    }

    private class SubList
    extends AbstractByteList.ByteRandomAccessSubList {
        private static final long serialVersionUID = -3185226345314976296L;

        protected SubList(int from2, int to) {
            super(ByteArrayList.this, from2, to);
        }

        private byte[] getParentArray() {
            return ByteArrayList.this.a;
        }

        @Override
        public byte getByte(int i2) {
            this.ensureRestrictedIndex(i2);
            return ByteArrayList.this.a[i2 + this.from];
        }

        @Override
        public ByteListIterator listIterator(int index) {
            return new SubListIterator(index);
        }

        @Override
        public ByteSpliterator spliterator() {
            return new SubListSpliterator();
        }

        boolean contentsEquals(byte[] otherA, int otherAFrom, int otherATo) {
            if (ByteArrayList.this.a == otherA && this.from == otherAFrom && this.to == otherATo) {
                return true;
            }
            if (otherATo - otherAFrom != this.size()) {
                return false;
            }
            int pos = this.from;
            int otherPos = otherAFrom;
            while (pos < this.to) {
                if (ByteArrayList.this.a[pos++] == otherA[otherPos++]) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof List)) {
                return false;
            }
            if (o instanceof ByteArrayList) {
                ByteArrayList other = (ByteArrayList)o;
                return this.contentsEquals(other.a, 0, other.size());
            }
            if (o instanceof SubList) {
                SubList other = (SubList)o;
                return this.contentsEquals(other.getParentArray(), other.from, other.to);
            }
            return super.equals(o);
        }

        int contentsCompareTo(byte[] otherA, int otherAFrom, int otherATo) {
            if (ByteArrayList.this.a == otherA && this.from == otherAFrom && this.to == otherATo) {
                return 0;
            }
            int i2 = this.from;
            int j = otherAFrom;
            while (i2 < this.to && i2 < otherATo) {
                byte e1 = ByteArrayList.this.a[i2];
                byte e2 = otherA[j];
                int r = Byte.compare(e1, e2);
                if (r != 0) {
                    return r;
                }
                ++i2;
                ++j;
            }
            return i2 < otherATo ? -1 : (i2 < this.to ? 1 : 0);
        }

        @Override
        public int compareTo(List<? extends Byte> l) {
            if (l instanceof ByteArrayList) {
                ByteArrayList other = (ByteArrayList)l;
                return this.contentsCompareTo(other.a, 0, other.size());
            }
            if (l instanceof SubList) {
                SubList other = (SubList)l;
                return this.contentsCompareTo(other.getParentArray(), other.from, other.to);
            }
            return super.compareTo(l);
        }

        private final class SubListIterator
        extends ByteIterators.AbstractIndexBasedListIterator {
            SubListIterator(int index) {
                super(0, index);
            }

            @Override
            protected final byte get(int i2) {
                return ByteArrayList.this.a[SubList.this.from + i2];
            }

            @Override
            protected final void add(int i2, byte k) {
                SubList.this.add(i2, k);
            }

            @Override
            protected final void set(int i2, byte k) {
                SubList.this.set(i2, k);
            }

            @Override
            protected final void remove(int i2) {
                SubList.this.removeByte(i2);
            }

            @Override
            protected final int getMaxPos() {
                return SubList.this.to - SubList.this.from;
            }

            @Override
            public byte nextByte() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.pos++;
                return ByteArrayList.this.a[SubList.this.from + this.lastReturned];
            }

            @Override
            public byte previousByte() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = --this.pos;
                return ByteArrayList.this.a[SubList.this.from + this.pos];
            }

            @Override
            public void forEachRemaining(ByteConsumer action) {
                int max = SubList.this.to - SubList.this.from;
                while (this.pos < max) {
                    ++this.pos;
                    this.lastReturned = this.lastReturned;
                    action.accept(ByteArrayList.this.a[SubList.this.from + this.lastReturned]);
                }
            }
        }

        private final class SubListSpliterator
        extends ByteSpliterators.LateBindingSizeIndexBasedSpliterator {
            SubListSpliterator() {
                super(SubList.this.from);
            }

            private SubListSpliterator(int pos, int maxPos) {
                super(pos, maxPos);
            }

            @Override
            protected final int getMaxPosFromBackingStore() {
                return SubList.this.to;
            }

            @Override
            protected final byte get(int i2) {
                return ByteArrayList.this.a[i2];
            }

            @Override
            protected final SubListSpliterator makeForSplit(int pos, int maxPos) {
                return new SubListSpliterator(pos, maxPos);
            }

            @Override
            public boolean tryAdvance(ByteConsumer action) {
                if (this.pos >= this.getMaxPos()) {
                    return false;
                }
                action.accept(ByteArrayList.this.a[this.pos++]);
                return true;
            }

            @Override
            public void forEachRemaining(ByteConsumer action) {
                int max = this.getMaxPos();
                while (this.pos < max) {
                    action.accept(ByteArrayList.this.a[this.pos++]);
                }
            }
        }
    }

    private final class Spliterator
    implements ByteSpliterator {
        boolean hasSplit = false;
        int pos;
        int max;

        public Spliterator() {
            this(0, byteArrayList.size, false);
        }

        private Spliterator(int pos, int max, boolean hasSplit) {
            assert (pos <= max) : "pos " + pos + " must be <= max " + max;
            this.pos = pos;
            this.max = max;
            this.hasSplit = hasSplit;
        }

        private int getWorkingMax() {
            return this.hasSplit ? this.max : ByteArrayList.this.size;
        }

        @Override
        public int characteristics() {
            return 16720;
        }

        @Override
        public long estimateSize() {
            return this.getWorkingMax() - this.pos;
        }

        @Override
        public boolean tryAdvance(ByteConsumer action) {
            if (this.pos >= this.getWorkingMax()) {
                return false;
            }
            action.accept(ByteArrayList.this.a[this.pos++]);
            return true;
        }

        @Override
        public void forEachRemaining(ByteConsumer action) {
            int max = this.getWorkingMax();
            while (this.pos < max) {
                action.accept(ByteArrayList.this.a[this.pos]);
                ++this.pos;
            }
        }

        @Override
        public ByteSpliterator trySplit() {
            int myNewPos;
            int max = this.getWorkingMax();
            int retLen = max - this.pos >> 1;
            if (retLen <= 1) {
                return null;
            }
            this.max = max;
            int retMax = myNewPos = this.pos + retLen;
            int oldPos = this.pos;
            this.pos = myNewPos;
            this.hasSplit = true;
            return new Spliterator(oldPos, retMax, true);
        }
    }
}

