/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes;

import java.io.Serializable;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Arrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Hash;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteComparator;

public final class ByteArrays {
    public static final byte[] EMPTY_ARRAY = new byte[0];
    public static final byte[] DEFAULT_EMPTY_ARRAY = new byte[0];
    protected static final Segment POISON_PILL = new Segment(-1, -1, -1);
    public static final Hash.Strategy<byte[]> HASH_STRATEGY = new ArrayHashStrategy();

    public static byte[] forceCapacity(byte[] array, int length, int preserve) {
        byte[] t = new byte[length];
        System.arraycopy(array, 0, t, 0, preserve);
        return t;
    }

    public static byte[] copy(byte[] array) {
        return (byte[])array.clone();
    }

    public static void ensureOffsetLength(byte[] a2, int offset2, int length) {
        Arrays.ensureOffsetLength(a2.length, offset2, length);
    }

    public static void swap(byte[] x, int a2, int b2) {
        byte t = x[a2];
        x[a2] = x[b2];
        x[b2] = t;
    }

    public static void swap(byte[] x, int a2, int b2, int n) {
        int i2 = 0;
        while (i2 < n) {
            ByteArrays.swap(x, a2, b2);
            ++i2;
            ++a2;
            ++b2;
        }
    }

    private static int med3(byte[] x, int a2, int b2, int c, ByteComparator comp) {
        int ab = comp.compare(x[a2], x[b2]);
        int ac = comp.compare(x[a2], x[c]);
        int bc = comp.compare(x[b2], x[c]);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c : a2)) : (bc > 0 ? b2 : (ac > 0 ? c : a2));
    }

    private static void selectionSort(byte[] a2, int from2, int to, ByteComparator comp) {
        for (int i2 = from2; i2 < to - 1; ++i2) {
            int m = i2;
            for (int j = i2 + 1; j < to; ++j) {
                if (comp.compare(a2[j], a2[m]) >= 0) continue;
                m = j;
            }
            if (m == i2) continue;
            byte u = a2[i2];
            a2[i2] = a2[m];
            a2[m] = u;
        }
    }

    private static void insertionSort(byte[] a2, int from2, int to, ByteComparator comp) {
        int i2 = from2;
        while (++i2 < to) {
            byte t = a2[i2];
            int j = i2;
            byte u = a2[j - 1];
            while (comp.compare(t, u) < 0) {
                a2[j] = u;
                if (from2 == j - 1) {
                    --j;
                    break;
                }
                u = a2[--j - 1];
            }
            a2[j] = t;
        }
    }

    public static void quickSort(byte[] x, int from2, int to, ByteComparator comp) {
        int c;
        int a2;
        int len = to - from2;
        if (len < 16) {
            ByteArrays.selectionSort(x, from2, to, comp);
            return;
        }
        int m = from2 + len / 2;
        int l = from2;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = ByteArrays.med3(x, l, l + s, l + 2 * s, comp);
            m = ByteArrays.med3(x, m - s, m, m + s, comp);
            n = ByteArrays.med3(x, n - 2 * s, n - s, n, comp);
        }
        m = ByteArrays.med3(x, l, m, n, comp);
        byte v = x[m];
        int b2 = a2 = from2;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c && (comparison = comp.compare(x[b2], v)) <= 0) {
                if (comparison == 0) {
                    ByteArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c >= b2 && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    ByteArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b2 > c) break;
            ByteArrays.swap(x, b2++, c--);
        }
        int s = Math.min(a2 - from2, b2 - a2);
        ByteArrays.swap(x, from2, b2 - s, s);
        s = Math.min(d - c, to - d - 1);
        ByteArrays.swap(x, b2, to - s, s);
        s = b2 - a2;
        if (s > 1) {
            ByteArrays.quickSort(x, from2, from2 + s, comp);
        }
        if ((s = d - c) > 1) {
            ByteArrays.quickSort(x, to - s, to, comp);
        }
    }

    public static void unstableSort(byte[] a2, int from2, int to) {
        java.util.Arrays.sort(a2, from2, to);
    }

    public static void unstableSort(byte[] a2) {
        ByteArrays.unstableSort(a2, 0, a2.length);
    }

    public static void unstableSort(byte[] a2, int from2, int to, ByteComparator comp) {
        ByteArrays.quickSort(a2, from2, to, comp);
    }

    public static void unstableSort(byte[] a2, ByteComparator comp) {
        ByteArrays.unstableSort(a2, 0, a2.length, comp);
    }

    public static void mergeSort(byte[] a2, int from2, int to, ByteComparator comp, byte[] supp) {
        int len = to - from2;
        if (len < 16) {
            ByteArrays.insertionSort(a2, from2, to, comp);
            return;
        }
        if (supp == null) {
            supp = java.util.Arrays.copyOf(a2, to);
        }
        int mid = from2 + to >>> 1;
        ByteArrays.mergeSort(supp, from2, mid, comp, a2);
        ByteArrays.mergeSort(supp, mid, to, comp, a2);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from2, a2, from2, len);
            return;
        }
        int p2 = from2;
        int q2 = mid;
        for (int i2 = from2; i2 < to; ++i2) {
            a2[i2] = q2 >= to || p2 < mid && comp.compare(supp[p2], supp[q2]) <= 0 ? supp[p2++] : supp[q2++];
        }
    }

    public static void mergeSort(byte[] a2, int from2, int to, ByteComparator comp) {
        ByteArrays.mergeSort(a2, from2, to, comp, null);
    }

    public static void stableSort(byte[] a2, int from2, int to) {
        ByteArrays.unstableSort(a2, from2, to);
    }

    public static void stableSort(byte[] a2, int from2, int to, ByteComparator comp) {
        ByteArrays.mergeSort(a2, from2, to, comp);
    }

    public static void stableSort(byte[] a2, ByteComparator comp) {
        ByteArrays.stableSort(a2, 0, a2.length, comp);
    }

    protected static final class Segment {
        protected final int offset;
        protected final int length;
        protected final int level;

        protected Segment(int offset2, int length, int level) {
            this.offset = offset2;
            this.length = length;
            this.level = level;
        }

        public String toString() {
            return "Segment [offset=" + this.offset + ", length=" + this.length + ", level=" + this.level + "]";
        }
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<byte[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(byte[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(byte[] a2, byte[] b2) {
            return java.util.Arrays.equals(a2, b2);
        }
    }
}

