/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.chars;

import java.io.Serializable;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Arrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Hash;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.chars.CharComparator;

public final class CharArrays {
    public static final char[] EMPTY_ARRAY = new char[0];
    public static final char[] DEFAULT_EMPTY_ARRAY = new char[0];
    protected static final Segment POISON_PILL = new Segment(-1, -1, -1);
    public static final Hash.Strategy<char[]> HASH_STRATEGY = new ArrayHashStrategy();

    public static void ensureOffsetLength(char[] a2, int offset2, int length) {
        Arrays.ensureOffsetLength(a2.length, offset2, length);
    }

    public static void swap(char[] x, int a2, int b2) {
        char t = x[a2];
        x[a2] = x[b2];
        x[b2] = t;
    }

    public static void swap(char[] x, int a2, int b2, int n) {
        int i2 = 0;
        while (i2 < n) {
            CharArrays.swap(x, a2, b2);
            ++i2;
            ++a2;
            ++b2;
        }
    }

    private static int med3(char[] x, int a2, int b2, int c, CharComparator comp) {
        int ab = comp.compare(x[a2], x[b2]);
        int ac = comp.compare(x[a2], x[c]);
        int bc = comp.compare(x[b2], x[c]);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c : a2)) : (bc > 0 ? b2 : (ac > 0 ? c : a2));
    }

    private static void selectionSort(char[] a2, int from2, int to, CharComparator comp) {
        for (int i2 = from2; i2 < to - 1; ++i2) {
            int m = i2;
            for (int j = i2 + 1; j < to; ++j) {
                if (comp.compare(a2[j], a2[m]) >= 0) continue;
                m = j;
            }
            if (m == i2) continue;
            char u = a2[i2];
            a2[i2] = a2[m];
            a2[m] = u;
        }
    }

    private static void insertionSort(char[] a2, int from2, int to, CharComparator comp) {
        int i2 = from2;
        while (++i2 < to) {
            char t = a2[i2];
            int j = i2;
            char u = a2[j - 1];
            while (comp.compare(t, u) < 0) {
                a2[j] = u;
                if (from2 == j - 1) {
                    --j;
                    break;
                }
                u = a2[--j - 1];
            }
            a2[j] = t;
        }
    }

    public static void quickSort(char[] x, int from2, int to, CharComparator comp) {
        int c;
        int a2;
        int len = to - from2;
        if (len < 16) {
            CharArrays.selectionSort(x, from2, to, comp);
            return;
        }
        int m = from2 + len / 2;
        int l = from2;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = CharArrays.med3(x, l, l + s, l + 2 * s, comp);
            m = CharArrays.med3(x, m - s, m, m + s, comp);
            n = CharArrays.med3(x, n - 2 * s, n - s, n, comp);
        }
        m = CharArrays.med3(x, l, m, n, comp);
        char v = x[m];
        int b2 = a2 = from2;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c && (comparison = comp.compare(x[b2], v)) <= 0) {
                if (comparison == 0) {
                    CharArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c >= b2 && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    CharArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b2 > c) break;
            CharArrays.swap(x, b2++, c--);
        }
        int s = Math.min(a2 - from2, b2 - a2);
        CharArrays.swap(x, from2, b2 - s, s);
        s = Math.min(d - c, to - d - 1);
        CharArrays.swap(x, b2, to - s, s);
        s = b2 - a2;
        if (s > 1) {
            CharArrays.quickSort(x, from2, from2 + s, comp);
        }
        if ((s = d - c) > 1) {
            CharArrays.quickSort(x, to - s, to, comp);
        }
    }

    private static int med3(char[] x, int a2, int b2, int c) {
        int ab = Character.compare(x[a2], x[b2]);
        int ac = Character.compare(x[a2], x[c]);
        int bc = Character.compare(x[b2], x[c]);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c : a2)) : (bc > 0 ? b2 : (ac > 0 ? c : a2));
    }

    private static void selectionSort(char[] a2, int from2, int to) {
        for (int i2 = from2; i2 < to - 1; ++i2) {
            int m = i2;
            for (int j = i2 + 1; j < to; ++j) {
                if (a2[j] >= a2[m]) continue;
                m = j;
            }
            if (m == i2) continue;
            char u = a2[i2];
            a2[i2] = a2[m];
            a2[m] = u;
        }
    }

    public static void quickSort(char[] x, int from2, int to) {
        int c;
        int a2;
        int len = to - from2;
        if (len < 16) {
            CharArrays.selectionSort(x, from2, to);
            return;
        }
        int m = from2 + len / 2;
        int l = from2;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = CharArrays.med3(x, l, l + s, l + 2 * s);
            m = CharArrays.med3(x, m - s, m, m + s);
            n = CharArrays.med3(x, n - 2 * s, n - s, n);
        }
        m = CharArrays.med3(x, l, m, n);
        char v = x[m];
        int b2 = a2 = from2;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c && (comparison = Character.compare(x[b2], v)) <= 0) {
                if (comparison == 0) {
                    CharArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c >= b2 && (comparison = Character.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    CharArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b2 > c) break;
            CharArrays.swap(x, b2++, c--);
        }
        int s = Math.min(a2 - from2, b2 - a2);
        CharArrays.swap(x, from2, b2 - s, s);
        s = Math.min(d - c, to - d - 1);
        CharArrays.swap(x, b2, to - s, s);
        s = b2 - a2;
        if (s > 1) {
            CharArrays.quickSort(x, from2, from2 + s);
        }
        if ((s = d - c) > 1) {
            CharArrays.quickSort(x, to - s, to);
        }
    }

    public static void unstableSort(char[] a2, int from2, int to) {
        if (to - from2 >= 2000) {
            CharArrays.radixSort(a2, from2, to);
        } else {
            CharArrays.quickSort(a2, from2, to);
        }
    }

    public static void unstableSort(char[] a2) {
        CharArrays.unstableSort(a2, 0, a2.length);
    }

    public static void unstableSort(char[] a2, int from2, int to, CharComparator comp) {
        CharArrays.quickSort(a2, from2, to, comp);
    }

    public static void unstableSort(char[] a2, CharComparator comp) {
        CharArrays.unstableSort(a2, 0, a2.length, comp);
    }

    public static void mergeSort(char[] a2, int from2, int to, CharComparator comp, char[] supp) {
        int len = to - from2;
        if (len < 16) {
            CharArrays.insertionSort(a2, from2, to, comp);
            return;
        }
        if (supp == null) {
            supp = java.util.Arrays.copyOf(a2, to);
        }
        int mid = from2 + to >>> 1;
        CharArrays.mergeSort(supp, from2, mid, comp, a2);
        CharArrays.mergeSort(supp, mid, to, comp, a2);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from2, a2, from2, len);
            return;
        }
        int p2 = from2;
        int q2 = mid;
        for (int i2 = from2; i2 < to; ++i2) {
            a2[i2] = q2 >= to || p2 < mid && comp.compare(supp[p2], supp[q2]) <= 0 ? supp[p2++] : supp[q2++];
        }
    }

    public static void mergeSort(char[] a2, int from2, int to, CharComparator comp) {
        CharArrays.mergeSort(a2, from2, to, comp, null);
    }

    public static void stableSort(char[] a2, int from2, int to, CharComparator comp) {
        CharArrays.mergeSort(a2, from2, to, comp);
    }

    public static void stableSort(char[] a2, CharComparator comp) {
        CharArrays.stableSort(a2, 0, a2.length, comp);
    }

    public static void radixSort(char[] a2, int from2, int to) {
        if (to - from2 < 1024) {
            CharArrays.quickSort(a2, from2, to);
            return;
        }
        boolean maxLevel = true;
        int stackSize = 256;
        int stackPos = 0;
        int[] offsetStack = new int[256];
        int[] lengthStack = new int[256];
        int[] levelStack = new int[256];
        offsetStack[stackPos] = from2;
        lengthStack[stackPos] = to - from2;
        levelStack[stackPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = new int[256];
        while (stackPos > 0) {
            int first2 = offsetStack[--stackPos];
            int length = lengthStack[stackPos];
            int level = levelStack[stackPos];
            boolean signMask = false;
            int shift = (1 - level % 2) * 8;
            int i2 = first2 + length;
            while (i2-- != first2) {
                int n = a2[i2] >>> shift & 0xFF ^ 0;
                count2[n] = count2[n] + 1;
            }
            int lastUsed = -1;
            int p2 = first2;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count2[i3] != 0) {
                    lastUsed = i3;
                }
                pos[i3] = p2 += count2[i3];
            }
            int end = first2 + length - count2[lastUsed];
            int c = -1;
            for (int i4 = first2; i4 <= end; i4 += count2[c]) {
                char t = a2[i4];
                c = t >>> shift & 0xFF ^ 0;
                if (i4 < end) {
                    while (true) {
                        int n = c;
                        int n2 = pos[n] - 1;
                        pos[n] = n2;
                        int d = n2;
                        if (n2 <= i4) break;
                        char z = t;
                        t = a2[d];
                        a2[d] = z;
                        c = t >>> shift & 0xFF ^ 0;
                    }
                    a2[i4] = t;
                }
                if (level < 1 && count2[c] > 1) {
                    if (count2[c] < 1024) {
                        CharArrays.quickSort(a2, i4, i4 + count2[c]);
                    } else {
                        offsetStack[stackPos] = i4;
                        lengthStack[stackPos] = count2[c];
                        levelStack[stackPos++] = level + 1;
                    }
                }
                count2[c] = 0;
            }
        }
    }

    protected static final class Segment {
        protected final int offset;
        protected final int length;
        protected final int level;

        protected Segment(int offset2, int length, int level) {
            this.offset = offset2;
            this.length = length;
            this.level = level;
        }

        public String toString() {
            return "Segment [offset=" + this.offset + ", length=" + this.length + ", level=" + this.level + "]";
        }
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<char[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(char[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(char[] a2, char[] b2) {
            return java.util.Arrays.equals(a2, b2);
        }
    }
}

