/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles;

import java.io.Serializable;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.Double2ObjectFunctions;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.Double2ObjectMap;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.DoubleSet;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.DoubleSets;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectIterable;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectSet;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectSets;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectSpliterator;

public final class Double2ObjectMaps {
    public static final EmptyMap EMPTY_MAP = new EmptyMap();

    public static <V> ObjectIterator<Double2ObjectMap.Entry<V>> fastIterator(Double2ObjectMap<V> map2) {
        ObjectSet<Double2ObjectMap.Entry<V>> entries2 = map2.double2ObjectEntrySet();
        return entries2 instanceof Double2ObjectMap.FastEntrySet ? ((Double2ObjectMap.FastEntrySet)entries2).fastIterator() : entries2.iterator();
    }

    public static <V> ObjectIterable<Double2ObjectMap.Entry<V>> fastIterable(Double2ObjectMap<V> map2) {
        final ObjectSet<Double2ObjectMap.Entry<V>> entries2 = map2.double2ObjectEntrySet();
        return entries2 instanceof Double2ObjectMap.FastEntrySet ? new ObjectIterable<Double2ObjectMap.Entry<V>>(){

            @Override
            public ObjectIterator<Double2ObjectMap.Entry<V>> iterator() {
                return ((Double2ObjectMap.FastEntrySet)entries2).fastIterator();
            }

            @Override
            public ObjectSpliterator<Double2ObjectMap.Entry<V>> spliterator() {
                return entries2.spliterator();
            }

            @Override
            public void forEach(Consumer<? super Double2ObjectMap.Entry<V>> consumer2) {
                ((Double2ObjectMap.FastEntrySet)entries2).fastForEach(consumer2);
            }
        } : entries2;
    }

    public static class EmptyMap<V>
    extends Double2ObjectFunctions.EmptyFunction<V>
    implements Double2ObjectMap<V>,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptyMap() {
        }

        @Override
        public boolean containsValue(Object v) {
            return false;
        }

        @Override
        @Deprecated
        public V getOrDefault(Object key, V defaultValue) {
            return defaultValue;
        }

        @Override
        public void putAll(Map<? extends Double, ? extends V> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSet<Double2ObjectMap.Entry<V>> double2ObjectEntrySet() {
            return ObjectSets.EMPTY_SET;
        }

        @Override
        public DoubleSet keySet() {
            return DoubleSets.EMPTY_SET;
        }

        @Override
        public ObjectCollection<V> values() {
            return ObjectSets.EMPTY_SET;
        }

        @Override
        public void forEach(BiConsumer<? super Double, ? super V> consumer2) {
        }

        @Override
        public Object clone() {
            return EMPTY_MAP;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map)) {
                return false;
            }
            return ((Map)o).isEmpty();
        }

        @Override
        public String toString() {
            return "{}";
        }
    }
}

