/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.DoubleUnaryOperator;
import java.util.function.UnaryOperator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Size64;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.AbstractDoubleList;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.DoubleArrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.DoubleCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.DoubleComparator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.DoubleComparators;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.DoubleSpliterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.DoubleSpliterators;

public interface DoubleList
extends DoubleCollection,
Comparable<List<? extends Double>>,
List<Double> {
    @Override
    public DoubleListIterator iterator();

    @Override
    default public DoubleSpliterator spliterator() {
        if (this instanceof RandomAccess) {
            return new AbstractDoubleList.IndexBasedSpliterator(this, 0);
        }
        return DoubleSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(this), 16720);
    }

    public DoubleListIterator listIterator();

    public DoubleListIterator listIterator(int var1);

    public DoubleList subList(int var1, int var2);

    public void getElements(int var1, double[] var2, int var3, int var4);

    public void removeElements(int var1, int var2);

    default public void setElements(double[] a2) {
        this.setElements(0, a2);
    }

    default public void setElements(int index, double[] a2) {
        this.setElements(index, a2, 0, a2.length);
    }

    default public void setElements(int index, double[] a2, int offset2, int length) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than list size (" + this.size() + ")");
        }
        DoubleArrays.ensureOffsetLength(a2, offset2, length);
        if (index + length > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (index + length) + ") is greater than list size (" + this.size() + ")");
        }
        DoubleListIterator iter = this.listIterator(index);
        int i2 = 0;
        while (i2 < length) {
            iter.nextDouble();
            iter.set(a2[offset2 + i2++]);
        }
    }

    @Override
    public boolean add(double var1);

    @Override
    public void add(int var1, double var2);

    @Override
    @Deprecated
    default public void add(int index, Double key) {
        this.add(index, (double)key);
    }

    @Override
    public double set(int var1, double var2);

    default public void replaceAll(DoubleUnaryOperator operator) {
        DoubleListIterator iter = this.listIterator();
        while (iter.hasNext()) {
            iter.set(operator.applyAsDouble(iter.nextDouble()));
        }
    }

    @Override
    @Deprecated
    default public void replaceAll(UnaryOperator<Double> operator) {
        Objects.requireNonNull(operator);
        this.replaceAll(operator instanceof DoubleUnaryOperator ? (DoubleUnaryOperator)((Object)operator) : operator::apply);
    }

    public double getDouble(int var1);

    public int indexOf(double var1);

    public int lastIndexOf(double var1);

    @Override
    @Deprecated
    default public boolean contains(Object key) {
        return DoubleCollection.super.contains(key);
    }

    @Override
    @Deprecated
    default public Double get(int index) {
        return this.getDouble(index);
    }

    @Override
    @Deprecated
    default public int indexOf(Object o) {
        return this.indexOf((Double)o);
    }

    @Override
    @Deprecated
    default public int lastIndexOf(Object o) {
        return this.lastIndexOf((Double)o);
    }

    @Override
    @Deprecated
    default public boolean add(Double k) {
        return this.add((double)k);
    }

    public double removeDouble(int var1);

    @Override
    @Deprecated
    default public boolean remove(Object key) {
        return DoubleCollection.super.remove(key);
    }

    @Override
    @Deprecated
    default public Double remove(int index) {
        return this.removeDouble(index);
    }

    @Override
    @Deprecated
    default public Double set(int index, Double k) {
        return this.set(index, (double)k);
    }

    @Override
    @Deprecated
    default public void sort(Comparator<? super Double> comparator) {
        this.sort(DoubleComparators.asDoubleComparator(comparator));
    }

    default public void sort(DoubleComparator comparator) {
        double[] elements = this.toDoubleArray();
        if (comparator == null) {
            DoubleArrays.stableSort(elements);
        } else {
            DoubleArrays.stableSort(elements, comparator);
        }
        this.setElements(elements);
    }
}

