/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats.FloatCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats.FloatIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats.FloatIterators;

public abstract class AbstractFloatCollection
extends AbstractCollection<Float>
implements FloatCollection {
    protected AbstractFloatCollection() {
    }

    @Override
    public abstract FloatIterator iterator();

    @Override
    public boolean add(float k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(float k) {
        FloatIterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            if (k != iterator2.nextFloat()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean rem(float k) {
        FloatIterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            if (k != iterator2.nextFloat()) continue;
            iterator2.remove();
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean add(Float key) {
        return FloatCollection.super.add(key);
    }

    @Override
    @Deprecated
    public boolean contains(Object key) {
        return FloatCollection.super.contains(key);
    }

    @Override
    @Deprecated
    public boolean remove(Object key) {
        return FloatCollection.super.remove(key);
    }

    public float[] toArray(float[] a2) {
        int size = this.size();
        if (a2 == null) {
            a2 = new float[size];
        } else if (a2.length < size) {
            a2 = Arrays.copyOf(a2, size);
        }
        FloatIterators.unwrap(this.iterator(), a2);
        return a2;
    }

    @Override
    public float[] toFloatArray() {
        return this.toArray((float[])null);
    }

    public boolean addAll(FloatCollection c) {
        boolean retVal = false;
        FloatIterator i2 = c.iterator();
        while (i2.hasNext()) {
            if (!this.add(i2.nextFloat())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean addAll(Collection<? extends Float> c) {
        if (c instanceof FloatCollection) {
            return this.addAll((FloatCollection)c);
        }
        return super.addAll(c);
    }

    public boolean containsAll(FloatCollection c) {
        FloatIterator i2 = c.iterator();
        while (i2.hasNext()) {
            if (this.contains(i2.nextFloat())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c instanceof FloatCollection) {
            return this.containsAll((FloatCollection)c);
        }
        return super.containsAll(c);
    }

    public boolean removeAll(FloatCollection c) {
        boolean retVal = false;
        FloatIterator i2 = c.iterator();
        while (i2.hasNext()) {
            if (!this.rem(i2.nextFloat())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c instanceof FloatCollection) {
            return this.removeAll((FloatCollection)c);
        }
        return super.removeAll(c);
    }

    public boolean retainAll(FloatCollection c) {
        boolean retVal = false;
        FloatIterator i2 = this.iterator();
        while (i2.hasNext()) {
            if (c.contains(i2.nextFloat())) continue;
            i2.remove();
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (c instanceof FloatCollection) {
            return this.retainAll((FloatCollection)c);
        }
        return super.retainAll(c);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        FloatIterator i2 = this.iterator();
        int n = this.size();
        boolean first2 = true;
        s.append("{");
        while (n-- != 0) {
            if (first2) {
                first2 = false;
            } else {
                s.append(", ");
            }
            float k = i2.nextFloat();
            s.append(String.valueOf(k));
        }
        s.append("}");
        return s.toString();
    }
}

