/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats;

import java.io.Serializable;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Arrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Hash;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats.FloatComparator;

public final class FloatArrays {
    public static final float[] EMPTY_ARRAY = new float[0];
    public static final float[] DEFAULT_EMPTY_ARRAY = new float[0];
    protected static final Segment POISON_PILL = new Segment(-1, -1, -1);
    public static final Hash.Strategy<float[]> HASH_STRATEGY = new ArrayHashStrategy();

    public static void ensureOffsetLength(float[] a2, int offset2, int length) {
        Arrays.ensureOffsetLength(a2.length, offset2, length);
    }

    private static void insertionSort(float[] a2, int from2, int to, FloatComparator comp) {
        int i2 = from2;
        while (++i2 < to) {
            float t = a2[i2];
            int j = i2;
            float u = a2[j - 1];
            while (comp.compare(t, u) < 0) {
                a2[j] = u;
                if (from2 == j - 1) {
                    --j;
                    break;
                }
                u = a2[--j - 1];
            }
            a2[j] = t;
        }
    }

    private static void insertionSort(float[] a2, int from2, int to) {
        int i2 = from2;
        while (++i2 < to) {
            float t = a2[i2];
            int j = i2;
            float u = a2[j - 1];
            while (Float.compare(t, u) < 0) {
                a2[j] = u;
                if (from2 == j - 1) {
                    --j;
                    break;
                }
                u = a2[--j - 1];
            }
            a2[j] = t;
        }
    }

    public static void mergeSort(float[] a2, int from2, int to, float[] supp) {
        int len = to - from2;
        if (len < 16) {
            FloatArrays.insertionSort(a2, from2, to);
            return;
        }
        if (supp == null) {
            supp = java.util.Arrays.copyOf(a2, to);
        }
        int mid = from2 + to >>> 1;
        FloatArrays.mergeSort(supp, from2, mid, a2);
        FloatArrays.mergeSort(supp, mid, to, a2);
        if (Float.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from2, a2, from2, len);
            return;
        }
        int p2 = from2;
        int q2 = mid;
        for (int i2 = from2; i2 < to; ++i2) {
            a2[i2] = q2 >= to || p2 < mid && Float.compare(supp[p2], supp[q2]) <= 0 ? supp[p2++] : supp[q2++];
        }
    }

    public static void mergeSort(float[] a2, int from2, int to) {
        FloatArrays.mergeSort(a2, from2, to, (float[])null);
    }

    public static void mergeSort(float[] a2, int from2, int to, FloatComparator comp, float[] supp) {
        int len = to - from2;
        if (len < 16) {
            FloatArrays.insertionSort(a2, from2, to, comp);
            return;
        }
        if (supp == null) {
            supp = java.util.Arrays.copyOf(a2, to);
        }
        int mid = from2 + to >>> 1;
        FloatArrays.mergeSort(supp, from2, mid, comp, a2);
        FloatArrays.mergeSort(supp, mid, to, comp, a2);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from2, a2, from2, len);
            return;
        }
        int p2 = from2;
        int q2 = mid;
        for (int i2 = from2; i2 < to; ++i2) {
            a2[i2] = q2 >= to || p2 < mid && comp.compare(supp[p2], supp[q2]) <= 0 ? supp[p2++] : supp[q2++];
        }
    }

    public static void mergeSort(float[] a2, int from2, int to, FloatComparator comp) {
        FloatArrays.mergeSort(a2, from2, to, comp, null);
    }

    public static void stableSort(float[] a2, int from2, int to) {
        FloatArrays.mergeSort(a2, from2, to);
    }

    public static void stableSort(float[] a2) {
        FloatArrays.stableSort(a2, 0, a2.length);
    }

    public static void stableSort(float[] a2, int from2, int to, FloatComparator comp) {
        FloatArrays.mergeSort(a2, from2, to, comp);
    }

    public static void stableSort(float[] a2, FloatComparator comp) {
        FloatArrays.stableSort(a2, 0, a2.length, comp);
    }

    protected static final class Segment {
        protected final int offset;
        protected final int length;
        protected final int level;

        protected Segment(int offset2, int length, int level) {
            this.offset = offset2;
            this.length = length;
            this.level = level;
        }

        public String toString() {
            return "Segment [offset=" + this.offset + ", length=" + this.length + ", level=" + this.level + "]";
        }
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<float[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(float[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(float[] a2, float[] b2) {
            return java.util.Arrays.equals(a2, b2);
        }
    }
}

