/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs;

import java.io.Serializable;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Arrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Hash;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.LongComparator;

public final class LongArrays {
    public static final long[] EMPTY_ARRAY = new long[0];
    public static final long[] DEFAULT_EMPTY_ARRAY = new long[0];
    protected static final Segment POISON_PILL = new Segment(-1, -1, -1);
    public static final Hash.Strategy<long[]> HASH_STRATEGY = new ArrayHashStrategy();

    public static long[] forceCapacity(long[] array, int length, int preserve) {
        long[] t = new long[length];
        System.arraycopy(array, 0, t, 0, preserve);
        return t;
    }

    public static void ensureOffsetLength(long[] a2, int offset2, int length) {
        Arrays.ensureOffsetLength(a2.length, offset2, length);
    }

    public static void swap(long[] x, int a2, int b2) {
        long t = x[a2];
        x[a2] = x[b2];
        x[b2] = t;
    }

    public static void swap(long[] x, int a2, int b2, int n) {
        int i2 = 0;
        while (i2 < n) {
            LongArrays.swap(x, a2, b2);
            ++i2;
            ++a2;
            ++b2;
        }
    }

    private static int med3(long[] x, int a2, int b2, int c, LongComparator comp) {
        int ab = comp.compare(x[a2], x[b2]);
        int ac = comp.compare(x[a2], x[c]);
        int bc = comp.compare(x[b2], x[c]);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c : a2)) : (bc > 0 ? b2 : (ac > 0 ? c : a2));
    }

    private static void selectionSort(long[] a2, int from2, int to, LongComparator comp) {
        for (int i2 = from2; i2 < to - 1; ++i2) {
            int m = i2;
            for (int j = i2 + 1; j < to; ++j) {
                if (comp.compare(a2[j], a2[m]) >= 0) continue;
                m = j;
            }
            if (m == i2) continue;
            long u = a2[i2];
            a2[i2] = a2[m];
            a2[m] = u;
        }
    }

    private static void insertionSort(long[] a2, int from2, int to, LongComparator comp) {
        int i2 = from2;
        while (++i2 < to) {
            long t = a2[i2];
            int j = i2;
            long u = a2[j - 1];
            while (comp.compare(t, u) < 0) {
                a2[j] = u;
                if (from2 == j - 1) {
                    --j;
                    break;
                }
                u = a2[--j - 1];
            }
            a2[j] = t;
        }
    }

    public static void quickSort(long[] x, int from2, int to, LongComparator comp) {
        int c;
        int a2;
        int len = to - from2;
        if (len < 16) {
            LongArrays.selectionSort(x, from2, to, comp);
            return;
        }
        int m = from2 + len / 2;
        int l = from2;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = LongArrays.med3(x, l, l + s, l + 2 * s, comp);
            m = LongArrays.med3(x, m - s, m, m + s, comp);
            n = LongArrays.med3(x, n - 2 * s, n - s, n, comp);
        }
        m = LongArrays.med3(x, l, m, n, comp);
        long v = x[m];
        int b2 = a2 = from2;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c && (comparison = comp.compare(x[b2], v)) <= 0) {
                if (comparison == 0) {
                    LongArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c >= b2 && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    LongArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b2 > c) break;
            LongArrays.swap(x, b2++, c--);
        }
        int s = Math.min(a2 - from2, b2 - a2);
        LongArrays.swap(x, from2, b2 - s, s);
        s = Math.min(d - c, to - d - 1);
        LongArrays.swap(x, b2, to - s, s);
        s = b2 - a2;
        if (s > 1) {
            LongArrays.quickSort(x, from2, from2 + s, comp);
        }
        if ((s = d - c) > 1) {
            LongArrays.quickSort(x, to - s, to, comp);
        }
    }

    private static int med3(long[] x, int a2, int b2, int c) {
        int ab = Long.compare(x[a2], x[b2]);
        int ac = Long.compare(x[a2], x[c]);
        int bc = Long.compare(x[b2], x[c]);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c : a2)) : (bc > 0 ? b2 : (ac > 0 ? c : a2));
    }

    private static void selectionSort(long[] a2, int from2, int to) {
        for (int i2 = from2; i2 < to - 1; ++i2) {
            int m = i2;
            for (int j = i2 + 1; j < to; ++j) {
                if (a2[j] >= a2[m]) continue;
                m = j;
            }
            if (m == i2) continue;
            long u = a2[i2];
            a2[i2] = a2[m];
            a2[m] = u;
        }
    }

    public static void quickSort(long[] x, int from2, int to) {
        int c;
        int a2;
        int len = to - from2;
        if (len < 16) {
            LongArrays.selectionSort(x, from2, to);
            return;
        }
        int m = from2 + len / 2;
        int l = from2;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = LongArrays.med3(x, l, l + s, l + 2 * s);
            m = LongArrays.med3(x, m - s, m, m + s);
            n = LongArrays.med3(x, n - 2 * s, n - s, n);
        }
        m = LongArrays.med3(x, l, m, n);
        long v = x[m];
        int b2 = a2 = from2;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c && (comparison = Long.compare(x[b2], v)) <= 0) {
                if (comparison == 0) {
                    LongArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c >= b2 && (comparison = Long.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    LongArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b2 > c) break;
            LongArrays.swap(x, b2++, c--);
        }
        int s = Math.min(a2 - from2, b2 - a2);
        LongArrays.swap(x, from2, b2 - s, s);
        s = Math.min(d - c, to - d - 1);
        LongArrays.swap(x, b2, to - s, s);
        s = b2 - a2;
        if (s > 1) {
            LongArrays.quickSort(x, from2, from2 + s);
        }
        if ((s = d - c) > 1) {
            LongArrays.quickSort(x, to - s, to);
        }
    }

    public static void unstableSort(long[] a2, int from2, int to) {
        if (to - from2 >= 4000) {
            LongArrays.radixSort(a2, from2, to);
        } else {
            LongArrays.quickSort(a2, from2, to);
        }
    }

    public static void unstableSort(long[] a2) {
        LongArrays.unstableSort(a2, 0, a2.length);
    }

    public static void unstableSort(long[] a2, int from2, int to, LongComparator comp) {
        LongArrays.quickSort(a2, from2, to, comp);
    }

    public static void unstableSort(long[] a2, LongComparator comp) {
        LongArrays.unstableSort(a2, 0, a2.length, comp);
    }

    public static void mergeSort(long[] a2, int from2, int to, LongComparator comp, long[] supp) {
        int len = to - from2;
        if (len < 16) {
            LongArrays.insertionSort(a2, from2, to, comp);
            return;
        }
        if (supp == null) {
            supp = java.util.Arrays.copyOf(a2, to);
        }
        int mid = from2 + to >>> 1;
        LongArrays.mergeSort(supp, from2, mid, comp, a2);
        LongArrays.mergeSort(supp, mid, to, comp, a2);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from2, a2, from2, len);
            return;
        }
        int p2 = from2;
        int q2 = mid;
        for (int i2 = from2; i2 < to; ++i2) {
            a2[i2] = q2 >= to || p2 < mid && comp.compare(supp[p2], supp[q2]) <= 0 ? supp[p2++] : supp[q2++];
        }
    }

    public static void mergeSort(long[] a2, int from2, int to, LongComparator comp) {
        LongArrays.mergeSort(a2, from2, to, comp, null);
    }

    public static void stableSort(long[] a2, int from2, int to) {
        LongArrays.unstableSort(a2, from2, to);
    }

    public static void stableSort(long[] a2, int from2, int to, LongComparator comp) {
        LongArrays.mergeSort(a2, from2, to, comp);
    }

    public static void stableSort(long[] a2, LongComparator comp) {
        LongArrays.stableSort(a2, 0, a2.length, comp);
    }

    public static void radixSort(long[] a2, int from2, int to) {
        if (to - from2 < 1024) {
            LongArrays.quickSort(a2, from2, to);
            return;
        }
        int maxLevel = 7;
        int stackSize = 1786;
        int stackPos = 0;
        int[] offsetStack = new int[1786];
        int[] lengthStack = new int[1786];
        int[] levelStack = new int[1786];
        offsetStack[stackPos] = from2;
        lengthStack[stackPos] = to - from2;
        levelStack[stackPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = new int[256];
        while (stackPos > 0) {
            int first2 = offsetStack[--stackPos];
            int length = lengthStack[stackPos];
            int level = levelStack[stackPos];
            int signMask = level % 8 == 0 ? 128 : 0;
            int shift = (7 - level % 8) * 8;
            int i2 = first2 + length;
            while (i2-- != first2) {
                int n = (int)(a2[i2] >>> shift & 0xFFL ^ (long)signMask);
                count2[n] = count2[n] + 1;
            }
            int lastUsed = -1;
            int p2 = first2;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count2[i3] != 0) {
                    lastUsed = i3;
                }
                pos[i3] = p2 += count2[i3];
            }
            int end = first2 + length - count2[lastUsed];
            int c = -1;
            for (int i4 = first2; i4 <= end; i4 += count2[c]) {
                long t = a2[i4];
                c = (int)(t >>> shift & 0xFFL ^ (long)signMask);
                if (i4 < end) {
                    while (true) {
                        int n = c;
                        int n2 = pos[n] - 1;
                        pos[n] = n2;
                        int d = n2;
                        if (n2 <= i4) break;
                        long z = t;
                        t = a2[d];
                        a2[d] = z;
                        c = (int)(t >>> shift & 0xFFL ^ (long)signMask);
                    }
                    a2[i4] = t;
                }
                if (level < 7 && count2[c] > 1) {
                    if (count2[c] < 1024) {
                        LongArrays.quickSort(a2, i4, i4 + count2[c]);
                    } else {
                        offsetStack[stackPos] = i4;
                        lengthStack[stackPos] = count2[c];
                        levelStack[stackPos++] = level + 1;
                    }
                }
                count2[c] = 0;
            }
        }
    }

    protected static final class Segment {
        protected final int offset;
        protected final int length;
        protected final int level;

        protected Segment(int offset2, int length, int level) {
            this.offset = offset2;
            this.length = length;
            this.level = level;
        }

        public String toString() {
            return "Segment [offset=" + this.offset + ", length=" + this.length + ", level=" + this.level + "]";
        }
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<long[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(long[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(long[] a2, long[] b2) {
            return java.util.Arrays.equals(a2, b2);
        }
    }
}

