/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.inline.JsExpressionVisitor;
import org.jetbrains.kotlin.js.inline.util.CollectionUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\u001a&\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00022\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u001a \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00022\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001a\u0012\u0010\b\u001a\u00020\t*\b\u0012\u0004\u0012\u00020\t0\nH\u0002\u00a8\u0006\u000b"}, d2={"match", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "predicate", "Lkotlin/Function1;", "", "withParentsOfNodes", "nodes", "toStatement", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "", "js.translator"})
public final class ExpressionDecomposerKt {
    private static final Set<JsNode> match(JsNode $this$match, Function1<? super JsNode, Boolean> predicate) {
        JsExpressionVisitor visitor2 = new JsExpressionVisitor(predicate){
            private final Set<JsNode> matched;
            final /* synthetic */ Function1<JsNode, Boolean> $predicate;
            {
                this.$predicate = $predicate;
                this.matched = CollectionUtilsKt.IdentitySet();
            }

            public final Set<JsNode> getMatched() {
                return this.matched;
            }

            protected <R extends JsNode> void doTraverse(R node, JsContext<JsNode> ctx) {
                Intrinsics.checkNotNullParameter(node, "node");
                super.doTraverse(node, ctx);
                if (!this.matched.contains(node) && this.$predicate.invoke(node).booleanValue()) {
                    this.matched.add(node);
                }
            }
        };
        visitor2.accept($this$match);
        return visitor2.getMatched();
    }

    private static final Set<JsNode> withParentsOfNodes(JsNode $this$withParentsOfNodes, Set<? extends JsNode> nodes) {
        JsExpressionVisitor visitor2 = new JsExpressionVisitor(nodes){
            private final SmartList<JsNode> stack;
            private final Set<JsNode> matched;
            final /* synthetic */ Set<JsNode> $nodes;
            {
                this.$nodes = $nodes;
                this.stack = new SmartList<E>();
                this.matched = CollectionUtilsKt.IdentitySet();
            }

            public final Set<JsNode> getMatched() {
                return this.matched;
            }

            protected <R extends JsNode> void doTraverse(R node, JsContext<JsNode> ctx) {
                Intrinsics.checkNotNullParameter(node, "node");
                this.stack.add(node);
                super.doTraverse(node, ctx);
                if (this.$nodes.contains(node)) {
                    this.addAllUntilMatchedOrStatement((List<? extends JsNode>)this.stack);
                }
                this.stack.remove(CollectionsKt.getLastIndex((List)this.stack));
            }

            public final void addAllUntilMatchedOrStatement(List<? extends JsNode> nodesOnStack) {
                JsNode currentNode;
                Intrinsics.checkNotNullParameter(nodesOnStack, "nodesOnStack");
                for (int i2 = CollectionsKt.getLastIndex(nodesOnStack); -1 < i2 && !this.matched.contains(currentNode = nodesOnStack.get(i2)); --i2) {
                    this.matched.add(currentNode);
                    if (currentNode instanceof JsStatement) break;
                }
            }
        };
        visitor2.accept($this$withParentsOfNodes);
        return visitor2.getMatched();
    }

    private static final JsStatement toStatement(List<? extends JsStatement> $this$toStatement) {
        JsStatement jsStatement;
        switch ($this$toStatement.size()) {
            case 0: {
                jsStatement = JsEmpty.INSTANCE;
                break;
            }
            case 1: {
                jsStatement = $this$toStatement.get(0);
                break;
            }
            default: {
                jsStatement = new JsBlock($this$toStatement);
            }
        }
        return jsStatement;
    }

    public static final /* synthetic */ Set access$match(JsNode $receiver, Function1 predicate) {
        return ExpressionDecomposerKt.match($receiver, predicate);
    }

    public static final /* synthetic */ Set access$withParentsOfNodes(JsNode $receiver, Set nodes) {
        return ExpressionDecomposerKt.withParentsOfNodes($receiver, nodes);
    }

    public static final /* synthetic */ JsStatement access$toStatement(List $receiver) {
        return ExpressionDecomposerKt.toStatement($receiver);
    }
}

