/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.js.common.IdentifierPolicyKt;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineOnlyKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J$\u0010\u000f\u001a\u00020\u0003*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014H\u0002J$\u0010\u0015\u001a\u00020\u0003*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014H\u0002J \u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\f\u0010\u001a\u001a\u00020\u001b*\u00020\fH\u0002J\f\u0010\u001c\u001a\u00020\u001d*\u00020\nH\u0002J\u000e\u0010\u001e\u001a\u0004\u0018\u00010\u001d*\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsExportDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "includeUnsignedNumbers", "", "allowCompanionInInterface", "<init>", "(ZZ)V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "isExportableReturn", "Lorg/jetbrains/kotlin/types/KotlinType;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "currentlyProcessed", "", "isExportable", "validateDeclarationOnConsumableName", "declarationDescriptor", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "getKotlinOrJsName", "", "getIdentifier", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "getJsNameArgument", "js.frontend"})
public final class JsExportDeclarationChecker
implements DeclarationChecker {
    private final boolean includeUnsignedNumbers;
    private final boolean allowCompanionInInterface;

    public JsExportDeclarationChecker(boolean includeUnsignedNumbers, boolean allowCompanionInInterface) {
        this.includeUnsignedNumbers = includeUnsignedNumbers;
        this.allowCompanionInInterface = allowCompanionInInterface;
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        boolean hasJsName;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context, "context");
        BindingTrace trace2 = context.getTrace();
        BindingContext bindingContext = trace2.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        BindingContext bindingContext2 = bindingContext;
        if (!AnnotationsUtils.isExportedObject(descriptor2, bindingContext2)) {
            return;
        }
        if (!(descriptor2 instanceof MemberDescriptor)) {
            return;
        }
        boolean bl = hasJsName = AnnotationsUtils.getJsNameAnnotation(descriptor2) != null;
        if (((MemberDescriptor)descriptor2).isExpect()) {
            JsExportDeclarationChecker.check$reportWrongExportedDeclaration(trace2, declaration, "expect");
        }
        this.validateDeclarationOnConsumableName(declaration, descriptor2, trace2);
        MemberDescriptor memberDescriptor = (MemberDescriptor)descriptor2;
        if (memberDescriptor instanceof FunctionDescriptor) {
            for (TypeParameterDescriptor typeParameter : ((FunctionDescriptor)descriptor2).getTypeParameters()) {
                Intrinsics.checkNotNull(typeParameter);
                JsExportDeclarationChecker.check$checkTypeParameter(this, bindingContext2, trace2, typeParameter);
            }
            if (InlineOnlyKt.isInlineWithReified((MemberDescriptor)descriptor2)) {
                JsExportDeclarationChecker.check$reportWrongExportedDeclaration(trace2, declaration, "inline function with reified type parameters");
                return;
            }
            if (((FunctionDescriptor)descriptor2).isSuspend()) {
                JsExportDeclarationChecker.check$reportWrongExportedDeclaration(trace2, declaration, "suspend function");
                return;
            }
            if (descriptor2 instanceof ConstructorDescriptor && !((ConstructorDescriptor)descriptor2).isPrimary() && !hasJsName) {
                JsExportDeclarationChecker.check$reportWrongExportedDeclaration(trace2, declaration, "secondary constructor without @JsName");
            }
            if (!(descriptor2 instanceof PropertyAccessorDescriptor)) {
                for (ValueParameterDescriptor parameter : ((FunctionDescriptor)descriptor2).getValueParameters()) {
                    Intrinsics.checkNotNull(parameter);
                    JsExportDeclarationChecker.check$checkValueParameter(this, bindingContext2, trace2, parameter);
                }
                KotlinType kotlinType = ((FunctionDescriptor)descriptor2).getReturnType();
                if (kotlinType != null) {
                    KotlinType returnType = kotlinType;
                    boolean bl2 = false;
                    if (!JsExportDeclarationChecker.isExportableReturn$default(this, returnType, bindingContext2, null, 2, null)) {
                        trace2.report(ErrorsJs.NON_EXPORTABLE_TYPE.on(declaration, "return", returnType));
                    }
                }
            }
        } else if (memberDescriptor instanceof PropertyDescriptor) {
            if (declaration instanceof KtParameter) {
                return;
            }
            if (DescriptorUtilsKt.isExtensionProperty(descriptor2)) {
                JsExportDeclarationChecker.check$reportWrongExportedDeclaration(trace2, declaration, "extension property");
                return;
            }
            KotlinType kotlinType = ((PropertyDescriptor)descriptor2).getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
            if (!JsExportDeclarationChecker.isExportable$default(this, kotlinType, bindingContext2, null, 2, null)) {
                trace2.report(ErrorsJs.NON_EXPORTABLE_TYPE.on(declaration, "property", ((PropertyDescriptor)descriptor2).getType()));
            }
        } else if (memberDescriptor instanceof ClassDescriptor) {
            String wrongDeclaration;
            for (TypeParameterDescriptor typeParameter : ((ClassDescriptor)descriptor2).getDeclaredTypeParameters()) {
                Intrinsics.checkNotNull(typeParameter);
                JsExportDeclarationChecker.check$checkTypeParameter(this, bindingContext2, trace2, typeParameter);
            }
            switch (WhenMappings.$EnumSwitchMapping$0[((ClassDescriptor)descriptor2).getKind().ordinal()]) {
                case 1: {
                    String string2 = "annotation class";
                    break;
                }
                case 2: {
                    String string2;
                    if (DescriptorUtilsKt.isInsideInterface(descriptor2)) {
                        string2 = "nested class inside exported interface";
                        break;
                    }
                    if (InlineClassesUtilsKt.isInlineClass(descriptor2)) {
                        string2 = (((ClassDescriptor)descriptor2).isInline() ? "inline " : "") + (((ClassDescriptor)descriptor2).isValue() ? "value " : "") + "class";
                        break;
                    }
                    string2 = null;
                    break;
                }
                default: {
                    String string2 = DescriptorUtilsKt.isInsideInterface(descriptor2) && (!this.allowCompanionInInterface || !((ClassDescriptor)descriptor2).isCompanionObject()) ? (((ClassDescriptor)descriptor2).isCompanionObject() ? "companion object" : "nested/inner declaration") + " inside exported interface" : (wrongDeclaration = null);
                }
            }
            if (this.allowCompanionInInterface && ((ClassDescriptor)descriptor2).isCompanionObject() && DescriptorUtilsKt.isInsideInterface(descriptor2) && !Intrinsics.areEqual(((ClassDescriptor)descriptor2).getName(), SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT)) {
                trace2.report(ErrorsJs.NAMED_COMPANION_IN_EXPORTED_INTERFACE.on((KtElement)((PsiElement)declaration)));
            }
            if (wrongDeclaration != null) {
                JsExportDeclarationChecker.check$reportWrongExportedDeclaration(trace2, declaration, wrongDeclaration);
                return;
            }
            if (((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_ENTRY) {
                return;
            }
        }
    }

    private final boolean isExportableReturn(KotlinType $this$isExportableReturn, BindingContext bindingContext, Set<KotlinType> currentlyProcessed) {
        return TypeUtilsKt.isUnit($this$isExportableReturn) || this.isExportable($this$isExportableReturn, bindingContext, currentlyProcessed);
    }

    static /* synthetic */ boolean isExportableReturn$default(JsExportDeclarationChecker jsExportDeclarationChecker, KotlinType kotlinType, BindingContext bindingContext, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = new LinkedHashSet();
        }
        return jsExportDeclarationChecker.isExportableReturn(kotlinType, bindingContext, set);
    }

    private final boolean isExportable(KotlinType $this$isExportable, BindingContext bindingContext, Set<KotlinType> currentlyProcessed) {
        boolean isPrimitiveExportableType;
        if (!currentlyProcessed.add($this$isExportable)) {
            return true;
        }
        currentlyProcessed.add($this$isExportable);
        if (FunctionTypesKt.isFunctionType($this$isExportable)) {
            int n = CollectionsKt.getLastIndex($this$isExportable.getArguments());
            for (int i2 = 0; i2 < n; ++i2) {
                KotlinType kotlinType = $this$isExportable.getArguments().get(i2).getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
                if (this.isExportable(kotlinType, bindingContext, currentlyProcessed)) continue;
                currentlyProcessed.remove($this$isExportable);
                return false;
            }
            currentlyProcessed.remove($this$isExportable);
            KotlinType kotlinType = CollectionsKt.last($this$isExportable.getArguments()).getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
            return this.isExportableReturn(kotlinType, bindingContext, currentlyProcessed);
        }
        for (TypeProjection argument : $this$isExportable.getArguments()) {
            KotlinType kotlinType = argument.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
            if (this.isExportable(kotlinType, bindingContext, currentlyProcessed)) continue;
            currentlyProcessed.remove($this$isExportable);
            return false;
        }
        currentlyProcessed.remove($this$isExportable);
        KotlinType nonNullable = TypeUtilsKt.makeNotNullable($this$isExportable);
        boolean bl = isPrimitiveExportableType = TypeUtilsKt.isAnyOrNullableAny(nonNullable) || TypeUtilsKt.isTypeParameter(nonNullable) || DynamicTypesKt.isDynamic(nonNullable) || TypeUtilsKt.isBoolean(nonNullable) || KotlinBuiltIns.isThrowableOrNullableThrowable(nonNullable) || KotlinBuiltIns.isString(nonNullable) || TypeUtilsKt.isPrimitiveNumberOrNullableType(nonNullable) && !TypeUtilsKt.isLong(nonNullable) || TypeUtilsKt.isNothingOrNullableNothing(nonNullable) || this.includeUnsignedNumbers && KotlinBuiltIns.isUnsignedNumber(nonNullable) || KotlinBuiltIns.isArray($this$isExportable) || KotlinBuiltIns.isPrimitiveArray($this$isExportable) || KotlinBuiltIns.isConstructedFromGivenClass($this$isExportable, StandardNames.FqNames.list) || KotlinBuiltIns.isConstructedFromGivenClass($this$isExportable, StandardNames.FqNames.mutableList) || KotlinBuiltIns.isConstructedFromGivenClass($this$isExportable, StandardNames.FqNames.set) || KotlinBuiltIns.isConstructedFromGivenClass($this$isExportable, StandardNames.FqNames.mutableSet) || KotlinBuiltIns.isConstructedFromGivenClass($this$isExportable, StandardNames.FqNames.map) || KotlinBuiltIns.isConstructedFromGivenClass($this$isExportable, StandardNames.FqNames.mutableMap);
        if (isPrimitiveExportableType) {
            return true;
        }
        ClassifierDescriptor descriptor2 = $this$isExportable.getConstructor().getDeclarationDescriptor();
        if (!(descriptor2 instanceof MemberDescriptor)) {
            return false;
        }
        if (KotlinBuiltIns.isEnum($this$isExportable)) {
            return true;
        }
        return DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)((Object)descriptor2)) || AnnotationsUtils.isExportedObject(descriptor2, bindingContext);
    }

    static /* synthetic */ boolean isExportable$default(JsExportDeclarationChecker jsExportDeclarationChecker, KotlinType kotlinType, BindingContext bindingContext, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = new LinkedHashSet();
        }
        return jsExportDeclarationChecker.isExportable(kotlinType, bindingContext, set);
    }

    private final void validateDeclarationOnConsumableName(KtDeclaration declaration, DeclarationDescriptor declarationDescriptor, BindingTrace trace2) {
        if (!DescriptorUtilKt.isTopLevelInPackage(declarationDescriptor) || declarationDescriptor.getName().isSpecial()) {
            return;
        }
        String name2 = this.getKotlinOrJsName(declarationDescriptor);
        if (IdentifierPolicyKt.getSPECIAL_KEYWORDS().contains(name2) || !IdentifierPolicyKt.getRESERVED_KEYWORDS().contains(name2) && Intrinsics.areEqual(NameSuggestion.Companion.sanitizeName(name2), name2)) {
            return;
        }
        PsiElement psiElement = this.getJsNameArgument(declarationDescriptor);
        if (psiElement == null) {
            psiElement = this.getIdentifier(declaration);
        }
        PsiElement reportTarget = psiElement;
        trace2.report(ErrorsJs.NON_CONSUMABLE_EXPORTED_IDENTIFIER.on(reportTarget, name2));
    }

    private final String getKotlinOrJsName(DeclarationDescriptor $this$getKotlinOrJsName) {
        String string2 = AnnotationsUtils.getJsName($this$getKotlinOrJsName);
        if (string2 == null) {
            String string3 = $this$getKotlinOrJsName.getName().getIdentifier();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "getIdentifier(...)");
        }
        return string2;
    }

    private final PsiElement getIdentifier(KtDeclaration $this$getIdentifier) {
        Intrinsics.checkNotNull($this$getIdentifier, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedDeclaration");
        PsiElement psiElement = ((KtNamedDeclaration)$this$getIdentifier).getNameIdentifier();
        Intrinsics.checkNotNull(psiElement);
        return psiElement;
    }

    private final PsiElement getJsNameArgument(DeclarationDescriptor $this$getJsNameArgument) {
        AnnotationDescriptor annotationDescriptor = AnnotationsUtils.getJsNameAnnotation($this$getJsNameArgument);
        if (annotationDescriptor == null) {
            return null;
        }
        AnnotationDescriptor jsNameAnnotation = annotationDescriptor;
        PsiElement psiElement = PsiSourceElementKt.getPsi(jsNameAnnotation.getSource());
        Intrinsics.checkNotNull(psiElement, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtAnnotationEntry");
        Object object = ((KtAnnotationEntry)psiElement).getValueArgumentList();
        return object != null && (object = ((KtValueArgumentList)object).getArguments()) != null ? (KtValueArgument)CollectionsKt.first(object) : null;
    }

    private static final void check$checkTypeParameter(JsExportDeclarationChecker this$0, BindingContext bindingContext, BindingTrace trace2, TypeParameterDescriptor descriptor2) {
        for (KotlinType upperBound : descriptor2.getUpperBounds()) {
            PsiElement typeParameterDeclaration;
            Intrinsics.checkNotNull(upperBound);
            if (JsExportDeclarationChecker.isExportable$default(this$0, upperBound, bindingContext, null, 2, null)) continue;
            Intrinsics.checkNotNull(DescriptorToSourceUtils.descriptorToDeclaration(descriptor2));
            trace2.report(ErrorsJs.NON_EXPORTABLE_TYPE.on(typeParameterDeclaration, "upper bound", upperBound));
        }
    }

    private static final void check$checkValueParameter(JsExportDeclarationChecker this$0, BindingContext bindingContext, BindingTrace trace2, ValueParameterDescriptor descriptor2) {
        KotlinType kotlinType = descriptor2.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
        if (!JsExportDeclarationChecker.isExportable$default(this$0, kotlinType, bindingContext, null, 2, null)) {
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
            Intrinsics.checkNotNull(psiElement);
            PsiElement valueParameterDeclaration = psiElement;
            trace2.report(ErrorsJs.NON_EXPORTABLE_TYPE.on(valueParameterDeclaration, "parameter", descriptor2.getType()));
        }
    }

    private static final void check$reportWrongExportedDeclaration(BindingTrace trace2, KtDeclaration $declaration, String kind) {
        trace2.report(ErrorsJs.WRONG_EXPORTED_DECLARATION.on((KtExpression)((PsiElement)$declaration), kind));
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClassKind.values().length];
            try {
                nArray[ClassKind.ANNOTATION_CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.CLASS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

