/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.js.PredefinedAnnotation;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsNameChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "js.frontend"})
@SourceDebugExtension(value={"SMAP\nJsNameChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsNameChecker.kt\norg/jetbrains/kotlin/js/resolve/diagnostics/JsNameChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1782#2,4:69\n*S KotlinDebug\n*F\n+ 1 JsNameChecker.kt\norg/jetbrains/kotlin/js/resolve/diagnostics/JsNameChecker\n*L\n32#1:69,4\n*E\n"})
public final class JsNameChecker
implements DeclarationChecker {
    @NotNull
    public static final JsNameChecker INSTANCE = new JsNameChecker();

    private JsNameChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        DeclarationDescriptor declarationDescriptor;
        PsiElement jsNamePsi;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context, "context");
        BindingTrace trace2 = context.getTrace();
        if (descriptor2 instanceof PropertyDescriptor) {
            int namedAccessorCount;
            int n;
            List<PropertyAccessorDescriptor> list = ((PropertyDescriptor)descriptor2).getAccessors();
            Intrinsics.checkNotNullExpressionValue(list, "getAccessors(...)");
            Iterable $this$count$iv = list;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    PropertyAccessorDescriptor it = (PropertyAccessorDescriptor)element$iv;
                    boolean bl = false;
                    if (!(AnnotationsUtils.getJsName(it) != null) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = namedAccessorCount = count$iv;
            }
            if (namedAccessorCount > 0 && namedAccessorCount < ((PropertyDescriptor)descriptor2).getAccessors().size()) {
                trace2.report(ErrorsJs.JS_NAME_IS_NOT_ON_ALL_ACCESSORS.on(declaration));
            }
        }
        AnnotationDescriptor annotationDescriptor = AnnotationsUtils.getJsNameAnnotation(descriptor2);
        if (annotationDescriptor == null) {
            return;
        }
        AnnotationDescriptor jsName = annotationDescriptor;
        PsiElement psiElement = PsiSourceElementKt.getPsi(jsName.getSource());
        if (psiElement == null) {
            psiElement = jsNamePsi = (PsiElement)declaration;
        }
        if (AnnotationsUtils.getNameForAnnotatedObject(descriptor2, PredefinedAnnotation.NATIVE) != null) {
            trace2.report(ErrorsJs.JS_NAME_PROHIBITED_FOR_NAMED_NATIVE.on(jsNamePsi));
        }
        if (descriptor2 instanceof CallableMemberDescriptor) {
            Collection<? extends CallableMemberDescriptor> collection = ((CallableMemberDescriptor)descriptor2).getOverriddenDescriptors();
            Intrinsics.checkNotNullExpressionValue(collection, "getOverriddenDescriptors(...)");
            if (!collection.isEmpty()) {
                trace2.report(ErrorsJs.JS_NAME_PROHIBITED_FOR_OVERRIDE.on(jsNamePsi));
            }
        }
        if ((declarationDescriptor = descriptor2) instanceof ConstructorDescriptor) {
            if (((ConstructorDescriptor)descriptor2).isPrimary()) {
                trace2.report(ErrorsJs.JS_NAME_ON_PRIMARY_CONSTRUCTOR_PROHIBITED.on(jsNamePsi));
            }
        } else if (declarationDescriptor instanceof PropertyAccessorDescriptor) {
            if (AnnotationsUtils.getJsName(((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty()) != null) {
                trace2.report(ErrorsJs.JS_NAME_ON_ACCESSOR_AND_PROPERTY.on(jsNamePsi));
            }
        } else if (declarationDescriptor instanceof PropertyDescriptor && DescriptorUtilsKt.isExtension(descriptor2)) {
            trace2.report(ErrorsJs.JS_NAME_PROHIBITED_FOR_EXTENSION_PROPERTY.on(jsNamePsi));
        }
    }
}

