/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceElement;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsRuntimeAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "js.frontend"})
public final class JsRuntimeAnnotationChecker
implements DeclarationChecker {
    @NotNull
    public static final JsRuntimeAnnotationChecker INSTANCE = new JsRuntimeAnnotationChecker();

    private JsRuntimeAnnotationChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context, "context");
        for (AnnotationDescriptor annotation : descriptor2.getAnnotations()) {
            Object annotationPsi;
            ClassDescriptor annotationClass;
            if (DescriptorUtilsKt.getAnnotationClass(annotation) == null || DescriptorUtilsKt.getAnnotationRetention(annotationClass) != KotlinRetention.RUNTIME) continue;
            SourceElement sourceElement = annotation.getSource();
            Object object = sourceElement instanceof PsiSourceElement ? (PsiSourceElement)sourceElement : null;
            if (object == null || (object = object.getPsi()) == null) {
                object = annotationPsi = (PsiElement)declaration;
            }
            if (descriptor2 instanceof MemberDescriptor && DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)descriptor2)) {
                context.getTrace().report(ErrorsJs.RUNTIME_ANNOTATION_ON_EXTERNAL_DECLARATION.on((PsiElement)annotationPsi));
                continue;
            }
            context.getTrace().report(ErrorsJs.RUNTIME_ANNOTATION_NOT_SUPPORTED.on((PsiElement)annotationPsi));
        }
    }
}

