/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.js.naming.EncodeSignatureKt;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u00a8\u0006\u0006"}, d2={"generateSignature", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "escape", "s", "js.translator"})
@SourceDebugExtension(value={"SMAP\nsignatureUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 signatureUtils.kt\norg/jetbrains/kotlin/js/translate/utils/SignatureUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1557#2:84\n1628#2,3:85\n*S KotlinDebug\n*F\n+ 1 signatureUtils.kt\norg/jetbrains/kotlin/js/translate/utils/SignatureUtilsKt\n*L\n60#1:84\n60#1:85,3\n*E\n"})
public final class SignatureUtilsKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String generateSignature(@NotNull DeclarationDescriptor descriptor2) {
        String string2;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (DescriptorUtils.isDescriptorWithLocalVisibility(descriptor2)) {
            return null;
        }
        if (descriptor2 instanceof DeclarationDescriptorWithVisibility && Intrinsics.areEqual(((DeclarationDescriptorWithVisibility)descriptor2).getVisibility(), DescriptorVisibilities.PRIVATE) && !AnnotationsUtils.isNativeObject(descriptor2) && !AnnotationsUtils.isLibraryObject(descriptor2)) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor instanceof CallableDescriptor) {
            if (descriptor2 instanceof ConstructorDescriptor && ((ConstructorDescriptor)descriptor2).isPrimary()) {
                ClassDescriptor classDescriptor = ((ConstructorDescriptor)descriptor2).getConstructedClass();
                Intrinsics.checkNotNullExpressionValue(classDescriptor, "getConstructedClass(...)");
                return SignatureUtilsKt.generateSignature(classDescriptor);
            }
            DeclarationDescriptor declarationDescriptor2 = ((CallableDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue(declarationDescriptor2, "getContainingDeclaration(...)");
            String string3 = SignatureUtilsKt.generateSignature(declarationDescriptor2);
            if (string3 == null) {
                return null;
            }
            String parent2 = string3;
            if (!(descriptor2 instanceof VariableAccessorDescriptor) && !(descriptor2 instanceof ConstructorDescriptor) && ((CallableDescriptor)descriptor2).getName().isSpecial()) {
                return null;
            }
            String separator = descriptor2 instanceof FunctionDescriptor ? "#" : "!";
            StringBuilder stringBuilder = new StringBuilder().append(parent2).append(separator);
            String string4 = ((CallableDescriptor)descriptor2).getName().asString();
            Intrinsics.checkNotNullExpressionValue(string4, "asString(...)");
            string2 = stringBuilder.append(SignatureUtilsKt.escape(string4)).append('|').append(EncodeSignatureKt.encodeSignature((CallableDescriptor)descriptor2)).toString();
        } else if (declarationDescriptor instanceof PackageFragmentDescriptor) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String string5 = DescriptorUtilsKt.getModule(descriptor2).getName().asString();
            Intrinsics.checkNotNullExpressionValue(string5, "asString(...)");
            String module2 = string5;
            Object object = new String[]{module2};
            Sequence<String> sequence2 = SequencesKt.sequenceOf(object);
            List<Name> list = ((PackageFragmentDescriptor)descriptor2).getFqName().pathSegments();
            Intrinsics.checkNotNullExpressionValue(list, "pathSegments(...)");
            object = list;
            Sequence<String> sequence3 = sequence2;
            boolean $i$f$map = false;
            void var6_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Name name2 = (Name)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string6 = it.getIdentifier();
                Intrinsics.checkNotNullExpressionValue(string6, "getIdentifier(...)");
                collection.add(string6);
            }
            Sequence<String> parts = SequencesKt.plus(sequence3, (List)destination$iv$iv);
            string2 = SequencesKt.joinToString$default(parts, ".", null, null, 0, null, SignatureUtilsKt::generateSignature$lambda$1, 30, null);
        } else if (declarationDescriptor instanceof ClassDescriptor) {
            DeclarationDescriptor declarationDescriptor3 = ((ClassDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue(declarationDescriptor3, "getContainingDeclaration(...)");
            String string7 = SignatureUtilsKt.generateSignature(declarationDescriptor3);
            if (string7 == null) {
                return null;
            }
            String parent3 = string7;
            if (((ClassDescriptor)descriptor2).getName().isSpecial()) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder().append(parent3).append('$');
            String string8 = ((ClassDescriptor)descriptor2).getName().asString();
            Intrinsics.checkNotNullExpressionValue(string8, "asString(...)");
            string2 = stringBuilder.append(SignatureUtilsKt.escape(string8)).toString();
        } else {
            return null;
        }
        return string2;
    }

    private static final String escape(String s) {
        StringBuilder sb = new StringBuilder();
        int n = s.length();
        for (int j = 0; j < n; ++j) {
            String string2;
            char c = s.charAt(j);
            switch (c) {
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '*': 
                case '+': 
                case '-': 
                case '.': 
                case ':': 
                case '<': 
                case '>': 
                case '?': 
                case '\\': 
                case '|': {
                    string2 = "" + '\\' + c;
                    break;
                }
                default: {
                    string2 = String.valueOf(c);
                }
            }
            String escapedChar = string2;
            sb.append(escapedChar);
        }
        String string3 = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
        return string3;
    }

    private static final CharSequence generateSignature$lambda$1(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return SignatureUtilsKt.escape(it);
    }
}

