/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonCoroutineCodegenUtilKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.metadata.CoroutineMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.context.UsageTracker;
import org.jetbrains.kotlin.js.translate.expression.ExpressionVisitor;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsicWithReceiverComputed;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.TypeOfFIFKt;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.LambdaArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentUnmapped;
import org.jetbrains.kotlin.resolve.calls.model.DataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.checkers.PrimitiveNumericComparisonInfo;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0094\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a@\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u001aH\u0010\u000f\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00120\u0010\u0012\u0004\u0012\u0002H\u00130\u00110\u0010\"\u0004\b\u0000\u0010\u0012\"\u0004\b\u0001\u0010\u0013*\b\u0012\u0004\u0012\u0002H\u00120\u00102\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u00130\u0015\u001a\u0016\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n\u001a\u0016\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n\u001a\u0018\u0010\u0016\u001a\u00020\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\t\u001a\u00020\n\u001a\"\u0010\u001c\u001a\u00020\u0001*\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\b\u001a\"\u0010\u001f\u001a\u00020 *\u00020\n2\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%\u001a\"\u0010&\u001a\u00020 *\u00020'2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\f\u001a\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00020#0*2\u0006\u0010+\u001a\u00020#2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a&\u0010,\u001a\u00020\u00012\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020.2\u0006\u00102\u001a\u00020\b\u001a\u001a\u00106\u001a\u000200*\u00020\n2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u00107\u001a\u00020\b\u001a\u001a\u00106\u001a\u000200*\u00020\n2\u0006\u0010-\u001a\u0002002\u0006\u00107\u001a\u00020\b\u001a\u001c\u00108\u001a\b\u0012\u0004\u0012\u00020\u00010\u00102\u0006\u00109\u001a\u0002002\u0006\u0010-\u001a\u000200\u001a\u0016\u0010:\u001a\u00020\b*\u00020\n2\n\u0010;\u001a\u0006\u0012\u0002\b\u00030*\u001a\n\u0010<\u001a\u00020\u0018*\u00020\u0018\u001a\u0014\u0010=\u001a\u0004\u0018\u00010\u0018*\u00020\n2\u0006\u00107\u001a\u00020>\u001a\u0012\u0010?\u001a\u00020\u0018*\u00020\n2\u0006\u00107\u001a\u00020>\u001a\u0014\u0010@\u001a\u0004\u0018\u00010A*\u00020\n2\u0006\u00107\u001a\u00020>\u001a\n\u0010B\u001a\u00020\f*\u00020\u0005\u001a\n\u0010C\u001a\u00020\f*\u00020\u0005\"\u0015\u00103\u001a\u00020\u000e*\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b4\u00105\u00a8\u0006D"}, d2={"generateDelegateCall", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "fromDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "toDescriptor", "thisObject", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "detectDefaultParameters", "", "source", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "splitToRanges", "", "Lkotlin/Pair;", "T", "S", "classifier", "Lkotlin/Function1;", "getReferenceToJsClass", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "getReferenceToJsClassOrArray", "classifierDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "addFunctionToPrototype", "descriptor", "function", "addAccessorsToPrototype", "", "containingClass", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "literal", "Lorg/jetbrains/kotlin/js/backend/ast/JsObjectLiteral;", "fillCoroutineMetadata", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "hasController", "resolveAccessorCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "suspendPropertyDescriptor", "definePackageAlias", "name", "", "varName", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "tag", "parentRef", "finalElement", "getFinalElement", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "addFunctionButNotExport", "expression", "createPrototypeStatements", "superName", "createCoroutineResult", "resolvedCall", "refineType", "getPrecisePrimitiveType", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getPrecisePrimitiveTypeNotNull", "getPrimitiveNumericComparisonInfo", "Lorg/jetbrains/kotlin/resolve/checkers/PrimitiveNumericComparisonInfo;", "hasOrInheritsParametersWithDefaultValue", "hasOwnParametersWithDefaultValue", "js.translator"})
@SourceDebugExtension(value={"SMAP\nutils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 utils.kt\norg/jetbrains/kotlin/js/translate/utils/UtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,344:1\n1557#2:345\n1628#2,3:346\n1755#2,3:350\n1557#2:353\n1628#2,3:354\n1#3:349\n*S KotlinDebug\n*F\n+ 1 utils.kt\norg/jetbrains/kotlin/js/translate/utils/UtilsKt\n*L\n136#1:345\n136#1:346,3\n344#1:350,3\n339#1:353\n339#1:354,3\n*E\n"})
public final class UtilsKt {
    @NotNull
    public static final JsStatement generateDelegateCall(@NotNull ClassDescriptor classDescriptor, @NotNull FunctionDescriptor fromDescriptor, @NotNull FunctionDescriptor toDescriptor2, @NotNull JsExpression thisObject, @NotNull TranslationContext context, boolean detectDefaultParameters, @Nullable PsiElement source2) {
        PsiElement jsParamName;
        List<ValueParameterDescriptor> list;
        Intrinsics.checkNotNullParameter(classDescriptor, "classDescriptor");
        Intrinsics.checkNotNullParameter(fromDescriptor, "fromDescriptor");
        Intrinsics.checkNotNullParameter(toDescriptor2, "toDescriptor");
        Intrinsics.checkNotNullParameter(thisObject, "thisObject");
        Intrinsics.checkNotNullParameter(context, "context");
        JsName overriddenMemberFunctionName = UtilsKt.generateDelegateCall$getNameForFunctionWithPossibleDefaultParam(toDescriptor2, detectDefaultParameters, context);
        JsNameRef overriddenMemberFunctionRef = new JsNameRef(overriddenMemberFunctionName, thisObject);
        SmartList<JsParameter> parameters = new SmartList<JsParameter>();
        SmartList<JsNameRef> args2 = new SmartList<JsNameRef>();
        if (DescriptorUtils.isExtension(fromDescriptor)) {
            JsName jsName = JsScope.declareTemporaryName(Namer.getReceiverParameterName());
            Intrinsics.checkNotNullExpressionValue(jsName, "declareTemporaryName(...)");
            JsName extensionFunctionReceiverName = jsName;
            parameters.add(new JsParameter(extensionFunctionReceiverName));
            args2.add(new JsNameRef(extensionFunctionReceiverName));
        }
        if (fromDescriptor.isSuspend()) {
            List<ValueParameterDescriptor> list2 = fromDescriptor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list2, "getValueParameters(...)");
            Collection collection = list2;
            ValueParameterDescriptor valueParameterDescriptor = context.getContinuationParameterDescriptor();
            Intrinsics.checkNotNull(valueParameterDescriptor);
            list = CollectionsKt.plus(collection, valueParameterDescriptor);
        } else {
            List<ValueParameterDescriptor> list3 = fromDescriptor.getValueParameters();
            list = list3;
            Intrinsics.checkNotNullExpressionValue(list3, "getValueParameters(...)");
        }
        List<ValueParameterDescriptor> valueParameterDescriptors = list;
        for (ValueParameterDescriptor param2 : valueParameterDescriptors) {
            String paramName;
            Intrinsics.checkNotNullExpressionValue(param2.getName().asString(), "asString(...)");
            Intrinsics.checkNotNullExpressionValue(JsScope.declareTemporaryName(paramName), "declareTemporaryName(...)");
            parameters.add(new JsParameter((JsName)((Object)jsParamName)));
            args2.add(new JsNameRef((JsName)((Object)jsParamName)));
        }
        FunctionIntrinsic intrinsic = context.intrinsics().getFunctionIntrinsic(toDescriptor2, context);
        JsExpression invocation = intrinsic instanceof FunctionIntrinsicWithReceiverComputed ? ((FunctionIntrinsicWithReceiverComputed)intrinsic).apply(thisObject, (List<? extends JsExpression>)args2, context) : (JsExpression)new JsInvocation((JsExpression)overriddenMemberFunctionRef, (List<? extends JsExpression>)args2);
        invocation.setSource(source2);
        JsFunction jsFunction = TranslationUtils.simpleReturnFunction(context.scope(), invocation);
        Intrinsics.checkNotNullExpressionValue(jsFunction, "simpleReturnFunction(...)");
        JsFunction functionObject = jsFunction;
        functionObject.setSource(source2);
        PsiElement psiElement = source2;
        jsParamName = psiElement != null ? UtilsKt.getFinalElement(psiElement) : null;
        functionObject.getBody().setSource(jsParamName instanceof LeafPsiElement ? (LeafPsiElement)jsParamName : null);
        functionObject.getParameters().addAll((Collection<JsParameter>)parameters);
        if (MetadataProperties.isSuspend(functionObject)) {
            UtilsKt.fillCoroutineMetadata(functionObject, context, fromDescriptor, false);
        }
        JsName fromFunctionName = UtilsKt.generateDelegateCall$getNameForFunctionWithPossibleDefaultParam(fromDescriptor, detectDefaultParameters, context);
        JsExpression jsExpression = JsAstUtils.prototypeOf(context.getInnerReference(classDescriptor));
        Intrinsics.checkNotNullExpressionValue(jsExpression, "prototypeOf(...)");
        JsExpression prototypeRef = jsExpression;
        JsNameRef functionRef = new JsNameRef(fromFunctionName, prototypeRef);
        JsStatement jsStatement = JsAstUtils.assignment(functionRef, functionObject).makeStmt();
        Intrinsics.checkNotNullExpressionValue(jsStatement, "makeStmt(...)");
        return jsStatement;
    }

    @NotNull
    public static final <T, S> List<Pair<List<T>, S>> splitToRanges(@NotNull List<? extends T> $this$splitToRanges, @NotNull Function1<? super T, ? extends S> classifier) {
        Intrinsics.checkNotNullParameter($this$splitToRanges, "<this>");
        Intrinsics.checkNotNullParameter(classifier, "classifier");
        if ($this$splitToRanges.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        int lastIndex = 0;
        S lastClass = classifier.invoke($this$splitToRanges.get(0));
        List result2 = new ArrayList();
        Iterator iterator2 = SequencesKt.drop(SequencesKt.withIndex(CollectionsKt.asSequence((Iterable)$this$splitToRanges)), 1).iterator();
        while (iterator2.hasNext()) {
            IndexedValue indexedValue = iterator2.next();
            int index = indexedValue.component1();
            Object e = indexedValue.component2();
            S cls = classifier.invoke(e);
            if (Intrinsics.areEqual(cls, lastClass)) continue;
            ((Collection)result2).add(new Pair<List<? extends T>, S>($this$splitToRanges.subList(lastIndex, index), lastClass));
            lastClass = cls;
            lastIndex = index;
        }
        ((Collection)result2).add(new Pair<List<? extends T>, S>($this$splitToRanges.subList(lastIndex, $this$splitToRanges.size()), lastClass));
        return result2;
    }

    @NotNull
    public static final JsExpression getReferenceToJsClass(@NotNull KotlinType type2, @NotNull TranslationContext context) {
        JsExpression jsExpression;
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(context, "context");
        JsExpression it = jsExpression = UtilsKt.getReferenceToJsClassOrArray(type2, context);
        boolean bl = false;
        MetadataProperties.setKType(it, TypeOfFIFKt.createKType(context, type2));
        return jsExpression;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JsExpression getReferenceToJsClassOrArray(@NotNull KotlinType type2, @NotNull TranslationContext context) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(context, "context");
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            void $this$mapTo$iv$iv;
            Collection<KotlinType> collection = type2.getConstructor().getSupertypes();
            Intrinsics.checkNotNullExpressionValue(collection, "getSupertypes(...)");
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KotlinType kotlinType = (KotlinType)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(UtilsKt.getReferenceToJsClass(it.getConstructor().getDeclarationDescriptor(), context));
            }
            List list = (List)destination$iv$iv;
            return new JsArrayLiteral(list);
        }
        ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
        return UtilsKt.getReferenceToJsClass(classifierDescriptor2, context);
    }

    @NotNull
    public static final JsExpression getReferenceToJsClass(@Nullable ClassifierDescriptor classifierDescriptor, @NotNull TranslationContext context) {
        JsExpression jsExpression;
        Intrinsics.checkNotNullParameter(context, "context");
        ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
        if (classifierDescriptor2 instanceof ClassDescriptor) {
            jsExpression = ReferenceTranslator.translateAsTypeReference((ClassDescriptor)classifierDescriptor, context);
        } else if (classifierDescriptor2 instanceof TypeParameterDescriptor) {
            boolean bl = ((TypeParameterDescriptor)classifierDescriptor).isReified();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            UsageTracker usageTracker = context.usageTracker();
            if (usageTracker != null) {
                usageTracker.used(classifierDescriptor);
            }
            if ((jsExpression = context.captureTypeIfNeedAndGetCapturedName((TypeParameterDescriptor)classifierDescriptor)) == null) {
                JsNameRef jsNameRef = context.getNameForDescriptor(classifierDescriptor).makeRef();
                Intrinsics.checkNotNullExpressionValue(jsNameRef, "makeRef(...)");
                jsExpression = jsNameRef;
            }
        } else {
            throw new IllegalStateException("Can't get reference for " + classifierDescriptor);
        }
        JsExpression jsExpression2 = jsExpression;
        Intrinsics.checkNotNull(jsExpression2);
        JsExpression it = jsExpression2;
        boolean bl = false;
        MetadataProperties.setPrimitiveKClass(it, ExpressionVisitor.getPrimitiveClass(context, classifierDescriptor));
        return jsExpression2;
    }

    @NotNull
    public static final JsStatement addFunctionToPrototype(@NotNull TranslationContext $this$addFunctionToPrototype, @NotNull ClassDescriptor classDescriptor, @NotNull FunctionDescriptor descriptor2, @NotNull JsExpression function2) {
        Intrinsics.checkNotNullParameter($this$addFunctionToPrototype, "<this>");
        Intrinsics.checkNotNullParameter(classDescriptor, "classDescriptor");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(function2, "function");
        JsExpression jsExpression = JsAstUtils.prototypeOf($this$addFunctionToPrototype.getInnerReference(classDescriptor));
        Intrinsics.checkNotNullExpressionValue(jsExpression, "prototypeOf(...)");
        JsExpression prototypeRef = jsExpression;
        JsNameRef functionRef = new JsNameRef($this$addFunctionToPrototype.getNameForDescriptor(descriptor2), prototypeRef);
        JsStatement jsStatement = JsAstUtils.assignment(functionRef, function2).makeStmt();
        Intrinsics.checkNotNullExpressionValue(jsStatement, "makeStmt(...)");
        return jsStatement;
    }

    public static final void addAccessorsToPrototype(@NotNull TranslationContext $this$addAccessorsToPrototype, @NotNull ClassDescriptor containingClass, @NotNull PropertyDescriptor propertyDescriptor, @NotNull JsObjectLiteral literal) {
        Intrinsics.checkNotNullParameter($this$addAccessorsToPrototype, "<this>");
        Intrinsics.checkNotNullParameter(containingClass, "containingClass");
        Intrinsics.checkNotNullParameter(propertyDescriptor, "propertyDescriptor");
        Intrinsics.checkNotNullParameter(literal, "literal");
        JsExpression jsExpression = JsAstUtils.prototypeOf($this$addAccessorsToPrototype.getInnerReference(containingClass));
        Intrinsics.checkNotNullExpressionValue(jsExpression, "prototypeOf(...)");
        JsExpression prototypeRef = jsExpression;
        JsName jsName = $this$addAccessorsToPrototype.getNameForDescriptor(propertyDescriptor);
        Intrinsics.checkNotNullExpressionValue(jsName, "getNameForDescriptor(...)");
        JsName propertyName = jsName;
        JsInvocation jsInvocation = JsAstUtils.defineProperty(prototypeRef, propertyName.getIdent(), literal);
        Intrinsics.checkNotNullExpressionValue(jsInvocation, "defineProperty(...)");
        JsInvocation defineProperty = jsInvocation;
        $this$addAccessorsToPrototype.addDeclarationStatement(defineProperty.makeStmt());
    }

    public static final void fillCoroutineMetadata(@NotNull JsFunction $this$fillCoroutineMetadata, @NotNull TranslationContext context, @NotNull FunctionDescriptor descriptor2, boolean hasController) {
        Intrinsics.checkNotNullParameter($this$fillCoroutineMetadata, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        PropertyDescriptor suspendPropertyDescriptor = (PropertyDescriptor)CollectionsKt.first((Iterable)context.getCurrentModule().getPackage(StandardNames.COROUTINES_INTRINSICS_PACKAGE_FQ_NAME).getMemberScope().getContributedVariables(CommonCoroutineCodegenUtilKt.getCOROUTINE_SUSPENDED_NAME(), NoLookupLocation.FROM_BACKEND));
        JsExpression suspendObject = CallTranslator.INSTANCE.translateGet(context, UtilsKt.resolveAccessorCall(suspendPropertyDescriptor, context), null);
        JsName jsName = context.getNameForDescriptor(TranslationUtils.getCoroutineDoResumeFunction(context));
        Intrinsics.checkNotNullExpressionValue(jsName, "getNameForDescriptor(...)");
        JsName jsName2 = jsName;
        JsExpression jsExpression = ReferenceTranslator.translateAsTypeReference(TranslationUtils.getCoroutineBaseClass(context), context);
        Intrinsics.checkNotNullExpressionValue(jsExpression, "translateAsTypeReference(...)");
        JsExpression jsExpression2 = jsExpression;
        JsName jsName3 = UtilsKt.fillCoroutineMetadata$getCoroutinePropertyName(context, "state");
        JsName jsName4 = UtilsKt.fillCoroutineMetadata$getCoroutinePropertyName(context, "exceptionState");
        JsName jsName5 = UtilsKt.fillCoroutineMetadata$getCoroutinePropertyName(context, "finallyPath");
        JsName jsName6 = UtilsKt.fillCoroutineMetadata$getCoroutinePropertyName(context, "result");
        JsName jsName7 = UtilsKt.fillCoroutineMetadata$getCoroutinePropertyName(context, "exception");
        boolean bl = descriptor2.getDispatchReceiverParameter() != null;
        SourceElement sourceElement = descriptor2.getSource();
        Intrinsics.checkNotNullExpressionValue(sourceElement, "getSource(...)");
        PsiElement psiElement = PsiSourceElementKt.getPsi(sourceElement);
        MetadataProperties.setCoroutineMetadata($this$fillCoroutineMetadata, new CoroutineMetadata(jsName2, jsName3, jsName4, jsName5, jsName6, jsName7, jsExpression2, suspendObject, hasController, bl, psiElement));
    }

    private static final ResolvedCall<PropertyDescriptor> resolveAccessorCall(PropertyDescriptor suspendPropertyDescriptor, TranslationContext context) {
        return new ResolvedCall<PropertyDescriptor>(context, suspendPropertyDescriptor){
            final /* synthetic */ TranslationContext $context;
            final /* synthetic */ PropertyDescriptor $suspendPropertyDescriptor;
            {
                this.$context = $context;
                this.$suspendPropertyDescriptor = $suspendPropertyDescriptor;
            }

            public ResolutionStatus getStatus() {
                return ResolutionStatus.SUCCESS;
            }

            public Call getCall() {
                return new Call(this.$context){
                    final /* synthetic */ TranslationContext $context;
                    {
                        this.$context = $context;
                    }

                    public ASTNode getCallOperationNode() {
                        return null;
                    }

                    public Receiver getExplicitReceiver() {
                        return null;
                    }

                    public ReceiverValue getDispatchReceiver() {
                        return null;
                    }

                    public KtExpression getCalleeExpression() {
                        return null;
                    }

                    public KtValueArgumentList getValueArgumentList() {
                        return null;
                    }

                    public List<ValueArgument> getValueArguments() {
                        return CollectionsKt.emptyList();
                    }

                    public List<LambdaArgument> getFunctionLiteralArguments() {
                        return CollectionsKt.emptyList();
                    }

                    public List<KtTypeProjection> getTypeArguments() {
                        return CollectionsKt.emptyList();
                    }

                    public KtTypeArgumentList getTypeArgumentList() {
                        return null;
                    }

                    public KtElement getCallElement() {
                        Project project = this.$context.getConfig().getProject();
                        Intrinsics.checkNotNullExpressionValue(project, "getProject(...)");
                        return new KtPsiFactory(project, false, 2, null).createExpression("COROUTINE_SUSPENDED");
                    }

                    public Call.CallType getCallType() {
                        return Call.CallType.DEFAULT;
                    }
                };
            }

            public PropertyDescriptor getCandidateDescriptor() {
                return this.$suspendPropertyDescriptor;
            }

            public PropertyDescriptor getResultingDescriptor() {
                return this.$suspendPropertyDescriptor;
            }

            public Void getExtensionReceiver() {
                return null;
            }

            public Void getDispatchReceiver() {
                return null;
            }

            public List<ReceiverValue> getContextReceivers() {
                return CollectionsKt.emptyList();
            }

            public ExplicitReceiverKind getExplicitReceiverKind() {
                return ExplicitReceiverKind.NO_EXPLICIT_RECEIVER;
            }

            public Map<ValueParameterDescriptor, ResolvedValueArgument> getValueArguments() {
                return new LinkedHashMap<K, V>();
            }

            public List<ResolvedValueArgument> getValueArgumentsByIndex() {
                return new ArrayList<E>();
            }

            public ArgumentUnmapped getArgumentMapping(ValueArgument valueArgument) {
                Intrinsics.checkNotNullParameter(valueArgument, "valueArgument");
                return ArgumentUnmapped.INSTANCE;
            }

            public Map<TypeParameterDescriptor, KotlinType> getTypeArguments() {
                return new LinkedHashMap<K, V>();
            }

            public DataFlowInfoForArguments getDataFlowInfoForArguments() {
                throw new IllegalStateException();
            }

            public KotlinType getSmartCastDispatchReceiverType() {
                return null;
            }
        };
    }

    @NotNull
    public static final JsStatement definePackageAlias(@NotNull String name2, @NotNull JsName varName, @NotNull String tag, @NotNull JsExpression parentRef) {
        JsVars jsVars;
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(varName, "varName");
        Intrinsics.checkNotNullParameter(tag, "tag");
        Intrinsics.checkNotNullParameter(parentRef, "parentRef");
        JsNameRef selfRef = new JsNameRef(name2, parentRef);
        JsBinaryOperation jsBinaryOperation = JsAstUtils.or(selfRef, JsAstUtils.assignment(selfRef.deepCopy(), new JsObjectLiteral(false)));
        Intrinsics.checkNotNullExpressionValue(jsBinaryOperation, "or(...)");
        JsBinaryOperation rhs = jsBinaryOperation;
        JsVars $this$definePackageAlias_u24lambda_u243 = jsVars = JsAstUtils.newVar(varName, rhs);
        boolean bl = false;
        Intrinsics.checkNotNull($this$definePackageAlias_u24lambda_u243);
        MetadataProperties.setExportedPackage($this$definePackageAlias_u24lambda_u243, tag);
        JsVars jsVars2 = jsVars;
        Intrinsics.checkNotNullExpressionValue(jsVars2, "apply(...)");
        return jsVars2;
    }

    @NotNull
    public static final PsiElement getFinalElement(@NotNull PsiElement $this$finalElement) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter($this$finalElement, "<this>");
        PsiElement psiElement2 = $this$finalElement;
        if (psiElement2 instanceof KtFunctionLiteral) {
            psiElement = ((KtFunctionLiteral)$this$finalElement).getRBrace();
            if (psiElement == null) {
                psiElement = $this$finalElement;
            }
        } else if (psiElement2 instanceof KtDeclarationWithBody) {
            psiElement = ((KtDeclarationWithBody)$this$finalElement).getBodyBlockExpression();
            if (psiElement == null || (psiElement = ((KtBlockExpression)psiElement).getRBrace()) == null) {
                KtExpression ktExpression = ((KtDeclarationWithBody)$this$finalElement).getBodyExpression();
                psiElement = ktExpression != null ? (PsiElement)ktExpression : $this$finalElement;
            }
        } else if (psiElement2 instanceof KtLambdaExpression) {
            psiElement = ((KtLambdaExpression)$this$finalElement).getBodyExpression();
            if (psiElement == null || (psiElement = ((KtBlockExpression)psiElement).getRBrace()) == null) {
                psiElement = $this$finalElement;
            }
        } else {
            psiElement = $this$finalElement;
        }
        return psiElement;
    }

    @NotNull
    public static final JsName addFunctionButNotExport(@NotNull TranslationContext $this$addFunctionButNotExport, @NotNull FunctionDescriptor descriptor2, @NotNull JsExpression expression2) {
        Intrinsics.checkNotNullParameter($this$addFunctionButNotExport, "<this>");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        JsName jsName = $this$addFunctionButNotExport.getInnerNameForDescriptor(descriptor2);
        Intrinsics.checkNotNullExpressionValue(jsName, "getInnerNameForDescriptor(...)");
        return UtilsKt.addFunctionButNotExport($this$addFunctionButNotExport, jsName, expression2);
    }

    @NotNull
    public static final JsName addFunctionButNotExport(@NotNull TranslationContext $this$addFunctionButNotExport, @NotNull JsName name2, @NotNull JsExpression expression2) {
        Intrinsics.checkNotNullParameter($this$addFunctionButNotExport, "<this>");
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (expression2 instanceof JsFunction) {
            ((JsFunction)expression2).setName(name2);
            $this$addFunctionButNotExport.addDeclarationStatement(expression2.makeStmt());
        } else {
            $this$addFunctionButNotExport.addDeclarationStatement(JsAstUtils.newVar(name2, expression2));
        }
        return name2;
    }

    @NotNull
    public static final List<JsStatement> createPrototypeStatements(@NotNull JsName superName, @NotNull JsName name2) {
        Intrinsics.checkNotNullParameter(superName, "superName");
        Intrinsics.checkNotNullParameter(name2, "name");
        JsNameRef jsNameRef = superName.makeRef();
        Intrinsics.checkNotNullExpressionValue(jsNameRef, "makeRef(...)");
        JsNameRef superclassRef = jsNameRef;
        JsExpression jsExpression = JsAstUtils.prototypeOf(superclassRef);
        Intrinsics.checkNotNullExpressionValue(jsExpression, "prototypeOf(...)");
        JsExpression superPrototype = jsExpression;
        JsExpression[] jsExpressionArray = new JsExpression[]{superPrototype};
        JsInvocation superPrototypeInstance = new JsInvocation((JsExpression)new JsNameRef("create", "Object"), jsExpressionArray);
        JsNameRef jsNameRef2 = name2.makeRef();
        Intrinsics.checkNotNullExpressionValue(jsNameRef2, "makeRef(...)");
        JsNameRef classRef = jsNameRef2;
        JsExpression jsExpression2 = JsAstUtils.prototypeOf(classRef);
        Intrinsics.checkNotNullExpressionValue(jsExpression2, "prototypeOf(...)");
        JsExpression prototype = jsExpression2;
        JsStatement jsStatement = JsAstUtils.assignment(prototype, superPrototypeInstance).makeStmt();
        Intrinsics.checkNotNullExpressionValue(jsStatement, "makeStmt(...)");
        JsStatement prototypeStatement = jsStatement;
        JsNameRef constructorRef = new JsNameRef("constructor", prototype.deepCopy());
        JsStatement jsStatement2 = JsAstUtils.assignment(constructorRef, classRef.deepCopy()).makeStmt();
        Intrinsics.checkNotNullExpressionValue(jsStatement2, "makeStmt(...)");
        JsStatement constructorStatement = jsStatement2;
        JsStatement[] jsStatementArray = new JsStatement[]{prototypeStatement, constructorStatement};
        return CollectionsKt.listOf(jsStatementArray);
    }

    @NotNull
    public static final JsExpression createCoroutineResult(@NotNull TranslationContext $this$createCoroutineResult, @NotNull ResolvedCall<?> resolvedCall2) {
        JsNameRef jsNameRef;
        Intrinsics.checkNotNullParameter($this$createCoroutineResult, "<this>");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        KtElement ktElement = resolvedCall2.getCall().getCallElement();
        Intrinsics.checkNotNullExpressionValue(ktElement, "getCallElement(...)");
        KtElement callElement = ktElement;
        JsExpression coroutineRef = TranslationUtils.translateContinuationArgument($this$createCoroutineResult).source(callElement);
        JsNameRef $this$createCoroutineResult_u24lambda_u244 = jsNameRef = new JsNameRef("$$coroutineResult$$", coroutineRef);
        boolean bl = false;
        MetadataProperties.setSideEffects($this$createCoroutineResult_u24lambda_u244, SideEffectKind.DEPENDS_ON_STATE);
        $this$createCoroutineResult_u24lambda_u244.setSource(callElement);
        MetadataProperties.setCoroutineResult($this$createCoroutineResult_u24lambda_u244, true);
        MetadataProperties.setSynthetic($this$createCoroutineResult_u24lambda_u244, true);
        return jsNameRef;
    }

    @NotNull
    public static final KotlinType refineType(@NotNull KotlinType $this$refineType) {
        KotlinType kotlinType;
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter($this$refineType, "<this>");
            Set<KotlinType> set = TypeUtils.getAllSupertypes($this$refineType);
            Intrinsics.checkNotNullExpressionValue(set, "getAllSupertypes(...)");
            Iterable iterable = set;
            for (Object t : iterable) {
                KotlinType p0 = (KotlinType)t;
                boolean bl = false;
                if (!KotlinBuiltIns.isPrimitiveTypeOrNullablePrimitiveType(p0)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        if ((kotlinType = (KotlinType)v1) == null) {
            kotlinType = $this$refineType;
        }
        return kotlinType;
    }

    @Nullable
    public static final KotlinType getPrecisePrimitiveType(@NotNull TranslationContext $this$getPrecisePrimitiveType, @NotNull KtExpression expression2) {
        Intrinsics.checkNotNullParameter($this$getPrecisePrimitiveType, "<this>");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        BindingContext bindingContext = $this$getPrecisePrimitiveType.bindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "bindingContext(...)");
        BindingContext bindingContext2 = bindingContext;
        KotlinType kotlinType = bindingContext2.getType(expression2);
        if (kotlinType == null) {
            return null;
        }
        KotlinType ktType = kotlinType;
        return UtilsKt.refineType(ktType);
    }

    @NotNull
    public static final KotlinType getPrecisePrimitiveTypeNotNull(@NotNull TranslationContext $this$getPrecisePrimitiveTypeNotNull, @NotNull KtExpression expression2) {
        Intrinsics.checkNotNullParameter($this$getPrecisePrimitiveTypeNotNull, "<this>");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        KotlinType kotlinType = UtilsKt.getPrecisePrimitiveType($this$getPrecisePrimitiveTypeNotNull, expression2);
        if (kotlinType == null) {
            throw new IllegalStateException("Type must be not null for " + expression2);
        }
        return kotlinType;
    }

    @Nullable
    public static final PrimitiveNumericComparisonInfo getPrimitiveNumericComparisonInfo(@NotNull TranslationContext $this$getPrimitiveNumericComparisonInfo, @NotNull KtExpression expression2) {
        Intrinsics.checkNotNullParameter($this$getPrimitiveNumericComparisonInfo, "<this>");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        CompilerConfiguration compilerConfiguration = $this$getPrimitiveNumericComparisonInfo.getConfig().getConfiguration();
        Intrinsics.checkNotNullExpressionValue(compilerConfiguration, "getConfiguration(...)");
        LanguageVersionSettings it = CommonConfigurationKeysKt.getLanguageVersionSettings(compilerConfiguration);
        boolean bl = false;
        return it.supportsFeature(LanguageFeature.ProperIeee754Comparisons) ? (PrimitiveNumericComparisonInfo)$this$getPrimitiveNumericComparisonInfo.bindingContext().get(BindingContext.PRIMITIVE_NUMERIC_COMPARISON_INFO, expression2) : null;
    }

    public static final boolean hasOrInheritsParametersWithDefaultValue(@NotNull FunctionDescriptor $this$hasOrInheritsParametersWithDefaultValue) {
        Intrinsics.checkNotNullParameter($this$hasOrInheritsParametersWithDefaultValue, "<this>");
        Boolean bl = DFS.ifAny((Collection)CollectionsKt.listOf($this$hasOrInheritsParametersWithDefaultValue), UtilsKt::hasOrInheritsParametersWithDefaultValue$lambda$7, UtilsKt::hasOrInheritsParametersWithDefaultValue$lambda$8);
        Intrinsics.checkNotNullExpressionValue(bl, "ifAny(...)");
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasOwnParametersWithDefaultValue(@NotNull FunctionDescriptor $this$hasOwnParametersWithDefaultValue) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$hasOwnParametersWithDefaultValue, "<this>");
        List<ValueParameterDescriptor> list = $this$hasOwnParametersWithDefaultValue.getOriginal().getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
        Iterable $this$any$iv = list;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
            boolean bl2 = false;
            if (it.declaresDefaultValue()) return true;
            Intrinsics.checkNotNull(it);
            if (ArgumentsUtilsKt.isActualParameterWithCorrespondingExpectedDefault(it)) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private static final JsName generateDelegateCall$getNameForFunctionWithPossibleDefaultParam(FunctionDescriptor $this$generateDelegateCall_u24getNameForFunctionWithPossibleDefaultParam, boolean $detectDefaultParameters, TranslationContext $context) {
        JsName jsName = $detectDefaultParameters && UtilsKt.hasOrInheritsParametersWithDefaultValue($this$generateDelegateCall_u24getNameForFunctionWithPossibleDefaultParam) ? $context.scope().declareName($context.getNameForDescriptor($this$generateDelegateCall_u24getNameForFunctionWithPossibleDefaultParam).getIdent() + "$default") : $context.getNameForDescriptor($this$generateDelegateCall_u24getNameForFunctionWithPossibleDefaultParam);
        Intrinsics.checkNotNull(jsName);
        return jsName;
    }

    private static final JsName fillCoroutineMetadata$getCoroutinePropertyName(TranslationContext $context, String id) {
        JsName jsName = $context.getNameForDescriptor(TranslationUtils.getCoroutineProperty($context, id));
        Intrinsics.checkNotNullExpressionValue(jsName, "getNameForDescriptor(...)");
        return jsName;
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable hasOrInheritsParametersWithDefaultValue$lambda$7(FunctionDescriptor current) {
        void $this$mapTo$iv$iv;
        Collection<? extends FunctionDescriptor> collection = current.getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(collection, "getOverriddenDescriptors(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FunctionDescriptor functionDescriptor = (FunctionDescriptor)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getOriginal());
        }
        return (List)destination$iv$iv;
    }

    private static final Boolean hasOrInheritsParametersWithDefaultValue$lambda$8(FunctionDescriptor it) {
        Intrinsics.checkNotNull(it);
        return UtilsKt.hasOwnParametersWithDefaultValue(it);
    }
}

